/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.cv;

import ai.djl.Application;
import ai.djl.MalformedModelException;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.training.util.ProgressBar;
import ai.djl.translate.TranslateException;
import ai.djl.util.Progress;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;

public class ZooImageGenerationPredictor
extends AbstractPredictor {
    protected ZooModel<int[], Image[]> model;

    public ZooImageGenerationPredictor(String artifactId) throws ModelNotFoundException, MalformedModelException, IOException {
        Criteria criteria = Criteria.builder().optApplication(Application.CV.IMAGE_GENERATION).setTypes(int[].class, Image[].class).optArtifactId(artifactId).optProgress((Progress)new ProgressBar()).build();
        this.model = ModelZoo.loadModel((Criteria)criteria);
    }

    @Override
    public void process(Exchange exchange) {
        if (!(exchange.getIn().getBody() instanceof int[])) {
            throw new RuntimeCamelException("Data type is not supported. Body should be int[]");
        }
        int[] seed = (int[])exchange.getIn().getBody(int[].class);
        Image[] result = this.predict(exchange, seed);
        exchange.getIn().setBody((Object)result);
    }

    protected Image[] predict(Exchange exchange, int[] seed) {
        Image[] imageArray;
        block8: {
            exchange.getIn().setHeader("CamelDjlInput", (Object)seed);
            Predictor predictor = this.model.newPredictor();
            try {
                imageArray = (Image[])predictor.predict((Object)seed);
                if (predictor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (predictor != null) {
                        try {
                            predictor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (TranslateException e) {
                    throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
                }
            }
            predictor.close();
        }
        return imageArray;
    }
}

