/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.djl.model.cv;

import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.repository.zoo.ZooModel;
import ai.djl.translate.TranslateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.djl.model.AbstractPredictor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCvZooPredictor<T>
extends AbstractPredictor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCvZooPredictor.class);
    protected ZooModel<Image, T> model;

    @Override
    public void process(Exchange exchange) {
        T result;
        Object body = exchange.getIn().getBody();
        if (body instanceof Image) {
            result = this.predict(exchange, (Image)exchange.getIn().getBody(Image.class));
        } else if (body instanceof byte[]) {
            byte[] bytes = (byte[])exchange.getIn().getBody(byte[].class);
            result = this.predict(exchange, new ByteArrayInputStream(bytes));
        } else if (body instanceof File) {
            result = this.predict(exchange, (File)exchange.getIn().getBody(File.class));
        } else if (body instanceof InputStream) {
            result = this.predict(exchange, (InputStream)exchange.getIn().getBody(InputStream.class));
        } else {
            throw new RuntimeCamelException("Data type is not supported. Body should be ai.djl.modality.cv.Image, byte[], InputStream or File");
        }
        exchange.getIn().setBody(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, File input) {
        try (FileInputStream fileInputStream = new FileInputStream(input);){
            Image image = ImageFactory.getInstance().fromInputStream((InputStream)fileInputStream);
            T t = this.predict(exchange, image);
            return t;
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    protected T predict(Exchange exchange, InputStream input) {
        try {
            Image image = ImageFactory.getInstance().fromInputStream(input);
            return this.predict(exchange, image);
        }
        catch (IOException e) {
            LOG.error("Couldn't transform input into a BufferedImage");
            throw new RuntimeCamelException("Couldn't transform input into a BufferedImage", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected T predict(Exchange exchange, Image image) {
        exchange.getIn().setHeader("CamelDjlInput", (Object)image);
        try (Predictor predictor = this.model.newPredictor();){
            Object object = predictor.predict((Object)image);
            return (T)object;
        }
        catch (TranslateException e) {
            throw new RuntimeCamelException("Could not process input or output", (Throwable)e);
        }
    }
}

