/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MySqlConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,mysql";
    @UriParam(label="consumer,mysql", defaultValue="minimal")
    private String snapshotLockingMode = "minimal";
    @UriParam(label="consumer,mysql")
    private String messageKeyColumns;
    @UriParam(label="consumer,mysql", defaultValue="io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory")
    private String transactionMetadataFactory = "io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory";
    @UriParam(label="consumer,mysql")
    private String customMetricTags;
    @UriParam(label="consumer,mysql", defaultValue="source")
    private String signalEnabledChannels = "source";
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean includeSchemaChanges = true;
    @UriParam(label="consumer,mysql", defaultValue="com.mysql.cj.jdbc.Driver")
    private String databaseJdbcDriver = "com.mysql.cj.jdbc.Driver";
    @UriParam(label="consumer,mysql")
    private String signalDataCollection;
    @UriParam(label="consumer,mysql")
    private String databaseInitialStatements;
    @UriParam(label="consumer,mysql")
    private String converters;
    @UriParam(label="consumer,mysql")
    private int snapshotFetchSize;
    @UriParam(label="consumer,mysql", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean useNongracefulDisconnect = false;
    @UriParam(label="consumer,mysql", defaultValue="disabled")
    private String snapshotTablesOrderByRowCount = "disabled";
    @UriParam(label="consumer,mysql")
    private String gtidSourceExcludes;
    @UriParam(label="consumer,mysql")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,mysql")
    private String databaseSslKeystore;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean incrementalSnapshotAllowSchemaChanges = false;
    @UriParam(label="consumer,mysql", defaultValue="jdbc:mysql")
    private String databaseProtocol = "jdbc:mysql";
    @UriParam(label="consumer,mysql", defaultValue="1000")
    private int minRowCountToStreamResults = 1000;
    @UriParam(label="consumer,mysql")
    private String tableExcludeList;
    @UriParam(label="consumer,mysql")
    private String databaseExcludeList;
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean gtidSourceFilterDmlEvents = true;
    @UriParam(label="consumer,mysql", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,mysql", defaultValue="io.debezium.schema.SchemaTopicNamingStrategy")
    private String topicNamingStrategy = "io.debezium.schema.SchemaTopicNamingStrategy";
    @UriParam(label="consumer,mysql", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,mysql", defaultValue="30s", javaType="java.time.Duration")
    private int connectTimeoutMs = 30000;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotData = false;
    @UriParam(label="consumer,mysql", defaultValue="1024")
    private int incrementalSnapshotChunkSize = 1024;
    @UriParam(label="consumer,mysql", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,mysql", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnDataError = false;
    @UriParam(label="consumer,mysql")
    private String schemaHistoryInternalFileFilename;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,mysql", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,mysql")
    private String snapshotQueryModeCustomName;
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean tableIgnoreBuiltin = true;
    @UriParam(label="consumer,mysql")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean snapshotModeConfigurationBasedStartStream = false;
    @UriParam(label="consumer,mysql", defaultValue="long")
    private String bigintUnsignedHandlingMode = "long";
    @UriParam(label="consumer,mysql")
    private long databaseServerId;
    @UriParam(label="consumer,mysql", defaultValue="5s", javaType="java.time.Duration")
    private long signalPollIntervalMs = 5000L;
    @UriParam(label="consumer,mysql")
    private String notificationEnabledChannels;
    @UriParam(label="consumer,mysql", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,mysql", defaultValue="1")
    private int snapshotMaxThreads = 1;
    @UriParam(label="consumer,mysql")
    private String notificationSinkTopicName;
    @UriParam(label="consumer,mysql")
    private String snapshotModeCustomName;
    @UriParam(label="consumer,mysql", defaultValue="preferred")
    private String databaseSslMode = "preferred";
    @UriParam(label="consumer,mysql", defaultValue="none")
    private String schemaNameAdjustmentMode = "none";
    @UriParam(label="consumer,mysql", defaultValue="1m", javaType="java.time.Duration")
    private long connectKeepAliveIntervalMs = 60000L;
    @UriParam(label="consumer,mysql")
    private String tableIncludeList;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean includeQuery = false;
    @UriParam(label="consumer,mysql")
    private String databaseIncludeList;
    @UriParam(label="consumer,mysql", defaultValue="0ms", javaType="java.time.Duration")
    private long streamingDelayMs = 0L;
    @UriParam(label="consumer,mysql", defaultValue="10m", javaType="java.time.Duration")
    private int databaseQueryTimeoutMs = 600000;
    @UriParam(label="consumer,mysql", defaultValue="0")
    private int queryFetchSize = 0;
    @UriParam(label="consumer,mysql")
    private String gtidSourceIncludes;
    @UriParam(label="consumer,mysql")
    private String heartbeatActionQuery;
    @UriParam(label="consumer,mysql", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,mysql", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,mysql", defaultValue="0")
    private int binlogBufferSize = 0;
    @UriParam(label="consumer,mysql")
    private String databaseUser;
    @UriParam(label="consumer,mysql")
    private String datatypePropagateSourceType;
    @UriParam(label="consumer,mysql", defaultValue="INSERT_INSERT")
    private String incrementalSnapshotWatermarkingStrategy = "INSERT_INSERT";
    @UriParam(label="consumer,mysql", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,mysql")
    private String databaseSslTruststorePassword;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnSchemaError = false;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean schemaHistoryInternalSkipUnparseableDdl = false;
    @UriParam(label="consumer,mysql")
    private String columnIncludeList;
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean enableTimeAdjuster = true;
    @UriParam(label="consumer,mysql")
    private String columnPropagateSourceType;
    @UriParam(label="consumer,mysql", defaultValue="fail")
    private String inconsistentSchemaHandlingMode = "fail";
    @UriParam(label="consumer,mysql", defaultValue="-1")
    private int errorsMaxRetries = -1;
    @UriParam(label="consumer,mysql")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,mysql", defaultValue="t")
    private String skippedOperations = "t";
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean connectKeepAlive = true;
    @UriParam(label="consumer,mysql", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,mysql", defaultValue="select_all")
    private String snapshotQueryMode = "select_all";
    @UriParam(label="consumer,mysql", defaultValue="true")
    private boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl = true;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl = false;
    @UriParam(label="consumer,mysql")
    @Metadata(required=true)
    private String topicPrefix;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean includeSchemaComments = false;
    @UriParam(label="consumer,mysql", defaultValue="io.debezium.connector.mysql.MySqlSourceInfoStructMaker")
    private String sourceinfoStructMaker = "io.debezium.connector.mysql.MySqlSourceInfoStructMaker";
    @UriParam(label="consumer,mysql", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,mysql", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotSchema = false;
    @UriParam(label="consumer,mysql", defaultValue="adaptive_time_microseconds")
    private String timePrecisionMode = "adaptive_time_microseconds";
    @UriParam(label="consumer,mysql", defaultValue="fail")
    private String eventDeserializationFailureHandlingMode = "fail";
    @UriParam(label="consumer,mysql")
    private String postProcessors;
    @UriParam(label="consumer,mysql", defaultValue="3306")
    private int databasePort = 3306;
    @UriParam(label="consumer,mysql")
    private String databaseSslTruststore;
    @UriParam(label="consumer,mysql")
    private String databaseSslKeystorePassword;
    @UriParam(label="consumer,mysql", defaultValue="io.debezium.storage.kafka.history.KafkaSchemaHistory")
    private String schemaHistoryInternal = "io.debezium.storage.kafka.history.KafkaSchemaHistory";
    @UriParam(label="consumer,mysql")
    private String columnExcludeList;
    @UriParam(label="consumer,mysql")
    private String databaseHostname;
    @UriParam(label="consumer,mysql", defaultValue="10000")
    private long databaseServerIdOffset = 10000L;

    public void setSnapshotLockingMode(String snapshotLockingMode) {
        this.snapshotLockingMode = snapshotLockingMode;
    }

    public String getSnapshotLockingMode() {
        return this.snapshotLockingMode;
    }

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setTransactionMetadataFactory(String transactionMetadataFactory) {
        this.transactionMetadataFactory = transactionMetadataFactory;
    }

    public String getTransactionMetadataFactory() {
        return this.transactionMetadataFactory;
    }

    public void setCustomMetricTags(String customMetricTags) {
        this.customMetricTags = customMetricTags;
    }

    public String getCustomMetricTags() {
        return this.customMetricTags;
    }

    public void setSignalEnabledChannels(String signalEnabledChannels) {
        this.signalEnabledChannels = signalEnabledChannels;
    }

    public String getSignalEnabledChannels() {
        return this.signalEnabledChannels;
    }

    public void setIncludeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public void setDatabaseJdbcDriver(String databaseJdbcDriver) {
        this.databaseJdbcDriver = databaseJdbcDriver;
    }

    public String getDatabaseJdbcDriver() {
        return this.databaseJdbcDriver;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setDatabaseInitialStatements(String databaseInitialStatements) {
        this.databaseInitialStatements = databaseInitialStatements;
    }

    public String getDatabaseInitialStatements() {
        return this.databaseInitialStatements;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setUseNongracefulDisconnect(boolean useNongracefulDisconnect) {
        this.useNongracefulDisconnect = useNongracefulDisconnect;
    }

    public boolean isUseNongracefulDisconnect() {
        return this.useNongracefulDisconnect;
    }

    public void setSnapshotTablesOrderByRowCount(String snapshotTablesOrderByRowCount) {
        this.snapshotTablesOrderByRowCount = snapshotTablesOrderByRowCount;
    }

    public String getSnapshotTablesOrderByRowCount() {
        return this.snapshotTablesOrderByRowCount;
    }

    public void setGtidSourceExcludes(String gtidSourceExcludes) {
        this.gtidSourceExcludes = gtidSourceExcludes;
    }

    public String getGtidSourceExcludes() {
        return this.gtidSourceExcludes;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setDatabaseSslKeystore(String databaseSslKeystore) {
        this.databaseSslKeystore = databaseSslKeystore;
    }

    public String getDatabaseSslKeystore() {
        return this.databaseSslKeystore;
    }

    public void setIncrementalSnapshotAllowSchemaChanges(boolean incrementalSnapshotAllowSchemaChanges) {
        this.incrementalSnapshotAllowSchemaChanges = incrementalSnapshotAllowSchemaChanges;
    }

    public boolean isIncrementalSnapshotAllowSchemaChanges() {
        return this.incrementalSnapshotAllowSchemaChanges;
    }

    public void setDatabaseProtocol(String databaseProtocol) {
        this.databaseProtocol = databaseProtocol;
    }

    public String getDatabaseProtocol() {
        return this.databaseProtocol;
    }

    public void setMinRowCountToStreamResults(int minRowCountToStreamResults) {
        this.minRowCountToStreamResults = minRowCountToStreamResults;
    }

    public int getMinRowCountToStreamResults() {
        return this.minRowCountToStreamResults;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableExcludeList() {
        return this.tableExcludeList;
    }

    public void setDatabaseExcludeList(String databaseExcludeList) {
        this.databaseExcludeList = databaseExcludeList;
    }

    public String getDatabaseExcludeList() {
        return this.databaseExcludeList;
    }

    public void setGtidSourceFilterDmlEvents(boolean gtidSourceFilterDmlEvents) {
        this.gtidSourceFilterDmlEvents = gtidSourceFilterDmlEvents;
    }

    public boolean isGtidSourceFilterDmlEvents() {
        return this.gtidSourceFilterDmlEvents;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setTopicNamingStrategy(String topicNamingStrategy) {
        this.topicNamingStrategy = topicNamingStrategy;
    }

    public String getTopicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setConnectTimeoutMs(int connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
        this.snapshotModeConfigurationBasedSnapshotData = snapshotModeConfigurationBasedSnapshotData;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotData() {
        return this.snapshotModeConfigurationBasedSnapshotData;
    }

    public void setIncrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
        this.incrementalSnapshotChunkSize = incrementalSnapshotChunkSize;
    }

    public int getIncrementalSnapshotChunkSize() {
        return this.incrementalSnapshotChunkSize;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
        this.snapshotModeConfigurationBasedSnapshotOnDataError = snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnDataError() {
        return this.snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public void setSchemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
        this.schemaHistoryInternalFileFilename = schemaHistoryInternalFileFilename;
    }

    public String getSchemaHistoryInternalFileFilename() {
        return this.schemaHistoryInternalFileFilename;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setSnapshotQueryModeCustomName(String snapshotQueryModeCustomName) {
        this.snapshotQueryModeCustomName = snapshotQueryModeCustomName;
    }

    public String getSnapshotQueryModeCustomName() {
        return this.snapshotQueryModeCustomName;
    }

    public void setTableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
        this.tableIgnoreBuiltin = tableIgnoreBuiltin;
    }

    public boolean isTableIgnoreBuiltin() {
        return this.tableIgnoreBuiltin;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setSnapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
        this.snapshotModeConfigurationBasedStartStream = snapshotModeConfigurationBasedStartStream;
    }

    public boolean isSnapshotModeConfigurationBasedStartStream() {
        return this.snapshotModeConfigurationBasedStartStream;
    }

    public void setBigintUnsignedHandlingMode(String bigintUnsignedHandlingMode) {
        this.bigintUnsignedHandlingMode = bigintUnsignedHandlingMode;
    }

    public String getBigintUnsignedHandlingMode() {
        return this.bigintUnsignedHandlingMode;
    }

    public void setDatabaseServerId(long databaseServerId) {
        this.databaseServerId = databaseServerId;
    }

    public long getDatabaseServerId() {
        return this.databaseServerId;
    }

    public void setSignalPollIntervalMs(long signalPollIntervalMs) {
        this.signalPollIntervalMs = signalPollIntervalMs;
    }

    public long getSignalPollIntervalMs() {
        return this.signalPollIntervalMs;
    }

    public void setNotificationEnabledChannels(String notificationEnabledChannels) {
        this.notificationEnabledChannels = notificationEnabledChannels;
    }

    public String getNotificationEnabledChannels() {
        return this.notificationEnabledChannels;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setSnapshotMaxThreads(int snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public int getSnapshotMaxThreads() {
        return this.snapshotMaxThreads;
    }

    public void setNotificationSinkTopicName(String notificationSinkTopicName) {
        this.notificationSinkTopicName = notificationSinkTopicName;
    }

    public String getNotificationSinkTopicName() {
        return this.notificationSinkTopicName;
    }

    public void setSnapshotModeCustomName(String snapshotModeCustomName) {
        this.snapshotModeCustomName = snapshotModeCustomName;
    }

    public String getSnapshotModeCustomName() {
        return this.snapshotModeCustomName;
    }

    public void setDatabaseSslMode(String databaseSslMode) {
        this.databaseSslMode = databaseSslMode;
    }

    public String getDatabaseSslMode() {
        return this.databaseSslMode;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setConnectKeepAliveIntervalMs(long connectKeepAliveIntervalMs) {
        this.connectKeepAliveIntervalMs = connectKeepAliveIntervalMs;
    }

    public long getConnectKeepAliveIntervalMs() {
        return this.connectKeepAliveIntervalMs;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableIncludeList() {
        return this.tableIncludeList;
    }

    public void setIncludeQuery(boolean includeQuery) {
        this.includeQuery = includeQuery;
    }

    public boolean isIncludeQuery() {
        return this.includeQuery;
    }

    public void setDatabaseIncludeList(String databaseIncludeList) {
        this.databaseIncludeList = databaseIncludeList;
    }

    public String getDatabaseIncludeList() {
        return this.databaseIncludeList;
    }

    public void setStreamingDelayMs(long streamingDelayMs) {
        this.streamingDelayMs = streamingDelayMs;
    }

    public long getStreamingDelayMs() {
        return this.streamingDelayMs;
    }

    public void setDatabaseQueryTimeoutMs(int databaseQueryTimeoutMs) {
        this.databaseQueryTimeoutMs = databaseQueryTimeoutMs;
    }

    public int getDatabaseQueryTimeoutMs() {
        return this.databaseQueryTimeoutMs;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setGtidSourceIncludes(String gtidSourceIncludes) {
        this.gtidSourceIncludes = gtidSourceIncludes;
    }

    public String getGtidSourceIncludes() {
        return this.gtidSourceIncludes;
    }

    public void setHeartbeatActionQuery(String heartbeatActionQuery) {
        this.heartbeatActionQuery = heartbeatActionQuery;
    }

    public String getHeartbeatActionQuery() {
        return this.heartbeatActionQuery;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setBinlogBufferSize(int binlogBufferSize) {
        this.binlogBufferSize = binlogBufferSize;
    }

    public int getBinlogBufferSize() {
        return this.binlogBufferSize;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatatypePropagateSourceType(String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDatatypePropagateSourceType() {
        return this.datatypePropagateSourceType;
    }

    public void setIncrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
        this.incrementalSnapshotWatermarkingStrategy = incrementalSnapshotWatermarkingStrategy;
    }

    public String getIncrementalSnapshotWatermarkingStrategy() {
        return this.incrementalSnapshotWatermarkingStrategy;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setDatabaseSslTruststorePassword(String databaseSslTruststorePassword) {
        this.databaseSslTruststorePassword = databaseSslTruststorePassword;
    }

    public String getDatabaseSslTruststorePassword() {
        return this.databaseSslTruststorePassword;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
        this.snapshotModeConfigurationBasedSnapshotOnSchemaError = snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnSchemaError() {
        return this.snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public void setSchemaHistoryInternalSkipUnparseableDdl(boolean schemaHistoryInternalSkipUnparseableDdl) {
        this.schemaHistoryInternalSkipUnparseableDdl = schemaHistoryInternalSkipUnparseableDdl;
    }

    public boolean isSchemaHistoryInternalSkipUnparseableDdl() {
        return this.schemaHistoryInternalSkipUnparseableDdl;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnIncludeList() {
        return this.columnIncludeList;
    }

    public void setEnableTimeAdjuster(boolean enableTimeAdjuster) {
        this.enableTimeAdjuster = enableTimeAdjuster;
    }

    public boolean isEnableTimeAdjuster() {
        return this.enableTimeAdjuster;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnPropagateSourceType() {
        return this.columnPropagateSourceType;
    }

    public void setInconsistentSchemaHandlingMode(String inconsistentSchemaHandlingMode) {
        this.inconsistentSchemaHandlingMode = inconsistentSchemaHandlingMode;
    }

    public String getInconsistentSchemaHandlingMode() {
        return this.inconsistentSchemaHandlingMode;
    }

    public void setErrorsMaxRetries(int errorsMaxRetries) {
        this.errorsMaxRetries = errorsMaxRetries;
    }

    public int getErrorsMaxRetries() {
        return this.errorsMaxRetries;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setConnectKeepAlive(boolean connectKeepAlive) {
        this.connectKeepAlive = connectKeepAlive;
    }

    public boolean isConnectKeepAlive() {
        return this.connectKeepAlive;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setSnapshotQueryMode(String snapshotQueryMode) {
        this.snapshotQueryMode = snapshotQueryMode;
    }

    public String getSnapshotQueryMode() {
        return this.snapshotQueryMode;
    }

    public void setSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl(boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
        this.schemaHistoryInternalStoreOnlyCapturedDatabasesDdl = schemaHistoryInternalStoreOnlyCapturedDatabasesDdl;
    }

    public boolean isSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl() {
        return this.schemaHistoryInternalStoreOnlyCapturedDatabasesDdl;
    }

    public void setSchemaHistoryInternalStoreOnlyCapturedTablesDdl(boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
        this.schemaHistoryInternalStoreOnlyCapturedTablesDdl = schemaHistoryInternalStoreOnlyCapturedTablesDdl;
    }

    public boolean isSchemaHistoryInternalStoreOnlyCapturedTablesDdl() {
        return this.schemaHistoryInternalStoreOnlyCapturedTablesDdl;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setIncludeSchemaComments(boolean includeSchemaComments) {
        this.includeSchemaComments = includeSchemaComments;
    }

    public boolean isIncludeSchemaComments() {
        return this.includeSchemaComments;
    }

    public void setSourceinfoStructMaker(String sourceinfoStructMaker) {
        this.sourceinfoStructMaker = sourceinfoStructMaker;
    }

    public String getSourceinfoStructMaker() {
        return this.sourceinfoStructMaker;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setSnapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
        this.snapshotModeConfigurationBasedSnapshotSchema = snapshotModeConfigurationBasedSnapshotSchema;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotSchema() {
        return this.snapshotModeConfigurationBasedSnapshotSchema;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setEventDeserializationFailureHandlingMode(String eventDeserializationFailureHandlingMode) {
        this.eventDeserializationFailureHandlingMode = eventDeserializationFailureHandlingMode;
    }

    public String getEventDeserializationFailureHandlingMode() {
        return this.eventDeserializationFailureHandlingMode;
    }

    public void setPostProcessors(String postProcessors) {
        this.postProcessors = postProcessors;
    }

    public String getPostProcessors() {
        return this.postProcessors;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setDatabaseSslTruststore(String databaseSslTruststore) {
        this.databaseSslTruststore = databaseSslTruststore;
    }

    public String getDatabaseSslTruststore() {
        return this.databaseSslTruststore;
    }

    public void setDatabaseSslKeystorePassword(String databaseSslKeystorePassword) {
        this.databaseSslKeystorePassword = databaseSslKeystorePassword;
    }

    public String getDatabaseSslKeystorePassword() {
        return this.databaseSslKeystorePassword;
    }

    public void setSchemaHistoryInternal(String schemaHistoryInternal) {
        this.schemaHistoryInternal = schemaHistoryInternal;
    }

    public String getSchemaHistoryInternal() {
        return this.schemaHistoryInternal;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnExcludeList() {
        return this.columnExcludeList;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setDatabaseServerIdOffset(long databaseServerIdOffset) {
        this.databaseServerIdOffset = databaseServerIdOffset;
    }

    public long getDatabaseServerIdOffset() {
        return this.databaseServerIdOffset;
    }

    @Override
    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.locking.mode", this.snapshotLockingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "message.key.columns", this.messageKeyColumns);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "transaction.metadata.factory", this.transactionMetadataFactory);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "custom.metric.tags", this.customMetricTags);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.enabled.channels", this.signalEnabledChannels);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.schema.changes", Boolean.valueOf(this.includeSchemaChanges));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.jdbc.driver", this.databaseJdbcDriver);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.data.collection", this.signalDataCollection);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.initial.statements", this.databaseInitialStatements);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "converters", this.converters);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.fetch.size", Integer.valueOf(this.snapshotFetchSize));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.lock.timeout.ms", Long.valueOf(this.snapshotLockTimeoutMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "use.nongraceful.disconnect", Boolean.valueOf(this.useNongracefulDisconnect));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.tables.order.by.row.count", this.snapshotTablesOrderByRowCount);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "gtid.source.excludes", this.gtidSourceExcludes);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.select.statement.overrides", this.snapshotSelectStatementOverrides);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.ssl.keystore", this.databaseSslKeystore);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.allow.schema.changes", Boolean.valueOf(this.incrementalSnapshotAllowSchemaChanges));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.protocol", this.databaseProtocol);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "min.row.count.to.stream.results", Integer.valueOf(this.minRowCountToStreamResults));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.exclude.list", this.tableExcludeList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.exclude.list", this.databaseExcludeList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "gtid.source.filter.dml.events", Boolean.valueOf(this.gtidSourceFilterDmlEvents));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.batch.size", Integer.valueOf(this.maxBatchSize));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.naming.strategy", this.topicNamingStrategy);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode", this.snapshotMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "connect.timeout.ms", Integer.valueOf(this.connectTimeoutMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.data", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotData));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.chunk.size", Integer.valueOf(this.incrementalSnapshotChunkSize));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "retriable.restart.connector.wait.ms", Long.valueOf(this.retriableRestartConnectorWaitMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.delay.ms", Long.valueOf(this.snapshotDelayMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.data.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnDataError));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.file.filename", this.schemaHistoryInternalFileFilename);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "tombstones.on.delete", Boolean.valueOf(this.tombstonesOnDelete));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "decimal.handling.mode", this.decimalHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.query.mode.custom.name", this.snapshotQueryModeCustomName);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.ignore.builtin", Boolean.valueOf(this.tableIgnoreBuiltin));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.include.collection.list", this.snapshotIncludeCollectionList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.start.stream", Boolean.valueOf(this.snapshotModeConfigurationBasedStartStream));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "bigint.unsigned.handling.mode", this.bigintUnsignedHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.server.id", Long.valueOf(this.databaseServerId));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.poll.interval.ms", Long.valueOf(this.signalPollIntervalMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.enabled.channels", this.notificationEnabledChannels);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "event.processing.failure.handling.mode", this.eventProcessingFailureHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.max.threads", Integer.valueOf(this.snapshotMaxThreads));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.sink.topic.name", this.notificationSinkTopicName);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.custom.name", this.snapshotModeCustomName);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.ssl.mode", this.databaseSslMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.name.adjustment.mode", this.schemaNameAdjustmentMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "connect.keep.alive.interval.ms", Long.valueOf(this.connectKeepAliveIntervalMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.include.list", this.tableIncludeList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.query", Boolean.valueOf(this.includeQuery));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.include.list", this.databaseIncludeList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "streaming.delay.ms", Long.valueOf(this.streamingDelayMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.query.timeout.ms", Integer.valueOf(this.databaseQueryTimeoutMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "query.fetch.size", Integer.valueOf(this.queryFetchSize));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "gtid.source.includes", this.gtidSourceIncludes);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.action.query", this.heartbeatActionQuery);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "poll.interval.ms", Long.valueOf(this.pollIntervalMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.topics.prefix", this.heartbeatTopicsPrefix);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "binlog.buffer.size", Integer.valueOf(this.binlogBufferSize));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.user", this.databaseUser);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "datatype.propagate.source.type", this.datatypePropagateSourceType);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.watermarking.strategy", this.incrementalSnapshotWatermarkingStrategy);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.interval.ms", Integer.valueOf(this.heartbeatIntervalMs));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.ssl.truststore.password", this.databaseSslTruststorePassword);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.schema.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnSchemaError));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.skip.unparseable.ddl", Boolean.valueOf(this.schemaHistoryInternalSkipUnparseableDdl));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.include.list", this.columnIncludeList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "enable.time.adjuster", Boolean.valueOf(this.enableTimeAdjuster));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.propagate.source.type", this.columnPropagateSourceType);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "inconsistent.schema.handling.mode", this.inconsistentSchemaHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "errors.max.retries", Integer.valueOf(this.errorsMaxRetries));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.password", this.databasePassword);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "skipped.operations", this.skippedOperations);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "connect.keep.alive", Boolean.valueOf(this.connectKeepAlive));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size", Integer.valueOf(this.maxQueueSize));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "provide.transaction.metadata", Boolean.valueOf(this.provideTransactionMetadata));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.query.mode", this.snapshotQueryMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.store.only.captured.databases.ddl", Boolean.valueOf(this.schemaHistoryInternalStoreOnlyCapturedDatabasesDdl));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.store.only.captured.tables.ddl", Boolean.valueOf(this.schemaHistoryInternalStoreOnlyCapturedTablesDdl));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.prefix", this.topicPrefix);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.schema.comments", Boolean.valueOf(this.includeSchemaComments));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "sourceinfo.struct.maker", this.sourceinfoStructMaker);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size.in.bytes", Long.valueOf(this.maxQueueSizeInBytes));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.schema", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotSchema));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "time.precision.mode", this.timePrecisionMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "event.deserialization.failure.handling.mode", this.eventDeserializationFailureHandlingMode);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "post.processors", this.postProcessors);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.port", Integer.valueOf(this.databasePort));
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.ssl.truststore", this.databaseSslTruststore);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.ssl.keystore.password", this.databaseSslKeystorePassword);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal", this.schemaHistoryInternal);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.exclude.list", this.columnExcludeList);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.hostname", this.databaseHostname);
        MySqlConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.server.id.offset", Long.valueOf(this.databaseServerIdOffset));
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return MySqlConnector.class;
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        if (MySqlConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databasePassword)) {
            return ConfigurationValidation.notValid("Required field 'databasePassword' must be set.");
        }
        if (MySqlConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.topicPrefix)) {
            return ConfigurationValidation.notValid("Required field 'topicPrefix' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    @Override
    public String getConnectorDatabaseType() {
        return "mysql";
    }
}

