/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.mysql;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.component.debezium.DebeziumComponent;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.mysql.DebeziumMySqlComponent;
import org.apache.camel.component.debezium.mysql.configuration.MySqlConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="3.0.0", scheme="debezium-mysql", title="Debezium MySQL Connector", syntax="debezium-mysql:name", category={Category.DATABASE}, consumerOnly=true, headersClass=DebeziumConstants.class)
public final class DebeziumMySqlEndpoint
extends DebeziumEndpoint<MySqlConnectorEmbeddedDebeziumConfiguration>
implements EndpointServiceLocation {
    @UriParam
    private MySqlConnectorEmbeddedDebeziumConfiguration configuration;

    public DebeziumMySqlEndpoint(String uri, DebeziumMySqlComponent component, MySqlConnectorEmbeddedDebeziumConfiguration configuration) {
        super(uri, (DebeziumComponent)component);
        this.configuration = configuration;
    }

    public DebeziumMySqlEndpoint() {
    }

    public String getServiceUrl() {
        return this.configuration.getDatabaseHostname() + ":" + this.configuration.getDatabasePort();
    }

    public String getServiceProtocol() {
        return "jdbc";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getDatabaseUser() != null) {
            return Map.of("username", this.configuration.getDatabaseUser());
        }
        return null;
    }

    public MySqlConnectorEmbeddedDebeziumConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MySqlConnectorEmbeddedDebeziumConfiguration configuration) {
        this.configuration = configuration;
    }
}

