/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.db2.Db2Connector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class Db2ConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,db2";
    @UriParam(label="consumer,db2")
    private String messageKeyColumns;
    @UriParam(label="consumer,db2", defaultValue="io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory")
    private String transactionMetadataFactory = "io.debezium.pipeline.txmetadata.DefaultTransactionMetadataFactory";
    @UriParam(label="consumer,db2", defaultValue="0ms", javaType="java.time.Duration")
    private long streamingDelayMs = 0L;
    @UriParam(label="consumer,db2")
    private String customMetricTags;
    @UriParam(label="consumer,db2", defaultValue="10000")
    private int queryFetchSize = 10000;
    @UriParam(label="consumer,db2", defaultValue="source")
    private String signalEnabledChannels = "source";
    @UriParam(label="consumer,db2", defaultValue="true")
    private boolean includeSchemaChanges = true;
    @UriParam(label="consumer,db2", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,db2")
    private String signalDataCollection;
    @UriParam(label="consumer,db2")
    private String converters;
    @UriParam(label="consumer,db2", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,db2")
    private int snapshotFetchSize;
    @UriParam(label="consumer,db2", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,db2", defaultValue="ASNCDC")
    private String cdcChangeTablesSchema = "ASNCDC";
    @UriParam(label="consumer,db2")
    private String databaseUser;
    @UriParam(label="consumer,db2")
    private String databaseDbname;
    @UriParam(label="consumer,db2")
    private String datatypePropagateSourceType;
    @UriParam(label="consumer,db2", defaultValue="disabled")
    private String snapshotTablesOrderByRowCount = "disabled";
    @UriParam(label="consumer,db2", defaultValue="INSERT_INSERT")
    private String incrementalSnapshotWatermarkingStrategy = "INSERT_INSERT";
    @UriParam(label="consumer,db2")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,db2", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnSchemaError = false;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean schemaHistoryInternalSkipUnparseableDdl = false;
    @UriParam(label="consumer,db2")
    private String columnIncludeList;
    @UriParam(label="consumer,db2")
    private String columnPropagateSourceType;
    @UriParam(label="consumer,db2", defaultValue="-1")
    private int errorsMaxRetries = -1;
    @UriParam(label="consumer,db2")
    private String tableExcludeList;
    @UriParam(label="consumer,db2")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,db2", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,db2", defaultValue="t")
    private String skippedOperations = "t";
    @UriParam(label="consumer,db2", defaultValue="io.debezium.schema.SchemaTopicNamingStrategy")
    private String topicNamingStrategy = "io.debezium.schema.SchemaTopicNamingStrategy";
    @UriParam(label="consumer,db2", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotData = false;
    @UriParam(label="consumer,db2", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,db2", defaultValue="1024")
    private int incrementalSnapshotChunkSize = 1024;
    @UriParam(label="consumer,db2", defaultValue="10s", javaType="java.time.Duration")
    private long retriableRestartConnectorWaitMs = 10000L;
    @UriParam(label="consumer,db2", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl = false;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl = false;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotOnDataError = false;
    @UriParam(label="consumer,db2")
    private String schemaHistoryInternalFileFilename;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,db2")
    @Metadata(required=true)
    private String topicPrefix;
    @UriParam(label="consumer,db2", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,db2", defaultValue="io.debezium.connector.db2.Db2SourceInfoStructMaker")
    private String sourceinfoStructMaker = "io.debezium.connector.db2.Db2SourceInfoStructMaker";
    @UriParam(label="consumer,db2", defaultValue="ASNCDC")
    private String cdcControlSchema = "ASNCDC";
    @UriParam(label="consumer,db2", defaultValue="true")
    private boolean tableIgnoreBuiltin = true;
    @UriParam(label="consumer,db2")
    private String snapshotIncludeCollectionList;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean snapshotModeConfigurationBasedStartStream = false;
    @UriParam(label="consumer,db2", defaultValue="0")
    private long maxQueueSizeInBytes = 0L;
    @UriParam(label="consumer,db2", defaultValue="false")
    private boolean snapshotModeConfigurationBasedSnapshotSchema = false;
    @UriParam(label="consumer,db2", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,db2", defaultValue="5s", javaType="java.time.Duration")
    private long signalPollIntervalMs = 5000L;
    @UriParam(label="consumer,db2")
    private String postProcessors;
    @UriParam(label="consumer,db2")
    private String notificationEnabledChannels;
    @UriParam(label="consumer,db2", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,db2", defaultValue="50000")
    private int databasePort = 50000;
    @UriParam(label="consumer,db2")
    private String notificationSinkTopicName;
    @UriParam(label="consumer,db2")
    private String snapshotModeCustomName;
    @UriParam(label="consumer,db2", defaultValue="io.debezium.storage.kafka.history.KafkaSchemaHistory")
    private String schemaHistoryInternal = "io.debezium.storage.kafka.history.KafkaSchemaHistory";
    @UriParam(label="consumer,db2")
    private String columnExcludeList;
    @UriParam(label="consumer,db2")
    private String databaseHostname;
    @UriParam(label="consumer,db2", defaultValue="none")
    private String schemaNameAdjustmentMode = "none";
    @UriParam(label="consumer,db2")
    private String tableIncludeList;
    @UriParam(label="consumer,db2", defaultValue="LUW")
    private String db2Platform = "LUW";

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setTransactionMetadataFactory(String transactionMetadataFactory) {
        this.transactionMetadataFactory = transactionMetadataFactory;
    }

    public String getTransactionMetadataFactory() {
        return this.transactionMetadataFactory;
    }

    public void setStreamingDelayMs(long streamingDelayMs) {
        this.streamingDelayMs = streamingDelayMs;
    }

    public long getStreamingDelayMs() {
        return this.streamingDelayMs;
    }

    public void setCustomMetricTags(String customMetricTags) {
        this.customMetricTags = customMetricTags;
    }

    public String getCustomMetricTags() {
        return this.customMetricTags;
    }

    public void setQueryFetchSize(int queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public int getQueryFetchSize() {
        return this.queryFetchSize;
    }

    public void setSignalEnabledChannels(String signalEnabledChannels) {
        this.signalEnabledChannels = signalEnabledChannels;
    }

    public String getSignalEnabledChannels() {
        return this.signalEnabledChannels;
    }

    public void setIncludeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSignalDataCollection() {
        return this.signalDataCollection;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setCdcChangeTablesSchema(String cdcChangeTablesSchema) {
        this.cdcChangeTablesSchema = cdcChangeTablesSchema;
    }

    public String getCdcChangeTablesSchema() {
        return this.cdcChangeTablesSchema;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setDatatypePropagateSourceType(String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDatatypePropagateSourceType() {
        return this.datatypePropagateSourceType;
    }

    public void setSnapshotTablesOrderByRowCount(String snapshotTablesOrderByRowCount) {
        this.snapshotTablesOrderByRowCount = snapshotTablesOrderByRowCount;
    }

    public String getSnapshotTablesOrderByRowCount() {
        return this.snapshotTablesOrderByRowCount;
    }

    public void setIncrementalSnapshotWatermarkingStrategy(String incrementalSnapshotWatermarkingStrategy) {
        this.incrementalSnapshotWatermarkingStrategy = incrementalSnapshotWatermarkingStrategy;
    }

    public String getIncrementalSnapshotWatermarkingStrategy() {
        return this.incrementalSnapshotWatermarkingStrategy;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnSchemaError(boolean snapshotModeConfigurationBasedSnapshotOnSchemaError) {
        this.snapshotModeConfigurationBasedSnapshotOnSchemaError = snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnSchemaError() {
        return this.snapshotModeConfigurationBasedSnapshotOnSchemaError;
    }

    public void setSchemaHistoryInternalSkipUnparseableDdl(boolean schemaHistoryInternalSkipUnparseableDdl) {
        this.schemaHistoryInternalSkipUnparseableDdl = schemaHistoryInternalSkipUnparseableDdl;
    }

    public boolean isSchemaHistoryInternalSkipUnparseableDdl() {
        return this.schemaHistoryInternalSkipUnparseableDdl;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnIncludeList() {
        return this.columnIncludeList;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnPropagateSourceType() {
        return this.columnPropagateSourceType;
    }

    public void setErrorsMaxRetries(int errorsMaxRetries) {
        this.errorsMaxRetries = errorsMaxRetries;
    }

    public int getErrorsMaxRetries() {
        return this.errorsMaxRetries;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableExcludeList() {
        return this.tableExcludeList;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setTopicNamingStrategy(String topicNamingStrategy) {
        this.topicNamingStrategy = topicNamingStrategy;
    }

    public String getTopicNamingStrategy() {
        return this.topicNamingStrategy;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setSnapshotModeConfigurationBasedSnapshotData(boolean snapshotModeConfigurationBasedSnapshotData) {
        this.snapshotModeConfigurationBasedSnapshotData = snapshotModeConfigurationBasedSnapshotData;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotData() {
        return this.snapshotModeConfigurationBasedSnapshotData;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setIncrementalSnapshotChunkSize(int incrementalSnapshotChunkSize) {
        this.incrementalSnapshotChunkSize = incrementalSnapshotChunkSize;
    }

    public int getIncrementalSnapshotChunkSize() {
        return this.incrementalSnapshotChunkSize;
    }

    public void setRetriableRestartConnectorWaitMs(long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public long getRetriableRestartConnectorWaitMs() {
        return this.retriableRestartConnectorWaitMs;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setSchemaHistoryInternalStoreOnlyCapturedTablesDdl(boolean schemaHistoryInternalStoreOnlyCapturedTablesDdl) {
        this.schemaHistoryInternalStoreOnlyCapturedTablesDdl = schemaHistoryInternalStoreOnlyCapturedTablesDdl;
    }

    public boolean isSchemaHistoryInternalStoreOnlyCapturedTablesDdl() {
        return this.schemaHistoryInternalStoreOnlyCapturedTablesDdl;
    }

    public void setSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl(boolean schemaHistoryInternalStoreOnlyCapturedDatabasesDdl) {
        this.schemaHistoryInternalStoreOnlyCapturedDatabasesDdl = schemaHistoryInternalStoreOnlyCapturedDatabasesDdl;
    }

    public boolean isSchemaHistoryInternalStoreOnlyCapturedDatabasesDdl() {
        return this.schemaHistoryInternalStoreOnlyCapturedDatabasesDdl;
    }

    public void setSnapshotModeConfigurationBasedSnapshotOnDataError(boolean snapshotModeConfigurationBasedSnapshotOnDataError) {
        this.snapshotModeConfigurationBasedSnapshotOnDataError = snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotOnDataError() {
        return this.snapshotModeConfigurationBasedSnapshotOnDataError;
    }

    public void setSchemaHistoryInternalFileFilename(String schemaHistoryInternalFileFilename) {
        this.schemaHistoryInternalFileFilename = schemaHistoryInternalFileFilename;
    }

    public String getSchemaHistoryInternalFileFilename() {
        return this.schemaHistoryInternalFileFilename;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setTopicPrefix(String topicPrefix) {
        this.topicPrefix = topicPrefix;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setSourceinfoStructMaker(String sourceinfoStructMaker) {
        this.sourceinfoStructMaker = sourceinfoStructMaker;
    }

    public String getSourceinfoStructMaker() {
        return this.sourceinfoStructMaker;
    }

    public void setCdcControlSchema(String cdcControlSchema) {
        this.cdcControlSchema = cdcControlSchema;
    }

    public String getCdcControlSchema() {
        return this.cdcControlSchema;
    }

    public void setTableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
        this.tableIgnoreBuiltin = tableIgnoreBuiltin;
    }

    public boolean isTableIgnoreBuiltin() {
        return this.tableIgnoreBuiltin;
    }

    public void setSnapshotIncludeCollectionList(String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotIncludeCollectionList() {
        return this.snapshotIncludeCollectionList;
    }

    public void setSnapshotModeConfigurationBasedStartStream(boolean snapshotModeConfigurationBasedStartStream) {
        this.snapshotModeConfigurationBasedStartStream = snapshotModeConfigurationBasedStartStream;
    }

    public boolean isSnapshotModeConfigurationBasedStartStream() {
        return this.snapshotModeConfigurationBasedStartStream;
    }

    public void setMaxQueueSizeInBytes(long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public long getMaxQueueSizeInBytes() {
        return this.maxQueueSizeInBytes;
    }

    public void setSnapshotModeConfigurationBasedSnapshotSchema(boolean snapshotModeConfigurationBasedSnapshotSchema) {
        this.snapshotModeConfigurationBasedSnapshotSchema = snapshotModeConfigurationBasedSnapshotSchema;
    }

    public boolean isSnapshotModeConfigurationBasedSnapshotSchema() {
        return this.snapshotModeConfigurationBasedSnapshotSchema;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setSignalPollIntervalMs(long signalPollIntervalMs) {
        this.signalPollIntervalMs = signalPollIntervalMs;
    }

    public long getSignalPollIntervalMs() {
        return this.signalPollIntervalMs;
    }

    public void setPostProcessors(String postProcessors) {
        this.postProcessors = postProcessors;
    }

    public String getPostProcessors() {
        return this.postProcessors;
    }

    public void setNotificationEnabledChannels(String notificationEnabledChannels) {
        this.notificationEnabledChannels = notificationEnabledChannels;
    }

    public String getNotificationEnabledChannels() {
        return this.notificationEnabledChannels;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setNotificationSinkTopicName(String notificationSinkTopicName) {
        this.notificationSinkTopicName = notificationSinkTopicName;
    }

    public String getNotificationSinkTopicName() {
        return this.notificationSinkTopicName;
    }

    public void setSnapshotModeCustomName(String snapshotModeCustomName) {
        this.snapshotModeCustomName = snapshotModeCustomName;
    }

    public String getSnapshotModeCustomName() {
        return this.snapshotModeCustomName;
    }

    public void setSchemaHistoryInternal(String schemaHistoryInternal) {
        this.schemaHistoryInternal = schemaHistoryInternal;
    }

    public String getSchemaHistoryInternal() {
        return this.schemaHistoryInternal;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnExcludeList() {
        return this.columnExcludeList;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSchemaNameAdjustmentMode() {
        return this.schemaNameAdjustmentMode;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableIncludeList() {
        return this.tableIncludeList;
    }

    public void setDb2Platform(String db2Platform) {
        this.db2Platform = db2Platform;
    }

    public String getDb2Platform() {
        return this.db2Platform;
    }

    @Override
    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "message.key.columns", this.messageKeyColumns);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "transaction.metadata.factory", this.transactionMetadataFactory);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "streaming.delay.ms", Long.valueOf(this.streamingDelayMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "custom.metric.tags", this.customMetricTags);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "query.fetch.size", Integer.valueOf(this.queryFetchSize));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.enabled.channels", this.signalEnabledChannels);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "include.schema.changes", Boolean.valueOf(this.includeSchemaChanges));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "poll.interval.ms", Long.valueOf(this.pollIntervalMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.data.collection", this.signalDataCollection);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "converters", this.converters);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.topics.prefix", this.heartbeatTopicsPrefix);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.fetch.size", Integer.valueOf(this.snapshotFetchSize));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.lock.timeout.ms", Long.valueOf(this.snapshotLockTimeoutMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "cdc.change.tables.schema", this.cdcChangeTablesSchema);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.user", this.databaseUser);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.dbname", this.databaseDbname);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "datatype.propagate.source.type", this.datatypePropagateSourceType);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.tables.order.by.row.count", this.snapshotTablesOrderByRowCount);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.watermarking.strategy", this.incrementalSnapshotWatermarkingStrategy);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.select.statement.overrides", this.snapshotSelectStatementOverrides);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "heartbeat.interval.ms", Integer.valueOf(this.heartbeatIntervalMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.schema.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnSchemaError));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.skip.unparseable.ddl", Boolean.valueOf(this.schemaHistoryInternalSkipUnparseableDdl));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.include.list", this.columnIncludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.propagate.source.type", this.columnPropagateSourceType);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "errors.max.retries", Integer.valueOf(this.errorsMaxRetries));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.exclude.list", this.tableExcludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.password", this.databasePassword);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.batch.size", Integer.valueOf(this.maxBatchSize));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "skipped.operations", this.skippedOperations);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.naming.strategy", this.topicNamingStrategy);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode", this.snapshotMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.data", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotData));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size", Integer.valueOf(this.maxQueueSize));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "incremental.snapshot.chunk.size", Integer.valueOf(this.incrementalSnapshotChunkSize));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "retriable.restart.connector.wait.ms", Long.valueOf(this.retriableRestartConnectorWaitMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.delay.ms", Long.valueOf(this.snapshotDelayMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "provide.transaction.metadata", Boolean.valueOf(this.provideTransactionMetadata));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.store.only.captured.tables.ddl", Boolean.valueOf(this.schemaHistoryInternalStoreOnlyCapturedTablesDdl));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.store.only.captured.databases.ddl", Boolean.valueOf(this.schemaHistoryInternalStoreOnlyCapturedDatabasesDdl));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.on.data.error", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotOnDataError));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal.file.filename", this.schemaHistoryInternalFileFilename);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "tombstones.on.delete", Boolean.valueOf(this.tombstonesOnDelete));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "topic.prefix", this.topicPrefix);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "decimal.handling.mode", this.decimalHandlingMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "sourceinfo.struct.maker", this.sourceinfoStructMaker);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "cdc.control.schema", this.cdcControlSchema);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.ignore.builtin", Boolean.valueOf(this.tableIgnoreBuiltin));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.include.collection.list", this.snapshotIncludeCollectionList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.start.stream", Boolean.valueOf(this.snapshotModeConfigurationBasedStartStream));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "max.queue.size.in.bytes", Long.valueOf(this.maxQueueSizeInBytes));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.configuration.based.snapshot.schema", Boolean.valueOf(this.snapshotModeConfigurationBasedSnapshotSchema));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "time.precision.mode", this.timePrecisionMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "signal.poll.interval.ms", Long.valueOf(this.signalPollIntervalMs));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "post.processors", this.postProcessors);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.enabled.channels", this.notificationEnabledChannels);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "event.processing.failure.handling.mode", this.eventProcessingFailureHandlingMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.port", Integer.valueOf(this.databasePort));
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "notification.sink.topic.name", this.notificationSinkTopicName);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "snapshot.mode.custom.name", this.snapshotModeCustomName);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.history.internal", this.schemaHistoryInternal);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "column.exclude.list", this.columnExcludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "database.hostname", this.databaseHostname);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "schema.name.adjustment.mode", this.schemaNameAdjustmentMode);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "table.include.list", this.tableIncludeList);
        Db2ConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull(configBuilder, "db2.platform", this.db2Platform);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return Db2Connector.class;
    }

    @Override
    protected ConfigurationValidation validateConnectorConfiguration() {
        if (Db2ConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.databasePassword)) {
            return ConfigurationValidation.notValid("Required field 'databasePassword' must be set.");
        }
        if (Db2ConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet(this.topicPrefix)) {
            return ConfigurationValidation.notValid("Required field 'topicPrefix' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    @Override
    public String getConnectorDatabaseType() {
        return "db2";
    }
}

