/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium;

import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.component.debezium.DebeziumComponent;
import org.apache.camel.component.debezium.DebeziumConstants;
import org.apache.camel.component.debezium.DebeziumDb2Component;
import org.apache.camel.component.debezium.DebeziumEndpoint;
import org.apache.camel.component.debezium.configuration.Db2ConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(firstVersion="3.17.0", scheme="debezium-db2", title="Debezium DB2 Connector", syntax="debezium-db2:name", category={Category.DATABASE}, consumerOnly=true, headersClass=DebeziumConstants.class)
public final class DebeziumDb2Endpoint
extends DebeziumEndpoint<Db2ConnectorEmbeddedDebeziumConfiguration>
implements EndpointServiceLocation {
    @UriParam
    private Db2ConnectorEmbeddedDebeziumConfiguration configuration;

    public DebeziumDb2Endpoint(String uri, DebeziumDb2Component component, Db2ConnectorEmbeddedDebeziumConfiguration configuration) {
        super(uri, (DebeziumComponent)component);
        this.configuration = configuration;
    }

    public DebeziumDb2Endpoint() {
    }

    public String getServiceUrl() {
        return this.configuration.getDatabaseHostname() + ":" + this.configuration.getDatabasePort();
    }

    public String getServiceProtocol() {
        return "jdbc";
    }

    public Map<String, String> getServiceMetadata() {
        if (this.configuration.getDatabaseUser() != null) {
            return Map.of("username", this.configuration.getDatabaseUser());
        }
        return null;
    }

    public Db2ConnectorEmbeddedDebeziumConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Db2ConnectorEmbeddedDebeziumConfiguration configuration) {
        this.configuration = configuration;
    }
}

