/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.jaxrs.impl.AbstractRequestContextImpl;
import org.apache.cxf.jaxrs.impl.RequestImpl;
import org.apache.cxf.jaxrs.impl.SecurityContextImpl;
import org.apache.cxf.jaxrs.impl.UriInfoImpl;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.SecurityContext;

public class ContainerRequestContextImpl
extends AbstractRequestContextImpl
implements ContainerRequestContext {
    private static final String ENDPOINT_ADDRESS_PROPERTY = "org.apache.cxf.transport.endpoint.address";
    private static final String ENDPOINT_URI_PROPERTY = "org.apache.cxf.transport.endpoint.uri";
    private boolean preMatch;

    public ContainerRequestContextImpl(Message message, boolean preMatch, boolean responseContext) {
        super(message, responseContext);
        this.preMatch = preMatch;
    }

    public InputStream getEntityStream() {
        return this.m.getContent(InputStream.class);
    }

    public Request getRequest() {
        return new RequestImpl(this.m);
    }

    public jakarta.ws.rs.core.SecurityContext getSecurityContext() {
        jakarta.ws.rs.core.SecurityContext sc = this.m.get(jakarta.ws.rs.core.SecurityContext.class);
        return sc == null ? new SecurityContextImpl(this.m) : sc;
    }

    public UriInfo getUriInfo() {
        return new UriInfoImpl(this.m);
    }

    public boolean hasEntity() {
        InputStream is = this.getEntityStream();
        if (is == null) {
            return false;
        }
        if (HttpUtils.isPayloadEmpty(this.getHeaders())) {
            return false;
        }
        if (is instanceof DelegatingInputStream) {
            ((DelegatingInputStream)is).cacheInput();
        }
        try {
            return !IOUtils.isEmpty(is);
        }
        catch (IOException ex) {
            throw ExceptionUtils.toInternalServerErrorException(ex, null);
        }
    }

    public void setEntityStream(InputStream is) {
        this.checkContext();
        this.m.setContent(InputStream.class, is);
    }

    public MultivaluedMap<String, String> getHeaders() {
        this.h = null;
        return HttpUtils.getModifiableStringHeaders(this.m);
    }

    public void setRequestUri(URI requestUri) throws IllegalStateException {
        if (requestUri.isAbsolute()) {
            String baseUriString = new UriInfoImpl(this.m).getBaseUri().toString();
            String requestUriString = requestUri.toString();
            if (!requestUriString.startsWith(baseUriString)) {
                String query;
                Object path = requestUri.getRawPath();
                if (StringUtils.isEmpty((String)path)) {
                    path = "/";
                }
                if (!StringUtils.isEmpty(query = requestUri.getRawQuery())) {
                    path = (String)path + "?" + query;
                }
                this.setRequestUri(requestUri.resolve("/"), URI.create((String)path));
                return;
            }
            if ((requestUriString = requestUriString.substring(baseUriString.length())).isEmpty()) {
                requestUriString = "/";
            }
            requestUri = URI.create(requestUriString);
        }
        this.doSetRequestUri(requestUri);
    }

    protected void doSetRequestUri(URI requestUri) throws IllegalStateException {
        this.checkNotPreMatch();
        HttpUtils.resetRequestURI(this.m, requestUri.getRawPath());
        String query = requestUri.getRawQuery();
        if (query != null) {
            this.m.put(Message.QUERY_STRING, query);
        }
    }

    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.doSetRequestUri(requestUri);
        Object servletRequest = this.m.get("HTTP.REQUEST");
        if (servletRequest != null) {
            ((HttpServletRequest)servletRequest).setAttribute(ENDPOINT_ADDRESS_PROPERTY, (Object)baseUri.toString());
            if (requestUri.isAbsolute() && baseUri.resolve("/").compareTo(requestUri.resolve("/")) != 0) {
                ((HttpServletRequest)servletRequest).setAttribute(ENDPOINT_URI_PROPERTY, (Object)requestUri.resolve("/"));
            }
        }
    }

    public void setSecurityContext(jakarta.ws.rs.core.SecurityContext sc) {
        this.checkContext();
        this.m.put(jakarta.ws.rs.core.SecurityContext.class, sc);
        if (sc instanceof SecurityContext) {
            this.m.put(SecurityContext.class, (SecurityContext)sc);
        }
    }

    private void checkNotPreMatch() {
        if (!this.preMatch) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void setMethod(String method) throws IllegalStateException {
        this.checkNotPreMatch();
        super.setMethod(method);
    }
}

