/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxws;

import jakarta.xml.ws.Holder;
import jakarta.xml.ws.handler.MessageContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.component.cxf.common.CxfPayload;
import org.apache.camel.component.cxf.common.DataFormat;
import org.apache.camel.component.cxf.common.message.CxfConstants;
import org.apache.camel.component.cxf.jaxws.CxfClientCallback;
import org.apache.camel.component.cxf.jaxws.CxfEndpoint;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.model.SoapHeaderInfo;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientCallback;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingMessageInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CxfProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(CxfProducer.class);
    private Client client;
    private CxfEndpoint endpoint;

    public CxfProducer(CxfEndpoint endpoint) throws Exception {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Service)this.endpoint);
        if (this.client == null) {
            this.client = this.endpoint.createClient();
        }
        this.endpoint.getChainedCxfConfigurer().configureClient(this.client);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.client != null) {
            this.client.destroy();
            this.client = null;
        }
    }

    public boolean process(Exchange camelExchange, AsyncCallback callback) {
        if (camelExchange.getProperty(ExchangePropertyKey.ACTIVE_SPAN) != null) {
            try {
                this.process(camelExchange);
            }
            catch (Exception e) {
                camelExchange.setException((Throwable)e);
            }
            callback.done(true);
            return true;
        }
        LOG.trace("Process exchange: {} (asynchronously)", (Object)camelExchange);
        try {
            ExchangeImpl cxfExchange = new ExchangeImpl();
            cxfExchange.put(Bus.class, this.endpoint.getBus());
            BindingOperationInfo boi = this.prepareBindingOperation(camelExchange, cxfExchange);
            HashMap<String, Object> invocationContext = new HashMap<String, Object>();
            HashMap responseContext = new HashMap();
            invocationContext.put("ResponseContext", responseContext);
            invocationContext.put("RequestContext", this.prepareRequest(camelExchange, cxfExchange));
            CxfClientCallback cxfClientCallback = new CxfClientCallback(callback, camelExchange, cxfExchange, boi, this.endpoint);
            this.client.invoke((ClientCallback)cxfClientCallback, boi, this.getParams(this.endpoint, camelExchange), invocationContext, cxfExchange);
            if (boi.getOperationInfo().isOneWay()) {
                callback.done(false);
            }
        }
        catch (Exception ex) {
            camelExchange.setException((Throwable)ex);
            callback.done(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange camelExchange) throws Exception {
        LOG.trace("Process exchange: {} (synchronously)", (Object)camelExchange);
        ExchangeImpl cxfExchange = new ExchangeImpl();
        cxfExchange.put(Bus.class, this.endpoint.getBus());
        BindingOperationInfo boi = this.prepareBindingOperation(camelExchange, cxfExchange);
        HashMap<String, Object> invocationContext = new HashMap<String, Object>();
        HashMap<String, Object> responseContext = new HashMap<String, Object>();
        invocationContext.put("ResponseContext", responseContext);
        invocationContext.put("RequestContext", this.prepareRequest(camelExchange, cxfExchange));
        try {
            this.client.invoke(boi, this.getParams(this.endpoint, camelExchange), invocationContext, (org.apache.cxf.message.Exchange)cxfExchange);
        }
        catch (Exception exception) {
            camelExchange.setException((Throwable)exception);
        }
        finally {
            if (this.endpoint.getCookieHandler() != null) {
                try {
                    Message inMessage = cxfExchange.getInMessage();
                    if (inMessage != null) {
                        Map cxfHeaders = CastUtils.cast((Map)inMessage.get(CxfConstants.PROTOCOL_HEADERS));
                        this.endpoint.getCookieHandler().storeCookies(camelExchange, this.endpoint.getRequestUri(camelExchange), cxfHeaders);
                    }
                }
                catch (IOException e) {
                    LOG.warn("Cannot store cookies. This exception is ignored.", (Throwable)e);
                }
            }
            if (!boi.getOperationInfo().isOneWay()) {
                this.endpoint.getCxfBinding().populateExchangeFromCxfResponse(camelExchange, cxfExchange, responseContext);
            }
        }
    }

    protected Map<String, Object> prepareRequest(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) throws Exception {
        WrappedMessageContext requestContext = new WrappedMessageContext(new HashMap<String, Object>(), null, MessageContext.Scope.APPLICATION);
        camelExchange.setProperty("mtom-enabled", (Object)String.valueOf(this.endpoint.isMtomEnabled()));
        DataFormat dataFormat = this.endpoint.getDataFormat();
        camelExchange.setProperty("CamelCXFDataFormat", (Object)dataFormat);
        LOG.trace("Set Camel Exchange property: {}={}", (Object)DataFormat.class.getName(), (Object)dataFormat);
        if (this.endpoint.isMergeProtocolHeaders()) {
            camelExchange.setProperty("CamelCxfProtocolHeadersMerged", (Object)Boolean.TRUE);
        }
        requestContext.put(DataFormat.class.getName(), (Object)dataFormat);
        if (dataFormat.dealias() == DataFormat.RAW) {
            cxfExchange.put("KeepConduitAlive", true);
            LOG.trace("Set CXF Exchange property: {}={}", (Object)"KeepConduitAlive", (Object)true);
        }
        this.endpoint.getCxfBinding().populateCxfRequestFromExchange(cxfExchange, camelExchange, (Map<String, Object>)((Object)requestContext));
        if (this.endpoint.getCookieHandler() != null) {
            try {
                boolean added;
                Map transportHeaders = CastUtils.cast((Map)requestContext.get(CxfConstants.PROTOCOL_HEADERS));
                if (transportHeaders == null) {
                    transportHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                    added = true;
                } else {
                    added = false;
                }
                transportHeaders.putAll(this.endpoint.getCookieHandler().loadCookies(camelExchange, this.endpoint.getRequestUri(camelExchange)));
                if (added && transportHeaders.size() > 0) {
                    requestContext.put(CxfConstants.PROTOCOL_HEADERS, transportHeaders);
                }
            }
            catch (IOException e) {
                LOG.warn("Cannot load cookies", (Throwable)e);
            }
        }
        requestContext.getScopes().remove(CxfConstants.PROTOCOL_HEADERS);
        return requestContext.getWrappedMap();
    }

    private BindingOperationInfo prepareBindingOperation(Exchange camelExchange, org.apache.cxf.message.Exchange cxfExchange) {
        BindingOperationInfo boi = this.getBindingOperationInfo(camelExchange);
        ObjectHelper.notNull((Object)boi, (String)"BindingOperationInfo");
        if (this.endpoint.getDataFormat() == DataFormat.PAYLOAD && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
            cxfExchange.put(BindingOperationInfo.class, boi);
        }
        camelExchange.setProperty(BindingOperationInfo.class.getName(), (Object)boi);
        LOG.trace("Set exchange property: BindingOperationInfo: {}", (Object)boi);
        if (this.endpoint.getDataFormat() != DataFormat.PAYLOAD && !this.endpoint.isWrapped() && boi != null && boi.isUnwrappedCapable()) {
            boi = boi.getUnwrappedOperation();
            LOG.trace("Unwrapped BOI {}", (Object)boi);
        }
        return boi;
    }

    private void checkParameterSize(CxfEndpoint endpoint, Exchange exchange, Object[] parameters) {
        int soapHeadersSize;
        int holdersSize;
        BindingOperationInfo boi = this.lookupBindingOperationInfo(endpoint, exchange);
        int expectMessagePartsSize = CxfProducer.tryGetExpectMessagePartsSize(parameters, boi);
        if (parameters.length > expectMessagePartsSize && CxfProducer.isValidSize(parameters, holdersSize = CxfProducer.computeHoldersSize(parameters), expectMessagePartsSize, soapHeadersSize = CxfProducer.computeSoapHeadersSize(boi))) {
            throw new IllegalArgumentException("Get the wrong parameter size to invoke the out service, Expect size " + (expectMessagePartsSize + holdersSize + soapHeadersSize) + ", Parameter size " + parameters.length + ". Please check if the message body matches the CXFEndpoint POJO Dataformat request.");
        }
    }

    private BindingOperationInfo lookupBindingOperationInfo(CxfEndpoint endpoint, Exchange exchange) {
        BindingOperationInfo boi = this.getBindingOperationInfo(exchange);
        if (boi == null) {
            throw new RuntimeCamelException("Can't find the binding operation information from camel exchange");
        }
        if (!endpoint.isWrapped() && boi.isUnwrappedCapable()) {
            boi = boi.getUnwrappedOperation();
        }
        return boi;
    }

    private static int computeSoapHeadersSize(BindingOperationInfo boi) {
        List<SoapHeaderInfo> headers;
        int soapHeadersSize = 0;
        BindingMessageInfo bmi = boi.getInput();
        if (bmi != null && (headers = bmi.getExtensors(SoapHeaderInfo.class)) != null) {
            soapHeadersSize = headers.size();
        }
        return soapHeadersSize;
    }

    private static boolean isValidSize(Object[] parameters, int holdersSize, int expectMessagePartsSize, int soapHeadersSize) {
        return holdersSize + expectMessagePartsSize + soapHeadersSize < parameters.length;
    }

    private static int computeHoldersSize(Object[] parameters) {
        int holdersSize = 0;
        for (Object parameter : parameters) {
            if (!(parameter instanceof Holder)) continue;
            ++holdersSize;
        }
        return holdersSize;
    }

    private static int tryGetExpectMessagePartsSize(Object[] parameters, BindingOperationInfo boi) {
        int expectMessagePartsSize = boi.getInput().getMessageParts().size();
        if (parameters.length < expectMessagePartsSize) {
            throw new IllegalArgumentException("Get the wrong parameter size to invoke the out service, Expect size " + expectMessagePartsSize + ", Parameter size " + parameters.length + ". Please check if the message body matches the CXFEndpoint POJO Dataformat request.");
        }
        return expectMessagePartsSize;
    }

    private Object[] getParams(CxfEndpoint endpoint, Exchange exchange) throws InvalidPayloadException {
        Object[] params = null;
        if (endpoint.getDataFormat() == DataFormat.POJO) {
            Object body = exchange.getIn().getBody();
            if (body == null) {
                return new Object[0];
            }
            if (body instanceof Object[]) {
                params = (Object[])body;
            } else if (body instanceof List) {
                params = ((List)body).toArray();
            } else {
                List list;
                Iterator it = (Iterator)exchange.getIn().getBody(Iterator.class);
                if (it != null && it.hasNext() && (list = (List)exchange.getContext().getTypeConverter().convertTo(List.class, (Object)it)) != null) {
                    params = list.toArray();
                }
                if (params == null) {
                    params = new Object[]{exchange.getIn().getBody()};
                }
            }
            this.checkParameterSize(endpoint, exchange, params);
        } else if (endpoint.getDataFormat() == DataFormat.PAYLOAD) {
            params = new Object[]{exchange.getIn().getMandatoryBody(CxfPayload.class)};
        } else if (endpoint.getDataFormat().dealias() == DataFormat.RAW) {
            params = new Object[]{exchange.getIn().getMandatoryBody(InputStream.class)};
        } else if (endpoint.getDataFormat().dealias() == DataFormat.CXF_MESSAGE) {
            params = new Object[]{exchange.getIn().getBody()};
        }
        if (LOG.isTraceEnabled() && params != null) {
            for (int i = 0; i < params.length; ++i) {
                LOG.trace("params[{}] = {}", (Object)i, params[i]);
            }
        }
        return params;
    }

    private BindingOperationInfo getBindingOperationInfo(Exchange ex) {
        CxfEndpoint cxfEndpoint = (CxfEndpoint)this.getEndpoint();
        BindingOperationInfo answer = null;
        String lp = (String)ex.getIn().getHeader("operationName", String.class);
        if (lp == null) {
            LOG.debug("CxfProducer cannot find the {} from message header, trying with defaultOperationName", (Object)"operationName");
            lp = cxfEndpoint.getDefaultOperationName();
        }
        if (lp == null) {
            LOG.debug("CxfProducer cannot find the {} from message header and there is no DefaultOperationName setting, CxfProducer will pick up the first available operation.", (Object)"operationName");
            Collection<BindingOperationInfo> bois = this.client.getEndpoint().getEndpointInfo().getBinding().getOperations();
            Iterator<BindingOperationInfo> iter = bois.iterator();
            if (iter.hasNext()) {
                answer = iter.next();
            }
        } else {
            String ns = (String)ex.getIn().getHeader("operationNamespace", String.class);
            if (ns == null) {
                ns = cxfEndpoint.getDefaultOperationNamespace();
            }
            if (ns == null) {
                ns = this.client.getEndpoint().getService().getName().getNamespaceURI();
                LOG.trace("Operation namespace not in header. Set it to: {}", (Object)ns);
            }
            QName qname = new QName(ns, lp);
            LOG.trace("Operation qname = {}", (Object)qname);
            answer = this.client.getEndpoint().getEndpointInfo().getBinding().getOperation(qname);
            if (answer == null) {
                throw new IllegalArgumentException("Can't find the BindingOperationInfo with operation name " + String.valueOf(qname) + ". Please check the message headers of operationName and operationNamespace.");
            }
        }
        return answer;
    }

    public Client getClient() {
        return this.client;
    }
}

