/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.spi.DataFormat;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

public class DataFormatProvider<T>
implements MessageBodyWriter<T>,
MessageBodyReader<T> {
    private final Map<String, DataFormat> formats = new HashMap<String, DataFormat>();

    public boolean isReadable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return this.getDataFormat(mt) != null;
    }

    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return this.getDataFormat(mt) != null;
    }

    public T readFrom(Class<T> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        DataFormat format = this.getValidDataFormat(mt);
        try {
            Object result = format.unmarshal(null, is);
            return (T)result;
        }
        catch (Exception ex) {
            throw new BadRequestException((Throwable)ex);
        }
    }

    public long getSize(T obj, Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return -1L;
    }

    public void writeTo(T obj, Class<?> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        DataFormat format = this.getValidDataFormat(mt);
        try {
            format.marshal(null, obj, os);
        }
        catch (Exception ex) {
            throw new InternalServerErrorException((Throwable)ex);
        }
    }

    public void setFormat(DataFormat format) {
        this.setFormat("*/*", format);
    }

    public void setFormat(String mediaType, DataFormat format) {
        this.formats.put(mediaType, format);
    }

    public void setFormats(Map<String, DataFormat> formats) {
        this.formats.putAll(formats);
    }

    private DataFormat getValidDataFormat(MediaType mt) {
        DataFormat format = this.getDataFormat(mt);
        if (format == null) {
            throw new InternalServerErrorException();
        }
        return format;
    }

    private DataFormat getDataFormat(MediaType mt) {
        String type = JAXRSUtils.mediaTypeToString(mt, new String[0]);
        DataFormat format = this.formats.get(type);
        if (format != null) {
            return format;
        }
        int subtypeIndex = type.lastIndexOf(43);
        if (subtypeIndex != -1) {
            format = this.formats.get(type.substring(0, subtypeIndex));
        }
        if (format == null && this.formats.containsKey("*/*")) {
            format = this.formats.get("*/*");
        }
        return format;
    }
}

