/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.cxf.common.UnitOfWorkCloserInterceptor;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsInvoker;
import org.apache.camel.component.cxf.util.CxfUtils;
import org.apache.camel.support.DefaultConsumer;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.transport.MessageObserver;

public class CxfRsConsumer
extends DefaultConsumer
implements Suspendable {
    private Server server;

    public CxfRsConsumer(CxfRsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public boolean isHostedService() {
        return true;
    }

    protected Server createServer() {
        CxfRsEndpoint endpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsInvoker cxfRsInvoker = new CxfRsInvoker(endpoint, this);
        JAXRSServerFactoryBean svrBean = endpoint.createJAXRSServerFactoryBean();
        Bus bus = endpoint.getBus();
        if (bus != null) {
            svrBean.setBus(bus);
        }
        svrBean.setInvoker(cxfRsInvoker);
        svrBean.getInInterceptors().add(new UnitOfWorkCloserInterceptor("post-invoke", true));
        svrBean.getOutInterceptors().add(new UnitOfWorkCloserInterceptor());
        svrBean.getOutFaultInterceptors().add(new UnitOfWorkCloserInterceptor());
        Server server = svrBean.create();
        MessageObserver originalOutFaultObserver = server.getEndpoint().getOutFaultObserver();
        server.getEndpoint().setOutFaultObserver(message -> {
            CxfUtils.closeCamelUnitOfWork(message);
            originalOutFaultObserver.onMessage(message);
        });
        return server;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.server == null) {
            this.server = this.createServer();
        }
        this.server.start();
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
        super.doStop();
    }

    public Server getServer() {
        return this.server;
    }
}

