/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.util.Map;
import org.apache.camel.component.cxf.interceptors.RawMessageWSDLGetOutInterceptor;
import org.apache.cxf.binding.soap.interceptor.EndpointSelectionInterceptor;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.w3c.dom.Document;

public class RawMessageWSDLGetInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final RawMessageWSDLGetInterceptor INSTANCE = new RawMessageWSDLGetInterceptor();
    public static final String DOCUMENT_HOLDER = RawMessageWSDLGetInterceptor.class.getName() + ".documentHolder";

    public RawMessageWSDLGetInterceptor() {
        super("read");
        this.getAfter().add(EndpointSelectionInterceptor.class.getName());
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        String method = (String)message.get("org.apache.cxf.request.method");
        String query = (String)message.get(Message.QUERY_STRING);
        if (!"GET".equals(method) || StringUtils.isEmpty(query)) {
            return;
        }
        String baseUri = (String)message.get("org.apache.cxf.request.url");
        String ctx = (String)message.get(Message.PATH_INFO);
        Map<String, String> map = UrlUtils.parseQueryString(query);
        if (this.isRecognizedQuery(map)) {
            Document doc = this.getDocument(message, baseUri, map, ctx);
            Endpoint e = message.getExchange().get(Endpoint.class);
            Message mout = new MessageImpl();
            mout.setExchange(message.getExchange());
            mout = e.getBinding().createMessage(mout);
            mout.setInterceptorChain(OutgoingChainInterceptor.getOutInterceptorChain(message.getExchange()));
            message.getExchange().setOutMessage(mout);
            mout.put(DOCUMENT_HOLDER, doc);
            for (Interceptor inInterceptor : mout.getInterceptorChain()) {
                AbstractPhaseInterceptor interceptor;
                if (inInterceptor instanceof AbstractPhaseInterceptor && ((interceptor = (AbstractPhaseInterceptor)inInterceptor).getPhase().equals("prepare-send") || interceptor.getPhase().equals("pre-stream"))) continue;
                mout.getInterceptorChain().remove(inInterceptor);
            }
            mout.getInterceptorChain().add(RawMessageWSDLGetOutInterceptor.INSTANCE);
            message.getInterceptorChain().doInterceptStartingAt(message, OutgoingChainInterceptor.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getDocument(Message message, String base, Map<String, String> params, String ctxUri) {
        Endpoint endpoint = message.getExchange().getEndpoint();
        synchronized (endpoint) {
            return new WSDLGetUtils().getDocument(message, base, params, ctxUri, message.getExchange().getEndpoint().getEndpointInfo());
        }
    }

    private boolean isRecognizedQuery(Map<String, String> map) {
        return map.containsKey("wsdl") || map.containsKey("xsd");
    }
}

