/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.endpoint;

import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;
import org.apache.camel.Endpoint;
import org.apache.camel.Message;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.Processor;
import org.apache.camel.component.consul.ConsulConfiguration;
import org.apache.camel.component.consul.ConsulEndpoint;
import org.apache.camel.support.HeaderSelectorProducer;
import org.apache.camel.util.ObjectHelper;
import org.kiwiproject.consul.Consul;
import org.kiwiproject.consul.model.ConsulResponse;
import org.kiwiproject.consul.option.ConsistencyMode;
import org.kiwiproject.consul.option.ImmutableQueryOptions;
import org.kiwiproject.consul.option.QueryOptions;

abstract class AbstractConsulProducer<C>
extends HeaderSelectorProducer {
    private final ConsulEndpoint endpoint;
    private final ConsulConfiguration configuration;
    private final Function<Consul, C> clientSupplier;
    private C client;

    protected AbstractConsulProducer(ConsulEndpoint endpoint, ConsulConfiguration configuration, Function<Consul, C> clientSupplier) {
        super((Endpoint)endpoint, "CamelConsulAction", configuration.getAction());
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.clientSupplier = clientSupplier;
        this.client = null;
    }

    protected C getClient() throws Exception {
        if (this.client == null) {
            this.client = this.clientSupplier.apply(this.endpoint.getConsul());
        }
        return this.client;
    }

    protected ConsulConfiguration getConfiguration() {
        return this.configuration;
    }

    protected <D> D getMandatoryHeader(Message message, String header, Class<D> type) throws NoSuchHeaderException {
        return this.getMandatoryHeader(message, header, null, type);
    }

    protected <D> D getMandatoryHeader(Message message, String header, D defaultValue, Class<D> type) throws NoSuchHeaderException {
        Object value = message.getHeader(header, defaultValue, type);
        if (value == null) {
            throw new NoSuchHeaderException(message.getExchange(), header, type);
        }
        return (D)value;
    }

    protected QueryOptions buildQueryOptions(Message message, ConsulConfiguration conf) {
        ImmutableQueryOptions.Builder builder = ImmutableQueryOptions.builder();
        ObjectHelper.ifNotEmpty((Object)((BigInteger)message.getHeader("CamelConsulIndex", BigInteger.class)), arg_0 -> ((ImmutableQueryOptions.Builder)builder).index(arg_0));
        ObjectHelper.ifNotEmpty((Object)((String)message.getHeader("CamelConsulWait", String.class)), arg_0 -> ((ImmutableQueryOptions.Builder)builder).wait(arg_0));
        ObjectHelper.ifNotEmpty((Object)((String)message.getHeader("CamelConsulDatacenter", (Object)conf.getDatacenter(), String.class)), arg_0 -> ((ImmutableQueryOptions.Builder)builder).datacenter(arg_0));
        ObjectHelper.ifNotEmpty((Object)((String)message.getHeader("CamelConsulNearNode", (Object)conf.getNearNode(), String.class)), arg_0 -> ((ImmutableQueryOptions.Builder)builder).near(arg_0));
        ObjectHelper.ifNotEmpty((Object)conf.getAclToken(), arg_0 -> ((ImmutableQueryOptions.Builder)builder).token(arg_0));
        ObjectHelper.ifNotEmpty((Object)((ConsistencyMode)message.getHeader("CamelConsulConsistencyMode", (Object)conf.getConsistencyMode(), ConsistencyMode.class)), arg_0 -> ((ImmutableQueryOptions.Builder)builder).consistencyMode(arg_0));
        ObjectHelper.ifNotEmpty((Object)((List)message.getHeader("CamelConsulNodeMeta", conf.getNodeMeta(), List.class)), arg_0 -> ((ImmutableQueryOptions.Builder)builder).nodeMeta(arg_0));
        return builder.build();
    }

    protected <T> void processConsulResponse(Message message, ConsulResponse<T> response) {
        message.setHeader("CamelConsulIndex", (Object)response.getIndex());
        message.setHeader("CamelConsulLastContact", (Object)response.getLastContact());
        message.setHeader("CamelConsulKnownLeader", (Object)response.isKnownLeader());
        this.setBodyAndResult(message, response.getResponse());
    }

    protected void setBodyAndResult(Message message, Object body) {
        this.setBodyAndResult(message, body, body != null);
    }

    protected void setBodyAndResult(Message message, Object body, boolean result) {
        message.setHeader("CamelConsulResult", (Object)result);
        if (body != null) {
            message.setBody(body);
        }
    }

    protected Processor wrap(Function<C, Object> supplier) {
        return exchange -> this.setBodyAndResult(exchange.getIn(), supplier.apply(this.getClient()));
    }
}

