/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.BrowsableVariableRepository;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.support.console.AbstractDevConsole;
import org.apache.camel.util.json.JsonObject;

@DevConsole(name="variables", description="Displays variables")
public class VariablesDevConsole
extends AbstractDevConsole {
    public VariablesDevConsole() {
        super("camel", "variables", "Variables", "Displays variables");
    }

    protected String doCallText(Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Set repos = this.getCamelContext().getRegistry().findByType(BrowsableVariableRepository.class);
        for (BrowsableVariableRepository repo : repos) {
            sb.append("\n");
            sb.append(String.format("Repository: %s (size: %d)", repo.getId(), repo.size()));
            for (Map.Entry entry : repo.getVariables().entrySet()) {
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                String t = v != null ? v.getClass().getName() : "<null>";
                sb.append(String.format("\n    %s (%s) = %s", k, t, v));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected JsonObject doCallJson(Map<String, Object> options) {
        JsonObject root = new JsonObject();
        Set repos = this.getCamelContext().getRegistry().findByType(BrowsableVariableRepository.class);
        for (BrowsableVariableRepository repo : repos) {
            List<JsonObject> arr = VariablesDevConsole.toJsonObjects(repo);
            if (arr.isEmpty()) continue;
            root.put((Object)repo.getId(), arr);
        }
        return root;
    }

    private static List<JsonObject> toJsonObjects(BrowsableVariableRepository repo) {
        ArrayList<JsonObject> arr = new ArrayList<JsonObject>();
        for (Map.Entry entry : repo.getVariables().entrySet()) {
            String k = (String)entry.getKey();
            Object v = entry.getValue();
            String t = v != null ? v.getClass().getName() : null;
            JsonObject e = new JsonObject();
            e.put((Object)"key", (Object)k);
            if (t != null) {
                e.put((Object)"type", (Object)t);
            }
            e.put((Object)"value", v);
            arr.add(e);
        }
        return arr;
    }
}

