/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.coap;

import java.util.Iterator;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.coap.CamelCoapResource;
import org.apache.camel.coap.CoAPEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.eclipse.californium.core.server.resources.Resource;

public class CoAPConsumer
extends DefaultConsumer {
    private final CoAPEndpoint endpoint;

    public CoAPConsumer(CoAPEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    public CoAPEndpoint getCoapEndpoint() {
        return this.endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        Iterator<String> pathSegmentIterator = this.endpoint.getPathSegmentsFromURI().iterator();
        Resource cr = this.endpoint.getCoapServer().getRoot();
        while (pathSegmentIterator.hasNext()) {
            String pathSegment = pathSegmentIterator.next();
            Object child = cr.getChild(pathSegment);
            if (child == null) {
                child = new CamelCoapResource(pathSegment, this);
                ((CamelCoapResource)((Object)child)).setObservable(this.endpoint.isObservable());
                cr.add(child);
                cr = child;
                continue;
            }
            if (!pathSegmentIterator.hasNext()) {
                ((CamelCoapResource)((Object)child)).addConsumer(this);
                continue;
            }
            cr = child;
        }
    }
}

