/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.clickup.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import org.apache.camel.component.clickup.model.TaskTimeTrackedUpdatedEventAction;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskTimeTrackedUpdatedEventData
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final String TIME_TRACKING_CREATED_DESCRIPTION = "Time Tracking Created";
    public static final String TIME_TRACKING_EDITED_DESCRIPTION = "Time Tracking Edited";
    public static final String TIME_TRACKING_DELETED_DESCRIPTION = "Time Tracking Deleted";
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="interval_id")
    private String IntervalId;

    public String getDescription() {
        return this.description;
    }

    public String getIntervalId() {
        return this.IntervalId;
    }

    public TaskTimeTrackedUpdatedEventAction getEventAction() {
        return switch (this.description) {
            case TIME_TRACKING_CREATED_DESCRIPTION -> TaskTimeTrackedUpdatedEventAction.CREATION;
            case TIME_TRACKING_EDITED_DESCRIPTION -> TaskTimeTrackedUpdatedEventAction.UPDATE;
            case TIME_TRACKING_DELETED_DESCRIPTION -> TaskTimeTrackedUpdatedEventAction.DELETION;
            default -> throw new RuntimeException("Could not determine event action. Unknown event description: " + this.description);
        };
    }

    public String toString() {
        return "TaskTimeTrackedUpdatedEventData{description='" + this.description + "', IntervalId='" + this.IntervalId + "'}";
    }
}

