/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util.blueprint;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.blueprint.BlueprintCamelContextLookupHelper;
import org.apache.camel.core.xml.util.jsse.AbstractSSLContextParametersFactoryBean;
import org.apache.camel.util.blueprint.KeyManagersParametersFactoryBean;
import org.apache.camel.util.blueprint.SSLContextClientParametersFactoryBean;
import org.apache.camel.util.blueprint.SSLContextServerParametersFactoryBean;
import org.apache.camel.util.blueprint.SecureRandomParametersFactoryBean;
import org.apache.camel.util.blueprint.TrustManagersParametersFactoryBean;
import org.osgi.service.blueprint.container.BlueprintContainer;

@XmlRootElement(name="sslContextParameters")
@XmlType(propOrder={})
public class SSLContextParametersFactoryBean
extends AbstractSSLContextParametersFactoryBean {
    private KeyManagersParametersFactoryBean keyManagers;
    private TrustManagersParametersFactoryBean trustManagers;
    private SecureRandomParametersFactoryBean secureRandom;
    private SSLContextClientParametersFactoryBean clientParameters;
    private SSLContextServerParametersFactoryBean serverParameters;
    @XmlTransient
    private BlueprintContainer blueprintContainer;

    public KeyManagersParametersFactoryBean getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManagersParametersFactoryBean keyManagers) {
        this.keyManagers = keyManagers;
    }

    public TrustManagersParametersFactoryBean getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManagersParametersFactoryBean trustManagers) {
        this.trustManagers = trustManagers;
    }

    public SecureRandomParametersFactoryBean getSecureRandom() {
        return this.secureRandom;
    }

    public void setSecureRandom(SecureRandomParametersFactoryBean secureRandom) {
        this.secureRandom = secureRandom;
    }

    public SSLContextClientParametersFactoryBean getClientParameters() {
        return this.clientParameters;
    }

    public void setClientParameters(SSLContextClientParametersFactoryBean clientParameters) {
        this.clientParameters = clientParameters;
    }

    public SSLContextServerParametersFactoryBean getServerParameters() {
        return this.serverParameters;
    }

    public void setServerParameters(SSLContextServerParametersFactoryBean serverParameters) {
        this.serverParameters = serverParameters;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    protected CamelContext getCamelContextWithId(String camelContextId) {
        if (this.blueprintContainer != null) {
            return (CamelContext)this.blueprintContainer.getComponentInstance(camelContextId);
        }
        return null;
    }

    protected CamelContext discoverDefaultCamelContext() {
        Set<String> ids;
        if (this.blueprintContainer != null && (ids = BlueprintCamelContextLookupHelper.lookupBlueprintCamelContext(this.blueprintContainer)).size() == 1) {
            return this.getCamelContextWithId(ids.iterator().next());
        }
        return null;
    }
}

