/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.TypeConverter;
import org.apache.camel.blueprint.BlueprintCamelStateService;
import org.apache.camel.blueprint.BlueprintContainerBeanRepository;
import org.apache.camel.blueprint.BlueprintModelJAXBContextFactory;
import org.apache.camel.blueprint.handler.CamelNamespaceHandler;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.karaf.core.AbstractOsgiDefaultCamelContext;
import org.apache.camel.karaf.core.OsgiBeanRepository;
import org.apache.camel.karaf.core.OsgiCamelContextHelper;
import org.apache.camel.karaf.core.OsgiCamelContextPublisher;
import org.apache.camel.karaf.core.OsgiTypeConverter;
import org.apache.camel.karaf.core.utils.BundleContextUtils;
import org.apache.camel.karaf.core.utils.BundleDelegatingClassLoader;
import org.apache.camel.spi.BeanRepository;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.DefaultRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.osgi.service.blueprint.container.BlueprintEvent;
import org.osgi.service.blueprint.container.BlueprintListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintCamelContext
extends AbstractOsgiDefaultCamelContext
implements ServiceListener,
BlueprintListener {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintCamelContext.class);
    protected final AtomicBoolean routeDefinitionValid = new AtomicBoolean(true);
    private BlueprintContainer blueprintContainer;
    private ServiceRegistration<?> registration;
    private BlueprintCamelStateService bundleStateService;

    public BlueprintCamelContext(BundleContext bundleContext, BlueprintContainer blueprintContainer) {
        super(bundleContext);
        this.blueprintContainer = blueprintContainer;
        this.getLifecycleStrategies().removeIf(l -> l.getClass().getSimpleName().contains("OnCamelContextLifecycleStrategy"));
        OsgiCamelContextHelper.osgiUpdate((DefaultCamelContext)this, (BundleContext)bundleContext);
        BlueprintContainerBeanRepository repo1 = new BlueprintContainerBeanRepository(this.getBlueprintContainer());
        OsgiBeanRepository repo2 = new OsgiBeanRepository(bundleContext);
        this.getCamelContextExtension().setRegistry((Registry)new DefaultRegistry(new BeanRepository[]{repo1, repo2}));
        this.addLifecycleStrategy((LifecycleStrategy)repo2);
        this.setApplicationContextClassLoader((ClassLoader)new BundleDelegatingClassLoader(bundleContext.getBundle()));
        this.build();
    }

    protected ModelJAXBContextFactory createModelJAXBContextFactory() {
        return new BlueprintModelJAXBContextFactory(CamelNamespaceHandler.class.getClassLoader());
    }

    public BlueprintContainer getBlueprintContainer() {
        return this.blueprintContainer;
    }

    public void setBlueprintContainer(BlueprintContainer blueprintContainer) {
        this.blueprintContainer = blueprintContainer;
    }

    public BlueprintCamelStateService getBundleStateService() {
        return this.bundleStateService;
    }

    public void setBundleStateService(BlueprintCamelStateService bundleStateService) {
        this.bundleStateService = bundleStateService;
    }

    public void doBuild() throws Exception {
        LOG.trace("build {}", (Object)this);
        BundleContext bundleContext = this.getBundleContext();
        bundleContext.addServiceListener((ServiceListener)this);
        this.registration = bundleContext.registerService(BlueprintListener.class, (Object)this, null);
        super.doBuild();
    }

    public void destroy() throws Exception {
        LOG.trace("destroy {}", (Object)this);
        BundleContext bundleContext = this.getBundleContext();
        try {
            bundleContext.removeServiceListener((ServiceListener)this);
        }
        catch (Exception e) {
            LOG.warn("Error removing ServiceListener: " + this + ". This exception is ignored.", (Throwable)e);
        }
        if (this.registration != null) {
            try {
                this.registration.unregister();
            }
            catch (Exception e) {
                LOG.warn("Error unregistering service registration: " + this.registration + ". This exception is ignored.", (Throwable)e);
            }
            this.registration = null;
        }
        this.bundleStateService.setBundleState(bundleContext.getBundle(), this.getName(), null);
        this.stop();
    }

    public void blueprintEvent(BlueprintEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received BlueprintEvent[replay={} type={} bundle={}] {}", new Object[]{event.isReplay(), switch (event.getType()) {
                case 1 -> "CREATING";
                case 2 -> "CREATED";
                case 3 -> "DESTROYING";
                case 4 -> "DESTROYED";
                case 6 -> "GRACE_PERIOD";
                case 7 -> "WAITING";
                case 5 -> "FAILURE";
                default -> "UNKNOWN";
            }, event.getBundle().getSymbolicName(), event});
        }
        if (!event.isReplay() && this.getBundleContext().getBundle().getBundleId() == event.getBundle().getBundleId() && event.getType() == 2) {
            try {
                LOG.info("Attempting to start CamelContext: {}", (Object)this.getName());
                this.maybeStart();
            }
            catch (Exception startEx) {
                LOG.error("Error occurred during starting CamelContext: {}", (Object)this.getName(), (Object)startEx);
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Service: {} changed to: {}", (Object)event, (Object)(switch (event.getType()) {
                case 1 -> "REGISTERED";
                case 2 -> "MODIFIED";
                case 4 -> "UNREGISTERING";
                case 8 -> "MODIFIED_ENDMATCH";
                default -> "UNKNOWN";
            }));
        }
    }

    protected TypeConverter createTypeConverter() {
        BundleContext ctx = BundleContextUtils.getBundleContext(((Object)((Object)this)).getClass());
        if (ctx == null) {
            ctx = this.getBundleContext();
        }
        return new OsgiTypeConverter(ctx, (CamelContext)this, this.getInjector());
    }

    public void start() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        BundleContext bundleContext = this.getBundleContext();
        try {
            Thread.currentThread().setContextClassLoader(this.getApplicationContextClassLoader());
            this.bundleStateService.setBundleState(bundleContext.getBundle(), this.getName(), BlueprintCamelStateService.State.Starting);
            super.start();
            this.bundleStateService.setBundleState(bundleContext.getBundle(), this.getName(), BlueprintCamelStateService.State.Active);
        }
        catch (Exception e) {
            this.bundleStateService.setBundleState(bundleContext.getBundle(), this.getName(), BlueprintCamelStateService.State.Failure, e);
            this.routeDefinitionValid.set(false);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    private void maybeStart() throws Exception {
        boolean skip;
        LOG.trace("maybeStart: {}", (Object)this);
        if (!this.routeDefinitionValid.get()) {
            LOG.trace("maybeStart: {} is skipping since CamelRoute definition is not correct.", (Object)this);
            return;
        }
        boolean eager = "true".equalsIgnoreCase(System.getProperty("registerBlueprintCamelContextEager"));
        if (eager) {
            for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
                if (!(notifier instanceof OsgiCamelContextPublisher)) continue;
                OsgiCamelContextPublisher publisher = (OsgiCamelContextPublisher)notifier;
                publisher.registerCamelContext((CamelContext)this);
                break;
            }
        }
        if (skip = "true".equalsIgnoreCase(System.getProperty("skipStartingCamelContext"))) {
            LOG.trace("maybeStart: {} is skipping as System property skipStartingCamelContext is set", (Object)this);
            return;
        }
        if (!this.isStarted() && !this.isStarting()) {
            LOG.debug("Starting {}", (Object)this);
            this.start();
        } else {
            LOG.trace("Ignoring maybeStart() as {} is already started", (Object)this);
        }
    }
}

