/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.blueprint;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.ext.PropertyPlaceholderExt;
import org.apache.camel.spi.PropertiesSource;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ReflectionHelper;
import org.osgi.service.blueprint.container.BlueprintContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintPropertiesSource
extends ServiceSupport
implements PropertiesSource {
    private static final Logger LOG = LoggerFactory.getLogger(BlueprintPropertiesSource.class);
    private final BlueprintContainer container;
    private final List<String> ids;
    private final Set<PropertyPlaceholderWrapper> placeholders = new LinkedHashSet<PropertyPlaceholderWrapper>();

    public BlueprintPropertiesSource(BlueprintContainer container, List<String> ids) {
        this.container = container;
        this.ids = ids;
    }

    public String getName() {
        return "BlueprintPropertiesSource" + String.valueOf(this.ids);
    }

    public String getProperty(String name) {
        String answer = null;
        for (PropertyPlaceholderWrapper placeholder : this.placeholders) {
            boolean isDefault = false;
            if (this.placeholders.size() > 1) {
                Map map = placeholder.getDefaultProperties();
                isDefault = map != null && map.containsKey(name);
                LOG.trace("Blueprint property key: {} is part of default properties: {}", (Object)name, (Object)isDefault);
            }
            try {
                String candidate = placeholder.retrieveValue(name);
                if (candidate == null || answer != null && isDefault) continue;
                LOG.trace("Blueprint candidate property key: {} as value: {}", (Object)name, answer);
                answer = candidate;
            }
            catch (Exception exception) {}
        }
        LOG.debug("Blueprint getProperty: {}={}", (Object)name, answer);
        return answer;
    }

    private void addPropertyPlaceholder(String id) {
        Class<?> clazz;
        Object component = this.container.getComponentInstance(id);
        if (component instanceof PropertyPlaceholderExt && (clazz = component.getClass()) != null) {
            LOG.debug("Adding Blueprint PropertyPlaceholder: {}", (Object)id);
            Method method = ReflectionHelper.findMethod(clazz, (String)"retrieveValue", (Class[])new Class[]{String.class});
            Method defaultMethod = ReflectionHelper.findMethod(clazz, (String)"getDefaultProperties", (Class[])new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                if (defaultMethod != null) {
                    defaultMethod.setAccessible(true);
                }
                this.placeholders.add(new PropertyPlaceholderWrapper(component, method, defaultMethod));
            } else {
                throw new IllegalStateException("Cannot add blueprint property placeholder: " + id + " as the method retrieveValue is not found");
            }
        }
    }

    protected void doInit() throws Exception {
        for (String id : this.ids) {
            this.addPropertyPlaceholder(id);
        }
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    private class PropertyPlaceholderWrapper {
        private final Object delegate;
        private final Method method;
        private final Method defaultMethod;

        PropertyPlaceholderWrapper(Object delegate, Method method, Method defaultMethod) {
            this.delegate = delegate;
            this.method = method;
            this.defaultMethod = defaultMethod;
        }

        String retrieveValue(String key) {
            Object v = ObjectHelper.invokeMethod((Method)this.method, (Object)this.delegate, (Object[])new Object[]{key});
            return v == null ? null : v.toString();
        }

        Map getDefaultProperties() {
            if (this.defaultMethod != null) {
                return (Map)ObjectHelper.invokeMethod((Method)this.defaultMethod, (Object)this.delegate, (Object[])new Object[0]);
            }
            return null;
        }
    }
}

