/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.servicebus;

import com.azure.core.credential.TokenCredential;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.azure.servicebus.ServiceBusConfiguration;
import org.apache.camel.component.azure.servicebus.ServiceBusEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="azure-servicebus")
public class ServiceBusComponent
extends DefaultComponent {
    @Metadata
    private ServiceBusConfiguration configuration = new ServiceBusConfiguration();

    public ServiceBusComponent() {
    }

    public ServiceBusComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("A queue or topic name must be specified.");
        }
        ServiceBusConfiguration configuration = this.configuration != null ? this.configuration.copy() : new ServiceBusConfiguration();
        configuration.setTopicOrQueueName(remaining);
        ServiceBusEndpoint endpoint = new ServiceBusEndpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.setCredentials(configuration);
        this.validateConfigurations(configuration);
        return endpoint;
    }

    private void setCredentials(ServiceBusConfiguration configuration) {
        Set tokenCredentialFromRegistry;
        if (ObjectHelper.isNotEmpty((String)configuration.getFullyQualifiedNamespace()) && ObjectHelper.isEmpty((Object)configuration.getTokenCredential()) && (tokenCredentialFromRegistry = this.getCamelContext().getRegistry().findByType(TokenCredential.class)).size() == 1) {
            configuration.setTokenCredential((TokenCredential)tokenCredentialFromRegistry.stream().findFirst().get());
        }
    }

    public ServiceBusConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ServiceBusConfiguration configuration) {
        this.configuration = configuration;
    }

    private void validateConfigurations(ServiceBusConfiguration configuration) {
        if ((configuration.getProcessorClient() == null || configuration.getSenderClient() == null) && ObjectHelper.isEmpty((String)configuration.getConnectionString()) && ObjectHelper.isEmpty((String)configuration.getFullyQualifiedNamespace())) {
            throw new IllegalArgumentException("Azure ServiceBus ConnectionString or FQNS must be specified.");
        }
    }
}

