/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs.client.impl;

import java.net.URI;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.apache.camel.component.aws2.sqs.client.Sqs2InternalClient;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.SqsClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

public class Sqs2ClientIAMProfileOptimizedImpl
implements Sqs2InternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(Sqs2ClientIAMProfileOptimizedImpl.class);
    private Sqs2Configuration configuration;

    public Sqs2ClientIAMProfileOptimizedImpl(Sqs2Configuration configuration) {
        LOG.trace("Creating an AWS SQS manager using static credentials.");
        this.configuration = configuration;
    }

    @Override
    public SqsClient getSQSClient() {
        SqsClient client = null;
        SqsClientBuilder clientBuilder = SqsClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((String)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(String.valueOf(this.configuration.getProxyProtocol()) + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getProfileCredentialsName() != null) {
            clientBuilder = isClientConfigFound ? (SqsClientBuilder)((SqsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.configuration.getProfileCredentialsName())) : (SqsClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.create((String)this.configuration.getProfileCredentialsName()));
        } else if (!isClientConfigFound) {
            clientBuilder = (SqsClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (!this.isDefaultAwsHost()) {
            String endpointOverrideUri = this.getAwsEndpointUri();
            clientBuilder.endpointOverride(URI.create(endpointOverrideUri));
        }
        if (ObjectHelper.isNotEmpty((String)this.configuration.getRegion())) {
            clientBuilder = (SqsClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isOverrideEndpoint()) {
            clientBuilder.endpointOverride(URI.create(this.configuration.getUriEndpointOverride()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            if (httpClientBuilder == null) {
                httpClientBuilder = ApacheHttpClient.builder();
            }
            SdkHttpClient ahc = httpClientBuilder.buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
            clientBuilder.httpClientBuilder(null);
        }
        client = (SqsClient)clientBuilder.build();
        return client;
    }

    private boolean isDefaultAwsHost() {
        return this.configuration.getAmazonAWSHost().equals("amazonaws.com");
    }

    private String getAwsEndpointUri() {
        return this.configuration.getProtocol() + "://" + this.getFullyQualifiedAWSHost();
    }

    private String getFullyQualifiedAWSHost() {
        String host = this.configuration.getAmazonAWSHost();
        host = FileUtil.stripTrailingSeparator((String)host);
        if (this.isDefaultAwsHost()) {
            return "sqs." + Region.of((String)this.configuration.getRegion()).id() + "." + host;
        }
        return host;
    }
}

