/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.redshift.data;

import java.util.Collection;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Configuration;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Endpoint;
import org.apache.camel.component.aws2.redshift.data.RedshiftData2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.redshiftdata.RedshiftDataClient;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.CancelStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableRequest;
import software.amazon.awssdk.services.redshiftdata.model.DescribeTableResponse;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.redshiftdata.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultRequest;
import software.amazon.awssdk.services.redshiftdata.model.GetStatementResultResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListDatabasesResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListSchemasResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListStatementsResponse;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesRequest;
import software.amazon.awssdk.services.redshiftdata.model.ListTablesResponse;

public class RedshiftData2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(RedshiftData2Producer.class);
    private transient String redshiftDataProducerToString;

    public RedshiftData2Producer(Endpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case listDatabases: {
                this.listDatabases(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case listSchemas: {
                this.listSchemas(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case listStatements: {
                this.listStatements(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case listTables: {
                this.listTables(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case describeTable: {
                this.describeTable(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case executeStatement: {
                this.executeStatement(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case batchExecuteStatement: {
                this.batchExecuteStatement(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case cancelStatement: {
                this.cancelStatement(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case describeStatement: {
                this.describeStatement(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            case getStatementResult: {
                this.getStatementResult(this.getConfiguration().getAwsRedshiftDataClient(), exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private RedshiftData2Operations determineOperation(Exchange exchange) {
        RedshiftData2Operations operation = (RedshiftData2Operations)((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataOperation", RedshiftData2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }

    protected RedshiftData2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    public String toString() {
        if (this.redshiftDataProducerToString == null) {
            this.redshiftDataProducerToString = "RedshiftDataProducer[" + URISupport.sanitizeUri((String)this.getEndpoint().getEndpointUri()) + "]";
        }
        return this.redshiftDataProducerToString;
    }

    public RedshiftData2Endpoint getEndpoint() {
        return (RedshiftData2Endpoint)super.getEndpoint();
    }

    private void listDatabases(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListDatabasesRequest) {
                ListDatabasesResponse result;
                ListDatabasesRequest request = (ListDatabasesRequest)payload;
                try {
                    result = redshiftDataClient.listDatabases(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Databases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListDatabasesResponse result;
            ListDatabasesRequest.Builder builder = ListDatabasesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier"))) {
                String clusterIdentifier = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier", String.class);
                builder.clusterIdentifier(clusterIdentifier);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase", String.class);
                builder.database(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser"))) {
                String dbUser = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser", String.class);
                builder.dbUser(dbUser);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn"))) {
                String secretArn = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn", String.class);
                builder.secretArn(secretArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabasesMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabasesMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName"))) {
                String workgroupName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName", String.class);
                builder.workgroupName(workgroupName);
            }
            try {
                result = redshiftDataClient.listDatabases((ListDatabasesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Databases command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listSchemas(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListSchemasRequest) {
                ListSchemasResponse result;
                ListSchemasRequest request = (ListSchemasRequest)payload;
                try {
                    result = redshiftDataClient.listSchemas(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Schemas command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListSchemasResponse result;
            ListSchemasRequest.Builder builder = ListSchemasRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier"))) {
                String clusterIdentifier = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier", String.class);
                builder.clusterIdentifier(clusterIdentifier);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase", String.class);
                builder.database(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser"))) {
                String dbUser = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser", String.class);
                builder.dbUser(dbUser);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn"))) {
                String secretArn = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn", String.class);
                builder.secretArn(secretArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSchemasMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsRedshiftDataSchemasMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName"))) {
                String workgroupName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName", String.class);
                builder.workgroupName(workgroupName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataConnectedDatabase"))) {
                String connectedDatabase = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataConnectedDatabase", String.class);
                builder.connectedDatabase(connectedDatabase);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSchemaPattern"))) {
                String schemaPattern = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSchemaPattern", String.class);
                builder.schemaPattern(schemaPattern);
            }
            try {
                result = redshiftDataClient.listSchemas((ListSchemasRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Schemas command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listStatements(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListStatementsRequest) {
                ListStatementsResponse result;
                ListStatementsRequest request = (ListStatementsRequest)payload;
                try {
                    result = redshiftDataClient.listStatements(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Statements command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListStatementsResponse result;
            ListStatementsRequest.Builder builder = ListStatementsRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataRoleLevel"))) {
                Boolean roleLevel = (Boolean)exchange.getIn().getHeader("CamelAwsRedshiftDataRoleLevel", Boolean.class);
                builder.roleLevel(roleLevel);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatus"))) {
                String status = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatus", String.class);
                builder.status(status);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementName"))) {
                String statementName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementName", String.class);
                builder.statementName(statementName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementsMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementsMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            try {
                result = redshiftDataClient.listStatements((ListStatementsRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Statements command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void listTables(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ListTablesRequest) {
                ListTablesResponse result;
                ListTablesRequest request = (ListTablesRequest)payload;
                try {
                    result = redshiftDataClient.listTables(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("List Tables command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ListTablesResponse result;
            ListTablesRequest.Builder builder = ListTablesRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier"))) {
                String clusterIdentifier = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier", String.class);
                builder.clusterIdentifier(clusterIdentifier);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase", String.class);
                builder.database(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser"))) {
                String dbUser = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser", String.class);
                builder.dbUser(dbUser);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn"))) {
                String secretArn = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn", String.class);
                builder.secretArn(secretArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataTablesMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsRedshiftDataTablesMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName"))) {
                String workgroupName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName", String.class);
                builder.workgroupName(workgroupName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataConnectedDatabase"))) {
                String connectedDatabase = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataConnectedDatabase", String.class);
                builder.connectedDatabase(connectedDatabase);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSchemaPattern"))) {
                String schemaPattern = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSchemaPattern", String.class);
                builder.schemaPattern(schemaPattern);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataTablePattern"))) {
                String tablePattern = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataTablePattern", String.class);
                builder.tablePattern(tablePattern);
            }
            try {
                result = redshiftDataClient.listTables((ListTablesRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("List Tables command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeTable(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeTableRequest) {
                DescribeTableResponse result;
                DescribeTableRequest request = (DescribeTableRequest)payload;
                try {
                    result = redshiftDataClient.describeTable(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeTableResponse result;
            DescribeTableRequest.Builder builder = DescribeTableRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier"))) {
                String clusterIdentifier = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier", String.class);
                builder.clusterIdentifier(clusterIdentifier);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase", String.class);
                builder.database(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser"))) {
                String dbUser = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser", String.class);
                builder.dbUser(dbUser);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn"))) {
                String secretArn = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn", String.class);
                builder.secretArn(secretArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDescribeTableMaxResults"))) {
                Integer maxResults = (Integer)exchange.getIn().getHeader("CamelAwsRedshiftDataDescribeTableMaxResults", Integer.class);
                builder.maxResults(maxResults);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName"))) {
                String workgroupName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName", String.class);
                builder.workgroupName(workgroupName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataConnectedDatabase"))) {
                String connectedDatabase = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataConnectedDatabase", String.class);
                builder.connectedDatabase(connectedDatabase);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataTable"))) {
                String table = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataTable", String.class);
                builder.table(table);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSchema"))) {
                String schema = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSchema", String.class);
                builder.schema(schema);
            }
            try {
                result = redshiftDataClient.describeTable((DescribeTableRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Table command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void executeStatement(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof ExecuteStatementRequest) {
                ExecuteStatementResponse result;
                ExecuteStatementRequest request = (ExecuteStatementRequest)payload;
                try {
                    result = redshiftDataClient.executeStatement(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Execute Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            ExecuteStatementResponse result;
            ExecuteStatementRequest.Builder builder = ExecuteStatementRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier"))) {
                String clusterIdentifier = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier", String.class);
                builder.clusterIdentifier(clusterIdentifier);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase", String.class);
                builder.database(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser"))) {
                String dbUser = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser", String.class);
                builder.dbUser(dbUser);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn"))) {
                String secretArn = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn", String.class);
                builder.secretArn(secretArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName"))) {
                String workgroupName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName", String.class);
                builder.workgroupName(workgroupName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementName"))) {
                String statementName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementName", String.class);
                builder.statementName(statementName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWithEvent"))) {
                Boolean withEvent = (Boolean)exchange.getIn().getHeader("CamelAwsRedshiftDataWithEvent", Boolean.class);
                builder.withEvent(withEvent);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClientToken"))) {
                String clientToken = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClientToken", String.class);
                builder.clientToken(clientToken);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSqlStatement"))) {
                String sqlStatement = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSqlStatement", String.class);
                builder.sql(sqlStatement);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSqlParameterList"))) {
                List sqlParameterList = (List)exchange.getIn().getHeader("CamelAwsRedshiftDataSqlParameterList", List.class);
                builder.parameters((Collection)sqlParameterList);
            }
            try {
                result = redshiftDataClient.executeStatement((ExecuteStatementRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Execute Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void batchExecuteStatement(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof BatchExecuteStatementRequest) {
                BatchExecuteStatementResponse result;
                BatchExecuteStatementRequest request = (BatchExecuteStatementRequest)payload;
                try {
                    result = redshiftDataClient.batchExecuteStatement(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Batch Execute Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            BatchExecuteStatementResponse result;
            BatchExecuteStatementRequest.Builder builder = BatchExecuteStatementRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier"))) {
                String clusterIdentifier = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClusterIdentifier", String.class);
                builder.clusterIdentifier(clusterIdentifier);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase"))) {
                String database = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDatabase", String.class);
                builder.database(database);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser"))) {
                String dbUser = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataDbUser", String.class);
                builder.dbUser(dbUser);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn"))) {
                String secretArn = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataSecretArn", String.class);
                builder.secretArn(secretArn);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName"))) {
                String workgroupName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataWorkGroupName", String.class);
                builder.workgroupName(workgroupName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementName"))) {
                String statementName = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementName", String.class);
                builder.statementName(statementName);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataWithEvent"))) {
                Boolean withEvent = (Boolean)exchange.getIn().getHeader("CamelAwsRedshiftDataWithEvent", Boolean.class);
                builder.withEvent(withEvent);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataClientToken"))) {
                String clientToken = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataClientToken", String.class);
                builder.clientToken(clientToken);
            }
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataSqlStatementList"))) {
                List sqlStatements = (List)exchange.getIn().getHeader("CamelAwsRedshiftDataSqlStatementList", List.class);
                builder.sqls((Collection)sqlStatements);
            }
            try {
                result = redshiftDataClient.batchExecuteStatement((BatchExecuteStatementRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Batch Execute Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void cancelStatement(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof CancelStatementRequest) {
                CancelStatementResponse result;
                CancelStatementRequest request = (CancelStatementRequest)payload;
                try {
                    result = redshiftDataClient.cancelStatement(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Cancel Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            CancelStatementResponse result;
            CancelStatementRequest.Builder builder = CancelStatementRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementId"))) {
                String id = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementId", String.class);
                builder.id(id);
            }
            try {
                result = redshiftDataClient.cancelStatement((CancelStatementRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Cancel Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void describeStatement(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof DescribeStatementRequest) {
                DescribeStatementResponse result;
                DescribeStatementRequest request = (DescribeStatementRequest)payload;
                try {
                    result = redshiftDataClient.describeStatement(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Describe Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            DescribeStatementResponse result;
            DescribeStatementRequest.Builder builder = DescribeStatementRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementId"))) {
                String id = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementId", String.class);
                builder.id(id);
            }
            try {
                result = redshiftDataClient.describeStatement((DescribeStatementRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Describe Statement command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    private void getStatementResult(RedshiftDataClient redshiftDataClient, Exchange exchange) throws InvalidPayloadException {
        if (this.getConfiguration().isPojoRequest()) {
            Object payload = exchange.getIn().getMandatoryBody();
            if (payload instanceof GetStatementResultRequest) {
                GetStatementResultResponse result;
                GetStatementResultRequest request = (GetStatementResultRequest)payload;
                try {
                    result = redshiftDataClient.getStatementResult(request);
                }
                catch (AwsServiceException ase) {
                    LOG.trace("Get Statement Result command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                    throw ase;
                }
                Message message = RedshiftData2Producer.getMessageForResponse(exchange);
                message.setBody((Object)result);
            }
        } else {
            GetStatementResultResponse result;
            GetStatementResultRequest.Builder builder = GetStatementResultRequest.builder();
            if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementId"))) {
                String id = (String)exchange.getIn().getHeader("CamelAwsRedshiftDataStatementId", String.class);
                builder.id(id);
            }
            try {
                result = redshiftDataClient.getStatementResult((GetStatementResultRequest)builder.build());
            }
            catch (AwsServiceException ase) {
                LOG.trace("Get Statement Result command returned the error code {}", (Object)ase.awsErrorDetails().errorCode());
                throw ase;
            }
            Message message = RedshiftData2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }
}

