/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.mq.client;

import org.apache.camel.component.aws2.mq.MQ2Configuration;
import org.apache.camel.component.aws2.mq.client.MQ2InternalClient;
import org.apache.camel.component.aws2.mq.client.impl.MQ2ClientOptimizedImpl;
import org.apache.camel.component.aws2.mq.client.impl.MQ2ClientProfileOptimizedImpl;
import org.apache.camel.component.aws2.mq.client.impl.MQ2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.mq.client.impl.MQ2ClientStandardImpl;

public final class MQ2ClientFactory {
    private MQ2ClientFactory() {
    }

    public static MQ2InternalClient getMqClient(MQ2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new MQ2ClientOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new MQ2ClientProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new MQ2ClientSessionTokenImpl(configuration);
        }
        return new MQ2ClientStandardImpl(configuration);
    }
}

