/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ecs.client;

import org.apache.camel.component.aws2.ecs.ECS2Configuration;
import org.apache.camel.component.aws2.ecs.client.ECS2InternalClient;
import org.apache.camel.component.aws2.ecs.client.impl.ECS2ClientIAMOptimizedImpl;
import org.apache.camel.component.aws2.ecs.client.impl.ECS2ClientIAMProfileOptimizedImpl;
import org.apache.camel.component.aws2.ecs.client.impl.ECS2ClientSessionTokenImpl;
import org.apache.camel.component.aws2.ecs.client.impl.ECS2ClientStandardImpl;

public final class ECS2ClientFactory {
    private ECS2ClientFactory() {
    }

    public static ECS2InternalClient getEcsClient(ECS2Configuration configuration) {
        if (Boolean.TRUE.equals(configuration.isUseDefaultCredentialsProvider())) {
            return new ECS2ClientIAMOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseProfileCredentialsProvider())) {
            return new ECS2ClientIAMProfileOptimizedImpl(configuration);
        }
        if (Boolean.TRUE.equals(configuration.isUseSessionCredentials())) {
            return new ECS2ClientSessionTokenImpl(configuration);
        }
        return new ECS2ClientStandardImpl(configuration);
    }
}

