/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.internal;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.as2.AS2AsyncMDNServerManagerEndpointConfiguration;
import org.apache.camel.component.as2.AS2ClientManagerEndpointConfiguration;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2ServerManagerEndpointConfiguration;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.component.as2.internal.AS2AsyncMDNServerManagerApiMethod;
import org.apache.camel.component.as2.internal.AS2ClientManagerApiMethod;
import org.apache.camel.component.as2.internal.AS2ServerManagerApiMethod;
import org.apache.camel.support.component.ApiCollection;
import org.apache.camel.support.component.ApiMethodHelper;

public final class AS2ApiCollection
extends ApiCollection<AS2ApiName, AS2Configuration> {
    private static AS2ApiCollection collection;

    private AS2ApiCollection() {
        HashMap aliases = new HashMap();
        EnumMap<AS2ApiName, ApiMethodHelper> apiHelpers = new EnumMap<AS2ApiName, ApiMethodHelper>(AS2ApiName.class);
        HashMap<Class<AS2AsyncMDNServerManagerApiMethod>, AS2ApiName> apiMethods = new HashMap<Class<AS2AsyncMDNServerManagerApiMethod>, AS2ApiName>();
        aliases.clear();
        List<String> nullableArgs = Arrays.asList("ediMessageTransferEncoding", "signingAlgorithm", "signingCertificateChain", "signingPrivateKey", "compressionAlgorithm", "dispositionNotificationTo", "signedReceiptMicAlgorithms", "encryptingAlgorithm", "encryptingCertificateChain", "attachedFileName", "receiptDeliveryOption");
        apiHelpers.put(AS2ApiName.CLIENT, new ApiMethodHelper(AS2ClientManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2ClientManagerApiMethod.class, AS2ApiName.CLIENT);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(AS2ApiName.SERVER, new ApiMethodHelper(AS2ServerManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2ServerManagerApiMethod.class, AS2ApiName.SERVER);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(AS2ApiName.RECEIPT, new ApiMethodHelper(AS2AsyncMDNServerManagerApiMethod.class, aliases, nullableArgs));
        apiMethods.put(AS2AsyncMDNServerManagerApiMethod.class, AS2ApiName.RECEIPT);
        this.setApiHelpers(apiHelpers);
        this.setApiMethods(apiMethods);
    }

    public AS2Configuration getEndpointConfiguration(AS2ApiName apiName) {
        AS2Configuration result = null;
        switch (apiName) {
            case CLIENT: {
                result = new AS2ClientManagerEndpointConfiguration();
                break;
            }
            case SERVER: {
                result = new AS2ServerManagerEndpointConfiguration();
                break;
            }
            case RECEIPT: {
                result = new AS2AsyncMDNServerManagerEndpointConfiguration();
            }
        }
        return result;
    }

    public static synchronized AS2ApiCollection getCollection() {
        if (collection == null) {
            collection = new AS2ApiCollection();
        }
        return collection;
    }
}

