/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2.api;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2CompressionAlgorithm;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.api.AS2SignedDataGenerator;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeCompressedDataEntity;
import org.apache.camel.component.as2.api.entity.ApplicationPkcs7MimeEnvelopedDataEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.entity.MultipartSignedEntity;
import org.apache.camel.component.as2.api.util.CompressionUtils;
import org.apache.camel.component.as2.api.util.EncryptingUtils;
import org.apache.camel.component.as2.api.util.EntityUtils;
import org.apache.camel.component.as2.api.util.SigningUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.bouncycastle.cms.CMSCompressedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.operator.OutputCompressor;
import org.bouncycastle.operator.OutputEncryptor;

public class AS2ClientManager {
    public static final String CAMEL_AS2_CLIENT_PREFIX = "camel-as2.client.";
    public static final String AS2_MESSAGE_STRUCTURE = "camel-as2.client.as2-message-structure";
    public static final String EDI_MESSAGE_CONTENT_TYPE = "camel-as2.client.edi-message-content-type";
    public static final String EDI_MESSAGE_TRANSFER_ENCODING = "camel-as2.client.edi-message-transfer-encoding";
    public static final String HTTP_REQUEST = "http.request";
    public static final String HTTP_RESPONSE = "http.response";
    public static final String AS2_CONNECTION = "camel-as2.client.as2-connection";
    public static final String REQUEST_URI = "camel-as2.client.request-uri";
    public static final String SUBJECT = "camel-as2.client.subject";
    public static final String FROM = "camel-as2.client.from";
    public static final String AS2_FROM = "camel-as2.client.as2-from";
    public static final String AS2_TO = "camel-as2.client.as2-to";
    public static final String SIGNING_ALGORITHM = "camel-as2.client.signing-algorithm";
    public static final String SIGNING_CERTIFICATE_CHAIN = "camel-as2.client.signing-certificate-chain";
    public static final String SIGNING_PRIVATE_KEY = "camel-as2.client.signing-private-key";
    public static final String ENCRYPTING_ALGORITHM = "camel-as2.client.encrypting-algorithm-name";
    public static final String ENCRYPTING_CERTIFICATE_CHAIN = "camel-as2.client.encrypting-certificate-chain";
    public static final String COMPRESSION_ALGORITHM = "camel-as2.client.compression-algorithm-name";
    public static final String DISPOSITION_NOTIFICATION_TO = "camel-as2.client.disposition-notification-to";
    public static final String SIGNED_RECEIPT_MIC_ALGORITHMS = "camel-as2.client.signed-receipt-mic-algorithms";
    public static final String RECEIPT_DELIVERY_OPTION = "camel-as2.client.Receipt-Delivery-Option";
    private AS2ClientConnection as2ClientConnection;

    public AS2ClientManager(AS2ClientConnection as2ClientConnection) {
        this.as2ClientConnection = as2ClientConnection;
    }

    public HttpCoreContext send(String ediMessage, String requestUri, String subject, String from, String as2From, String as2To, AS2MessageStructure as2MessageStructure, ContentType ediMessageContentType, String ediMessageTransferEncoding, AS2SignatureAlgorithm signingAlgorithm, Certificate[] signingCertificateChain, PrivateKey signingPrivateKey, AS2CompressionAlgorithm compressionAlgorithm, String dispositionNotificationTo, String[] signedReceiptMicAlgorithms, AS2EncryptionAlgorithm encryptingAlgorithm, Certificate[] encryptingCertificateChain, String attachedFileName, String receiptDeliveryOption) throws HttpException {
        ApplicationEntity applicationEntity;
        ObjectHelper.notNull((Object)ediMessage, (String)"EDI Message");
        ObjectHelper.notNull((Object)requestUri, (String)"Request URI");
        ObjectHelper.notNull((Object)subject, (String)"Subject");
        ObjectHelper.notNull((Object)from, (String)"From");
        ObjectHelper.notNull((Object)as2From, (String)"AS2From");
        ObjectHelper.notNull((Object)as2To, (String)"AS2To");
        ObjectHelper.notNull((Object)((Object)as2MessageStructure), (String)"AS2 Message Structure");
        ObjectHelper.notNull((Object)ediMessageContentType, (String)"EDI Message Content Type");
        HttpCoreContext httpContext = HttpCoreContext.create();
        httpContext.setAttribute(REQUEST_URI, (Object)requestUri);
        httpContext.setAttribute(SUBJECT, (Object)subject);
        httpContext.setAttribute(FROM, (Object)from);
        httpContext.setAttribute(AS2_FROM, (Object)as2From);
        httpContext.setAttribute(AS2_TO, (Object)as2To);
        httpContext.setAttribute(AS2_MESSAGE_STRUCTURE, (Object)as2MessageStructure);
        httpContext.setAttribute(EDI_MESSAGE_CONTENT_TYPE, (Object)ediMessageContentType);
        httpContext.setAttribute(EDI_MESSAGE_TRANSFER_ENCODING, (Object)ediMessageTransferEncoding);
        httpContext.setAttribute(SIGNING_ALGORITHM, (Object)signingAlgorithm);
        httpContext.setAttribute(SIGNING_CERTIFICATE_CHAIN, (Object)signingCertificateChain);
        httpContext.setAttribute(SIGNING_PRIVATE_KEY, (Object)signingPrivateKey);
        httpContext.setAttribute(COMPRESSION_ALGORITHM, (Object)compressionAlgorithm);
        httpContext.setAttribute(DISPOSITION_NOTIFICATION_TO, (Object)dispositionNotificationTo);
        httpContext.setAttribute(SIGNED_RECEIPT_MIC_ALGORITHMS, (Object)signedReceiptMicAlgorithms);
        httpContext.setAttribute(ENCRYPTING_ALGORITHM, (Object)encryptingAlgorithm);
        httpContext.setAttribute(ENCRYPTING_CERTIFICATE_CHAIN, (Object)encryptingCertificateChain);
        httpContext.setAttribute(RECEIPT_DELIVERY_OPTION, (Object)receiptDeliveryOption);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest("POST", requestUri);
        request.setVersion(new ProtocolVersion("HTTP", 1, 1));
        httpContext.setAttribute(HTTP_REQUEST, (Object)request);
        try {
            applicationEntity = EntityUtils.createEDIEntity(ediMessage, ediMessageContentType, ediMessageTransferEncoding, false, attachedFileName);
        }
        catch (Exception e) {
            throw new HttpException("Failed to create EDI message entity", (Throwable)e);
        }
        switch (as2MessageStructure) {
            case PLAIN: {
                AS2ClientManager.plain(applicationEntity, request);
                break;
            }
            case SIGNED: {
                this.signed(httpContext, applicationEntity, request);
                break;
            }
            case ENCRYPTED: {
                this.encrypted(httpContext, applicationEntity, request);
                break;
            }
            case SIGNED_ENCRYPTED: {
                this.signedEncrypted(httpContext, applicationEntity, request);
                break;
            }
            case PLAIN_COMPRESSED: {
                this.plainCompressed(httpContext, applicationEntity, request);
                break;
            }
            case SIGNED_COMPRESSED: {
                this.signedCompressed(httpContext, applicationEntity, request);
                break;
            }
            case COMPRESSED_SIGNED: {
                this.compressedSigned(httpContext, applicationEntity, request);
                break;
            }
            case ENCRYPTED_COMPRESSED: {
                this.encryptedCompressed(httpContext, applicationEntity, request);
                break;
            }
            case ENCRYPTED_COMPRESSED_SIGNED: {
                this.encryptedCompressedSigned(httpContext, applicationEntity, request);
                break;
            }
            case ENCRYPTED_SIGNED_COMPRESSED: {
                this.encryptedSignedCompressed(httpContext, applicationEntity, request);
                break;
            }
            default: {
                throw new HttpException("Unknown AS2 Message Structure");
            }
        }
        HttpResponse response = this.sendRequest(httpContext, request);
        httpContext.setAttribute(HTTP_RESPONSE, (Object)response);
        return httpContext;
    }

    private HttpResponse sendRequest(HttpCoreContext httpContext, BasicClassicHttpRequest request) throws HttpException {
        HttpResponse response;
        try {
            httpContext.setAttribute(AS2_CONNECTION, (Object)this.as2ClientConnection);
            response = this.as2ClientConnection.send((ClassicHttpRequest)request, httpContext);
            EntityParser.parseAS2MessageEntity((HttpMessage)response);
        }
        catch (TimeoutException e) {
            throw new HttpException("Send operation timed out", (Throwable)e);
        }
        catch (IOException e) {
            throw new HttpException("Failed to send http request message", (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new HttpException("Interrupted while sending the http request", (Throwable)e);
        }
        catch (ExecutionException ex) {
            throw new HttpException("Retrieving connection from Pool failed or timed out", (Throwable)ex);
        }
        return response;
    }

    private void encryptedCompressedSigned(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator();
        OutputCompressor compressor = this.createCompressor(httpContext);
        ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(applicationEntity, compressedDataGenerator, compressor, "base64", false);
        AS2SignedDataGenerator signingGenerator = this.createSigningGenerator(httpContext);
        MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(pkcs7MimeCompressedDataEntity, signingGenerator, StandardCharsets.US_ASCII.name(), "base64", false, null);
        CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
        OutputEncryptor encryptor = this.createEncryptor(httpContext);
        ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(multipartSignedEntity, envelopedDataGenerator, encryptor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeEnvelopedDataEntity);
    }

    private void encryptedSignedCompressed(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        AS2SignedDataGenerator signingGenerator = this.createSigningGenerator(httpContext);
        MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEntity, signingGenerator, StandardCharsets.US_ASCII.name(), "base64", false, null);
        CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator();
        OutputCompressor compressor = this.createCompressor(httpContext);
        ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(multipartSignedEntity, compressedDataGenerator, compressor, "base64", false);
        CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
        OutputEncryptor encryptor = this.createEncryptor(httpContext);
        ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(pkcs7MimeCompressedDataEntity, envelopedDataGenerator, encryptor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeEnvelopedDataEntity);
    }

    private void encryptedCompressed(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator();
        OutputCompressor compressor = this.createCompressor(httpContext);
        ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(applicationEntity, compressedDataGenerator, compressor, "base64", false);
        CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
        OutputEncryptor encryptor = this.createEncryptor(httpContext);
        ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(pkcs7MimeCompressedDataEntity, envelopedDataGenerator, encryptor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeEnvelopedDataEntity);
    }

    private void compressedSigned(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator();
        OutputCompressor compressor = this.createCompressor(httpContext);
        ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(applicationEntity, compressedDataGenerator, compressor, "base64", false);
        AS2SignedDataGenerator signingGenerator = this.createSigningGenerator(httpContext);
        MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(pkcs7MimeCompressedDataEntity, signingGenerator, StandardCharsets.US_ASCII.name(), "base64", true, null);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)multipartSignedEntity);
    }

    private void signedCompressed(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        AS2SignedDataGenerator signingGenerator = this.createSigningGenerator(httpContext);
        MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEntity, signingGenerator, StandardCharsets.US_ASCII.name(), "base64", false, null);
        CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator();
        OutputCompressor compressor = this.createCompressor(httpContext);
        ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(multipartSignedEntity, compressedDataGenerator, compressor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeCompressedDataEntity);
    }

    private void plainCompressed(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        CMSCompressedDataGenerator compressedDataGenerator = this.createCompressorGenerator();
        OutputCompressor compressor = this.createCompressor(httpContext);
        ApplicationPkcs7MimeCompressedDataEntity pkcs7MimeCompressedDataEntity = new ApplicationPkcs7MimeCompressedDataEntity(applicationEntity, compressedDataGenerator, compressor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeCompressedDataEntity);
    }

    private void signedEncrypted(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        AS2SignedDataGenerator signingGenrator = this.createSigningGenerator(httpContext);
        MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEntity, signingGenrator, StandardCharsets.US_ASCII.name(), "base64", false, null);
        CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
        OutputEncryptor encryptor = this.createEncryptor(httpContext);
        ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(multipartSignedEntity, envelopedDataGenerator, encryptor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeEnvelopedDataEntity);
    }

    private void encrypted(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        CMSEnvelopedDataGenerator envelopedDataGenerator = this.createEncryptingGenerator(httpContext);
        OutputEncryptor encryptor = this.createEncryptor(httpContext);
        ApplicationPkcs7MimeEnvelopedDataEntity pkcs7MimeEnvelopedDataEntity = new ApplicationPkcs7MimeEnvelopedDataEntity(applicationEntity, envelopedDataGenerator, encryptor, "base64", true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)pkcs7MimeEnvelopedDataEntity);
    }

    private void signed(HttpCoreContext httpContext, ApplicationEntity applicationEntity, BasicClassicHttpRequest request) throws HttpException {
        AS2SignedDataGenerator signingGenerator = this.createSigningGenerator(httpContext);
        MultipartSignedEntity multipartSignedEntity = new MultipartSignedEntity(applicationEntity, signingGenerator, StandardCharsets.US_ASCII.name(), "base64", true, null);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)multipartSignedEntity);
    }

    private static void plain(ApplicationEntity applicationEntity, BasicClassicHttpRequest request) {
        applicationEntity.setMainBody(true);
        EntityUtils.setMessageEntity((HttpMessage)request, (HttpEntity)applicationEntity);
    }

    public AS2SignedDataGenerator createSigningGenerator(HttpCoreContext httpContext) throws HttpException {
        AS2SignatureAlgorithm signatureAlgorithm = (AS2SignatureAlgorithm)((Object)httpContext.getAttribute(SIGNING_ALGORITHM, AS2SignatureAlgorithm.class));
        if (signatureAlgorithm == null) {
            throw new HttpException("Signing algorithm missing");
        }
        Certificate[] certificateChain = (Certificate[])httpContext.getAttribute(SIGNING_CERTIFICATE_CHAIN, Certificate[].class);
        if (certificateChain == null) {
            throw new HttpException("Signing certificate chain missing");
        }
        PrivateKey privateKey = (PrivateKey)httpContext.getAttribute(SIGNING_PRIVATE_KEY, PrivateKey.class);
        if (privateKey == null) {
            throw new HttpException("Signing private key missing");
        }
        return SigningUtils.createSigningGenerator(signatureAlgorithm, certificateChain, privateKey);
    }

    public CMSEnvelopedDataGenerator createEncryptingGenerator(HttpCoreContext httpContext) throws HttpException {
        Certificate[] certificateChain = (Certificate[])httpContext.getAttribute(ENCRYPTING_CERTIFICATE_CHAIN, Certificate[].class);
        if (certificateChain == null) {
            throw new HttpException("Encrypting certificate chain missing");
        }
        return EncryptingUtils.createEnvelopDataGenerator(certificateChain);
    }

    public CMSCompressedDataGenerator createCompressorGenerator() {
        return CompressionUtils.createCompressedDataGenerator();
    }

    public OutputEncryptor createEncryptor(HttpCoreContext httpContext) throws HttpException {
        AS2EncryptionAlgorithm encryptionAlgorithm = (AS2EncryptionAlgorithm)((Object)httpContext.getAttribute(ENCRYPTING_ALGORITHM, AS2EncryptionAlgorithm.class));
        if (encryptionAlgorithm == null) {
            throw new HttpException("Encrypting algorithm missing");
        }
        return EncryptingUtils.createEncryptor(encryptionAlgorithm);
    }

    public OutputCompressor createCompressor(HttpCoreContext httpContext) throws HttpException {
        AS2CompressionAlgorithm compressionAlgorithm = (AS2CompressionAlgorithm)((Object)httpContext.getAttribute(COMPRESSION_ALGORITHM, AS2CompressionAlgorithm.class));
        if (compressionAlgorithm == null) {
            throw new HttpException("Compression algorithm missing");
        }
        return CompressionUtils.createCompressor(compressionAlgorithm);
    }
}

