/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.as2.AS2Configuration;
import org.apache.camel.component.as2.AS2Endpoint;
import org.apache.camel.component.as2.api.AS2ServerConnection;
import org.apache.camel.component.as2.api.AS2ServerManager;
import org.apache.camel.component.as2.api.entity.ApplicationEntity;
import org.apache.camel.component.as2.api.entity.EntityParser;
import org.apache.camel.component.as2.api.exception.AS2ErrorDispositionException;
import org.apache.camel.component.as2.api.util.HttpMessageUtils;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.support.component.AbstractApiConsumer;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiConsumerHelper;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodHelper;
import org.apache.camel.support.component.PropertyNamesInterceptor;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntityContainer;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2Consumer
extends AbstractApiConsumer<AS2ApiName, AS2Configuration>
implements HttpRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AS2Consumer.class);
    private static final String HANDLER_PROPERTY = "handler";
    private static final String REQUEST_URI_PROPERTY = "requestUri";
    private AS2ServerConnection as2ServerConnection;
    private AS2ServerManager apiProxy;
    private final ApiMethod apiMethod;
    private final Map<String, Object> properties;

    public AS2Consumer(AS2Endpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
        this.apiMethod = ApiConsumerHelper.findMethod((AbstractApiEndpoint)endpoint, (PropertyNamesInterceptor)this);
        this.properties = new HashMap<String, Object>();
        this.properties.putAll(endpoint.getEndpointProperties());
        this.properties.put(HANDLER_PROPERTY, (Object)this);
    }

    public void interceptPropertyNames(Set<String> propertyNames) {
        propertyNames.add(HANDLER_PROPERTY);
    }

    protected int poll() throws Exception {
        return 0;
    }

    public AS2Endpoint getEndpoint() {
        return (AS2Endpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.as2ServerConnection = this.getEndpoint().getAS2ServerConnection();
        this.apiProxy = new AS2ServerManager(this.as2ServerConnection);
        ApiMethodHelper.invokeMethod((Object)this.apiProxy, (ApiMethod)this.apiMethod, this.properties);
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException {
        Exception exception = null;
        try {
            if (request instanceof HttpEntityContainer) {
                EntityParser.parseAS2MessageEntity((HttpMessage)request);
                this.apiProxy.handleMDNResponse(context, this.getEndpoint().getSubject(), Optional.ofNullable(this.getEndpoint().getFrom()).orElse(((AS2Configuration)this.getEndpoint().getConfiguration()).getServer()));
            }
            ApplicationEntity ediEntity = HttpMessageUtils.extractEdiPayload((HttpMessage)request, new HttpMessageUtils.DecrpytingAndSigningInfo(this.as2ServerConnection.getValidateSigningCertificateChain(), this.as2ServerConnection.getDecryptingPrivateKey()));
            Exchange exchange = this.createExchange(false);
            try {
                HttpCoreContext coreContext = HttpCoreContext.adapt((HttpContext)context);
                exchange.setProperty("CamelAs2.interchange", (Object)coreContext);
                exchange.getIn().setBody(ediEntity.getEdiMessage());
                this.getProcessor().process(exchange);
            }
            finally {
                exception = exchange.getException();
                this.releaseExchange(exchange, false);
            }
        }
        catch (AS2ErrorDispositionException e) {
            LOG.warn("Failed to process AS2 message", (Throwable)((Object)e));
            context.setAttribute("Disposition-Modifier", (Object)e.getDispositionModifier());
        }
        catch (Exception e) {
            LOG.warn("Failed to process AS2 message", (Throwable)e);
            exception = e;
        }
        if (exception != null) {
            throw new HttpException("Failed to process AS2 message: " + exception.getMessage(), (Throwable)exception);
        }
    }
}

