/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.KameletStatus;
import org.apache.camel.v1.kameletstatus.Conditions;
import org.apache.camel.v1.kameletstatus.ConditionsBuilder;
import org.apache.camel.v1.kameletstatus.ConditionsFluent;
import org.apache.camel.v1.kameletstatus.Properties;
import org.apache.camel.v1.kameletstatus.PropertiesBuilder;
import org.apache.camel.v1.kameletstatus.PropertiesFluent;

public class KameletStatusFluent<A extends KameletStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ConditionsBuilder> conditions;
    private Long observedGeneration;
    private String phase;
    private ArrayList<PropertiesBuilder> properties;

    public KameletStatusFluent() {
    }

    public KameletStatusFluent(KameletStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KameletStatus instance) {
        KameletStatus kameletStatus = instance = instance != null ? instance : new KameletStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withPhase(instance.getPhase());
            this.withProperties(instance.getProperties());
        }
    }

    public A addToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConditions(int index, Conditions item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        ConditionsBuilder builder = new ConditionsBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConditions(Conditions ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Conditions ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Conditions> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Conditions item : items) {
            ConditionsBuilder builder = new ConditionsBuilder(item);
            this._visitables.get((Object)"conditions").remove((Object)builder);
            this.conditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConditions(Predicate<ConditionsBuilder> predicate) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        Iterator<ConditionsBuilder> each = this.conditions.iterator();
        List visitables = this._visitables.get((Object)"conditions");
        while (each.hasNext()) {
            ConditionsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Conditions> buildConditions() {
        return this.conditions != null ? KameletStatusFluent.build(this.conditions) : null;
    }

    public Conditions buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public Conditions buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public Conditions buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        for (ConditionsBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Conditions> conditions) {
        if (this.conditions != null) {
            this._visitables.get((Object)"conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Conditions ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Conditions item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(Conditions item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, Conditions item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)((Object)this);
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public A addToProperties(int index, Properties item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        PropertiesBuilder builder = new PropertiesBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToProperties(int index, Properties item) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        PropertiesBuilder builder = new PropertiesBuilder(item);
        if (index < 0 || index >= this.properties.size()) {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        } else {
            this._visitables.get((Object)"properties").add(builder);
            this.properties.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToProperties(Properties ... items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (Properties item : items) {
            PropertiesBuilder builder = new PropertiesBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToProperties(Collection<Properties> items) {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        for (Properties item : items) {
            PropertiesBuilder builder = new PropertiesBuilder(item);
            this._visitables.get((Object)"properties").add(builder);
            this.properties.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromProperties(Properties ... items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (Properties item : items) {
            PropertiesBuilder builder = new PropertiesBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromProperties(Collection<Properties> items) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        for (Properties item : items) {
            PropertiesBuilder builder = new PropertiesBuilder(item);
            this._visitables.get((Object)"properties").remove((Object)builder);
            this.properties.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromProperties(Predicate<PropertiesBuilder> predicate) {
        if (this.properties == null) {
            return (A)((Object)this);
        }
        Iterator<PropertiesBuilder> each = this.properties.iterator();
        List visitables = this._visitables.get((Object)"properties");
        while (each.hasNext()) {
            PropertiesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Properties> buildProperties() {
        return this.properties != null ? KameletStatusFluent.build(this.properties) : null;
    }

    public Properties buildProperty(int index) {
        return this.properties.get(index).build();
    }

    public Properties buildFirstProperty() {
        return this.properties.get(0).build();
    }

    public Properties buildLastProperty() {
        return this.properties.get(this.properties.size() - 1).build();
    }

    public Properties buildMatchingProperty(Predicate<PropertiesBuilder> predicate) {
        for (PropertiesBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingProperty(Predicate<PropertiesBuilder> predicate) {
        for (PropertiesBuilder item : this.properties) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withProperties(List<Properties> properties) {
        if (this.properties != null) {
            this._visitables.get((Object)"properties").clear();
        }
        if (properties != null) {
            this.properties = new ArrayList();
            for (Properties item : properties) {
                this.addToProperties(item);
            }
        } else {
            this.properties = null;
        }
        return (A)((Object)this);
    }

    public A withProperties(Properties ... properties) {
        if (this.properties != null) {
            this.properties.clear();
            this._visitables.remove((Object)"properties");
        }
        if (properties != null) {
            for (Properties item : properties) {
                this.addToProperties(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public PropertiesNested<A> addNewProperty() {
        return new PropertiesNested(-1, null);
    }

    public PropertiesNested<A> addNewPropertyLike(Properties item) {
        return new PropertiesNested(-1, item);
    }

    public PropertiesNested<A> setNewPropertyLike(int index, Properties item) {
        return new PropertiesNested(index, item);
    }

    public PropertiesNested<A> editProperty(int index) {
        if (this.properties.size() <= index) {
            throw new RuntimeException("Can't edit properties. Index exceeds size.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editFirstProperty() {
        if (this.properties.size() == 0) {
            throw new RuntimeException("Can't edit first properties. The list is empty.");
        }
        return this.setNewPropertyLike(0, this.buildProperty(0));
    }

    public PropertiesNested<A> editLastProperty() {
        int index = this.properties.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last properties. The list is empty.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public PropertiesNested<A> editMatchingProperty(Predicate<PropertiesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.properties.size(); ++i) {
            if (!predicate.test(this.properties.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching properties. No match found.");
        }
        return this.setNewPropertyLike(index, this.buildProperty(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KameletStatusFluent that = (KameletStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.observedGeneration, this.phase, this.properties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("properties:");
            sb.append(this.properties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends ConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        ConditionsBuilder builder;
        int index;

        ConditionsNested(int index, Conditions item) {
            this.index = index;
            this.builder = new ConditionsBuilder(this, item);
        }

        public N and() {
            return (N)KameletStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class PropertiesNested<N>
    extends PropertiesFluent<PropertiesNested<N>>
    implements Nested<N> {
        PropertiesBuilder builder;
        int index;

        PropertiesNested(int index, Properties item) {
            this.index = index;
            this.builder = new PropertiesBuilder(this, item);
        }

        public N and() {
            return (N)KameletStatusFluent.this.setToProperties(this.index, this.builder.build());
        }

        public N endProperty() {
            return this.and();
        }
    }
}

