/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationprofilestatus;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.integrationprofilestatus.Build;
import org.apache.camel.v1.integrationprofilestatus.build.Maven;
import org.apache.camel.v1.integrationprofilestatus.build.MavenBuilder;
import org.apache.camel.v1.integrationprofilestatus.build.MavenFluent;
import org.apache.camel.v1.integrationprofilestatus.build.Registry;
import org.apache.camel.v1.integrationprofilestatus.build.RegistryBuilder;
import org.apache.camel.v1.integrationprofilestatus.build.RegistryFluent;

public class BuildFluent<A extends BuildFluent<A>>
extends BaseFluent<A> {
    private String baseImage;
    private MavenBuilder maven;
    private RegistryBuilder registry;
    private String runtimeProvider;
    private String runtimeVersion;
    private String timeout;

    public BuildFluent() {
    }

    public BuildFluent(Build instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Build instance) {
        Build build = instance = instance != null ? instance : new Build();
        if (instance != null) {
            this.withBaseImage(instance.getBaseImage());
            this.withMaven(instance.getMaven());
            this.withRegistry(instance.getRegistry());
            this.withRuntimeProvider(instance.getRuntimeProvider());
            this.withRuntimeVersion(instance.getRuntimeVersion());
            this.withTimeout(instance.getTimeout());
        }
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage = baseImage;
        return (A)((Object)this);
    }

    public boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public Maven buildMaven() {
        return this.maven != null ? this.maven.build() : null;
    }

    public A withMaven(Maven maven) {
        this._visitables.remove((Object)"maven");
        if (maven != null) {
            this.maven = new MavenBuilder(maven);
            this._visitables.get((Object)"maven").add(this.maven);
        } else {
            this.maven = null;
            this._visitables.get((Object)"maven").remove((Object)this.maven);
        }
        return (A)((Object)this);
    }

    public boolean hasMaven() {
        return this.maven != null;
    }

    public MavenNested<A> withNewMaven() {
        return new MavenNested(null);
    }

    public MavenNested<A> withNewMavenLike(Maven item) {
        return new MavenNested(item);
    }

    public MavenNested<A> editBuildMaven() {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(null));
    }

    public MavenNested<A> editOrNewMaven() {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(new MavenBuilder().build()));
    }

    public MavenNested<A> editOrNewMavenLike(Maven item) {
        return this.withNewMavenLike(Optional.ofNullable(this.buildMaven()).orElse(item));
    }

    public Registry buildRegistry() {
        return this.registry != null ? this.registry.build() : null;
    }

    public A withRegistry(Registry registry) {
        this._visitables.remove((Object)"registry");
        if (registry != null) {
            this.registry = new RegistryBuilder(registry);
            this._visitables.get((Object)"registry").add(this.registry);
        } else {
            this.registry = null;
            this._visitables.get((Object)"registry").remove((Object)this.registry);
        }
        return (A)((Object)this);
    }

    public boolean hasRegistry() {
        return this.registry != null;
    }

    public RegistryNested<A> withNewRegistry() {
        return new RegistryNested(null);
    }

    public RegistryNested<A> withNewRegistryLike(Registry item) {
        return new RegistryNested(item);
    }

    public RegistryNested<A> editBuildRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(null));
    }

    public RegistryNested<A> editOrNewRegistry() {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(new RegistryBuilder().build()));
    }

    public RegistryNested<A> editOrNewRegistryLike(Registry item) {
        return this.withNewRegistryLike(Optional.ofNullable(this.buildRegistry()).orElse(item));
    }

    public String getRuntimeProvider() {
        return this.runtimeProvider;
    }

    public A withRuntimeProvider(String runtimeProvider) {
        this.runtimeProvider = runtimeProvider;
        return (A)((Object)this);
    }

    public boolean hasRuntimeProvider() {
        return this.runtimeProvider != null;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public A withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return (A)((Object)this);
    }

    public boolean hasRuntimeVersion() {
        return this.runtimeVersion != null;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public A withTimeout(String timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildFluent that = (BuildFluent)((Object)o);
        if (!Objects.equals(this.baseImage, that.baseImage)) {
            return false;
        }
        if (!Objects.equals((Object)this.maven, (Object)that.maven)) {
            return false;
        }
        if (!Objects.equals((Object)this.registry, (Object)that.registry)) {
            return false;
        }
        if (!Objects.equals(this.runtimeProvider, that.runtimeProvider)) {
            return false;
        }
        if (!Objects.equals(this.runtimeVersion, that.runtimeVersion)) {
            return false;
        }
        return Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.baseImage, this.maven, this.registry, this.runtimeProvider, this.runtimeVersion, this.timeout, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.baseImage != null) {
            sb.append("baseImage:");
            sb.append(this.baseImage + ",");
        }
        if (this.maven != null) {
            sb.append("maven:");
            sb.append(this.maven + ",");
        }
        if (this.registry != null) {
            sb.append("registry:");
            sb.append(this.registry + ",");
        }
        if (this.runtimeProvider != null) {
            sb.append("runtimeProvider:");
            sb.append(this.runtimeProvider + ",");
        }
        if (this.runtimeVersion != null) {
            sb.append("runtimeVersion:");
            sb.append(this.runtimeVersion + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MavenNested<N>
    extends MavenFluent<MavenNested<N>>
    implements Nested<N> {
        MavenBuilder builder;

        MavenNested(Maven item) {
            this.builder = new MavenBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withMaven(this.builder.build());
        }

        public N endBuildMaven() {
            return this.and();
        }
    }

    public class RegistryNested<N>
    extends RegistryFluent<RegistryNested<N>>
    implements Nested<N> {
        RegistryBuilder builder;

        RegistryNested(Registry item) {
            this.builder = new RegistryBuilder(this, item);
        }

        public N and() {
            return (N)BuildFluent.this.withRegistry(this.builder.build());
        }

        public N endBuildRegistry() {
            return this.and();
        }
    }
}

