/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationspec.traits.Environment;
import org.apache.camel.v1.integrationspec.traits.environment.Configuration;
import org.apache.camel.v1.integrationspec.traits.environment.ConfigurationBuilder;
import org.apache.camel.v1.integrationspec.traits.environment.ConfigurationFluent;

public class EnvironmentFluent<A extends EnvironmentFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean containerMeta;
    private Boolean enabled;
    private Boolean httpProxy;
    private List<String> vars;

    public EnvironmentFluent() {
    }

    public EnvironmentFluent(Environment instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Environment instance) {
        Environment environment = instance = instance != null ? instance : new Environment();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withContainerMeta(instance.getContainerMeta());
            this.withEnabled(instance.getEnabled());
            this.withHttpProxy(instance.getHttpProxy());
            this.withVars(instance.getVars());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getContainerMeta() {
        return this.containerMeta;
    }

    public A withContainerMeta(Boolean containerMeta) {
        this.containerMeta = containerMeta;
        return (A)((Object)this);
    }

    public boolean hasContainerMeta() {
        return this.containerMeta != null;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public Boolean getHttpProxy() {
        return this.httpProxy;
    }

    public A withHttpProxy(Boolean httpProxy) {
        this.httpProxy = httpProxy;
        return (A)((Object)this);
    }

    public boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    public A addToVars(int index, String item) {
        if (this.vars == null) {
            this.vars = new ArrayList<String>();
        }
        this.vars.add(index, item);
        return (A)((Object)this);
    }

    public A setToVars(int index, String item) {
        if (this.vars == null) {
            this.vars = new ArrayList<String>();
        }
        this.vars.set(index, item);
        return (A)((Object)this);
    }

    public A addToVars(String ... items) {
        if (this.vars == null) {
            this.vars = new ArrayList<String>();
        }
        for (String item : items) {
            this.vars.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToVars(Collection<String> items) {
        if (this.vars == null) {
            this.vars = new ArrayList<String>();
        }
        for (String item : items) {
            this.vars.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromVars(String ... items) {
        if (this.vars == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.vars.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVars(Collection<String> items) {
        if (this.vars == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.vars.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getVars() {
        return this.vars;
    }

    public String getVar(int index) {
        return this.vars.get(index);
    }

    public String getFirstVar() {
        return this.vars.get(0);
    }

    public String getLastVar() {
        return this.vars.get(this.vars.size() - 1);
    }

    public String getMatchingVar(Predicate<String> predicate) {
        for (String item : this.vars) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVar(Predicate<String> predicate) {
        for (String item : this.vars) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVars(List<String> vars) {
        if (vars != null) {
            this.vars = new ArrayList<String>();
            for (String item : vars) {
                this.addToVars(item);
            }
        } else {
            this.vars = null;
        }
        return (A)((Object)this);
    }

    public A withVars(String ... vars) {
        if (this.vars != null) {
            this.vars.clear();
            this._visitables.remove((Object)"vars");
        }
        if (vars != null) {
            for (String item : vars) {
                this.addToVars(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasVars() {
        return this.vars != null && !this.vars.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvironmentFluent that = (EnvironmentFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.containerMeta, that.containerMeta)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.httpProxy, that.httpProxy)) {
            return false;
        }
        return Objects.equals(this.vars, that.vars);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.containerMeta, this.enabled, this.httpProxy, this.vars, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.containerMeta != null) {
            sb.append("containerMeta:");
            sb.append(this.containerMeta + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.httpProxy != null) {
            sb.append("httpProxy:");
            sb.append(this.httpProxy + ",");
        }
        if (this.vars != null && !this.vars.isEmpty()) {
            sb.append("vars:");
            sb.append(this.vars);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withContainerMeta() {
        return this.withContainerMeta(true);
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withHttpProxy() {
        return this.withHttpProxy(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)EnvironmentFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

