package org.apache.camel.v1.camelcatalogspec.runtime;

import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.DependenciesBuilder;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.RuntimePropertiesBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.RuntimePropertiesFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.BuildTimeProperties;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.DependenciesFluent;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.BuildTimePropertiesBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.Dependencies;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.RuntimeProperties;
import org.apache.camel.v1.camelcatalogspec.runtime.capabilities.BuildTimePropertiesFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CapabilitiesFluent<A extends CapabilitiesFluent<A>> extends BaseFluent<A>{
  public CapabilitiesFluent() {
  }
  
  public CapabilitiesFluent(Capabilities instance) {
    this.copyInstance(instance);
  }
  private ArrayList<BuildTimePropertiesBuilder> buildTimeProperties;
  private ArrayList<DependenciesBuilder> dependencies;
  private Map<String,String> metadata;
  private ArrayList<RuntimePropertiesBuilder> runtimeProperties;
  
  protected void copyInstance(Capabilities instance) {
    instance = (instance != null ? instance : new Capabilities());
    if (instance != null) {
          this.withBuildTimeProperties(instance.getBuildTimeProperties());
          this.withDependencies(instance.getDependencies());
          this.withMetadata(instance.getMetadata());
          this.withRuntimeProperties(instance.getRuntimeProperties());
        }
  }
  
  public A addToBuildTimeProperties(int index,BuildTimeProperties item) {
    if (this.buildTimeProperties == null) {this.buildTimeProperties = new ArrayList<BuildTimePropertiesBuilder>();}
    BuildTimePropertiesBuilder builder = new BuildTimePropertiesBuilder(item);
    if (index < 0 || index >= buildTimeProperties.size()) { _visitables.get("buildTimeProperties").add(builder); buildTimeProperties.add(builder); } else { _visitables.get("buildTimeProperties").add(index, builder); buildTimeProperties.add(index, builder);}
    return (A)this;
  }
  
  public A setToBuildTimeProperties(int index,BuildTimeProperties item) {
    if (this.buildTimeProperties == null) {this.buildTimeProperties = new ArrayList<BuildTimePropertiesBuilder>();}
    BuildTimePropertiesBuilder builder = new BuildTimePropertiesBuilder(item);
    if (index < 0 || index >= buildTimeProperties.size()) { _visitables.get("buildTimeProperties").add(builder); buildTimeProperties.add(builder); } else { _visitables.get("buildTimeProperties").set(index, builder); buildTimeProperties.set(index, builder);}
    return (A)this;
  }
  
  public A addToBuildTimeProperties(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.BuildTimeProperties... items) {
    if (this.buildTimeProperties == null) {this.buildTimeProperties = new ArrayList<BuildTimePropertiesBuilder>();}
    for (BuildTimeProperties item : items) {BuildTimePropertiesBuilder builder = new BuildTimePropertiesBuilder(item);_visitables.get("buildTimeProperties").add(builder);this.buildTimeProperties.add(builder);} return (A)this;
  }
  
  public A addAllToCamelcatalogspecBuildTimeProperties(Collection<BuildTimeProperties> items) {
    if (this.buildTimeProperties == null) {this.buildTimeProperties = new ArrayList<BuildTimePropertiesBuilder>();}
    for (BuildTimeProperties item : items) {BuildTimePropertiesBuilder builder = new BuildTimePropertiesBuilder(item);_visitables.get("buildTimeProperties").add(builder);this.buildTimeProperties.add(builder);} return (A)this;
  }
  
  public A removeFromBuildTimeProperties(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.BuildTimeProperties... items) {
    if (this.buildTimeProperties == null) return (A)this;
    for (BuildTimeProperties item : items) {BuildTimePropertiesBuilder builder = new BuildTimePropertiesBuilder(item);_visitables.get("buildTimeProperties").remove(builder); this.buildTimeProperties.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCamelcatalogspecBuildTimeProperties(Collection<BuildTimeProperties> items) {
    if (this.buildTimeProperties == null) return (A)this;
    for (BuildTimeProperties item : items) {BuildTimePropertiesBuilder builder = new BuildTimePropertiesBuilder(item);_visitables.get("buildTimeProperties").remove(builder); this.buildTimeProperties.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCamelcatalogspecBuildTimeProperties(Predicate<BuildTimePropertiesBuilder> predicate) {
    if (buildTimeProperties == null) return (A) this;
    final Iterator<BuildTimePropertiesBuilder> each = buildTimeProperties.iterator();
    final List visitables = _visitables.get("buildTimeProperties");
    while (each.hasNext()) {
      BuildTimePropertiesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<BuildTimeProperties> buildBuildTimeProperties() {
    return this.buildTimeProperties != null ? build(buildTimeProperties) : null;
  }
  
  public BuildTimeProperties buildBuildTimeProperty(int index) {
    return this.buildTimeProperties.get(index).build();
  }
  
  public BuildTimeProperties buildFirstBuildTimeProperty() {
    return this.buildTimeProperties.get(0).build();
  }
  
  public BuildTimeProperties buildLastBuildTimeProperty() {
    return this.buildTimeProperties.get(buildTimeProperties.size() - 1).build();
  }
  
  public BuildTimeProperties buildMatchingBuildTimeProperty(Predicate<BuildTimePropertiesBuilder> predicate) {
      for (BuildTimePropertiesBuilder item : buildTimeProperties) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingBuildTimeProperty(Predicate<BuildTimePropertiesBuilder> predicate) {
      for (BuildTimePropertiesBuilder item : buildTimeProperties) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withBuildTimeProperties(List<BuildTimeProperties> buildTimeProperties) {
    if (this.buildTimeProperties != null) {
      this._visitables.get("buildTimeProperties").clear();
    }
    if (buildTimeProperties != null) {
        this.buildTimeProperties = new ArrayList();
        for (BuildTimeProperties item : buildTimeProperties) {
          this.addToBuildTimeProperties(item);
        }
    } else {
      this.buildTimeProperties = null;
    }
    return (A) this;
  }
  
  public A withBuildTimeProperties(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.BuildTimeProperties... buildTimeProperties) {
    if (this.buildTimeProperties != null) {
        this.buildTimeProperties.clear();
        _visitables.remove("buildTimeProperties");
    }
    if (buildTimeProperties != null) {
      for (BuildTimeProperties item : buildTimeProperties) {
        this.addToBuildTimeProperties(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasBuildTimeProperties() {
    return this.buildTimeProperties != null && !this.buildTimeProperties.isEmpty();
  }
  
  public BuildTimePropertiesNested<A> addNewBuildTimeProperty() {
    return new BuildTimePropertiesNested(-1, null);
  }
  
  public BuildTimePropertiesNested<A> addNewBuildTimePropertyLike(BuildTimeProperties item) {
    return new BuildTimePropertiesNested(-1, item);
  }
  
  public BuildTimePropertiesNested<A> setNewBuildTimePropertyLike(int index,BuildTimeProperties item) {
    return new BuildTimePropertiesNested(index, item);
  }
  
  public BuildTimePropertiesNested<A> editBuildTimeProperty(int index) {
    if (buildTimeProperties.size() <= index) throw new RuntimeException("Can't edit buildTimeProperties. Index exceeds size.");
    return setNewBuildTimePropertyLike(index, buildBuildTimeProperty(index));
  }
  
  public BuildTimePropertiesNested<A> editFirstBuildTimeProperty() {
    if (buildTimeProperties.size() == 0) throw new RuntimeException("Can't edit first buildTimeProperties. The list is empty.");
    return setNewBuildTimePropertyLike(0, buildBuildTimeProperty(0));
  }
  
  public BuildTimePropertiesNested<A> editLastBuildTimeProperty() {
    int index = buildTimeProperties.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last buildTimeProperties. The list is empty.");
    return setNewBuildTimePropertyLike(index, buildBuildTimeProperty(index));
  }
  
  public BuildTimePropertiesNested<A> editMatchingBuildTimeProperty(Predicate<BuildTimePropertiesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<buildTimeProperties.size();i++) { 
    if (predicate.test(buildTimeProperties.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching buildTimeProperties. No match found.");
    return setNewBuildTimePropertyLike(index, buildBuildTimeProperty(index));
  }
  
  public A addToDependencies(int index,Dependencies item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<DependenciesBuilder>();}
    DependenciesBuilder builder = new DependenciesBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").add(index, builder); dependencies.add(index, builder);}
    return (A)this;
  }
  
  public A setToDependencies(int index,Dependencies item) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<DependenciesBuilder>();}
    DependenciesBuilder builder = new DependenciesBuilder(item);
    if (index < 0 || index >= dependencies.size()) { _visitables.get("dependencies").add(builder); dependencies.add(builder); } else { _visitables.get("dependencies").set(index, builder); dependencies.set(index, builder);}
    return (A)this;
  }
  
  public A addToDependencies(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.Dependencies... items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<DependenciesBuilder>();}
    for (Dependencies item : items) {DependenciesBuilder builder = new DependenciesBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  
  public A addAllToCapabilitiesDependencies(Collection<Dependencies> items) {
    if (this.dependencies == null) {this.dependencies = new ArrayList<DependenciesBuilder>();}
    for (Dependencies item : items) {DependenciesBuilder builder = new DependenciesBuilder(item);_visitables.get("dependencies").add(builder);this.dependencies.add(builder);} return (A)this;
  }
  
  public A removeFromDependencies(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.Dependencies... items) {
    if (this.dependencies == null) return (A)this;
    for (Dependencies item : items) {DependenciesBuilder builder = new DependenciesBuilder(item);_visitables.get("dependencies").remove(builder); this.dependencies.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCapabilitiesDependencies(Collection<Dependencies> items) {
    if (this.dependencies == null) return (A)this;
    for (Dependencies item : items) {DependenciesBuilder builder = new DependenciesBuilder(item);_visitables.get("dependencies").remove(builder); this.dependencies.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCapabilitiesDependencies(Predicate<DependenciesBuilder> predicate) {
    if (dependencies == null) return (A) this;
    final Iterator<DependenciesBuilder> each = dependencies.iterator();
    final List visitables = _visitables.get("dependencies");
    while (each.hasNext()) {
      DependenciesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Dependencies> buildDependencies() {
    return this.dependencies != null ? build(dependencies) : null;
  }
  
  public Dependencies buildDependency(int index) {
    return this.dependencies.get(index).build();
  }
  
  public Dependencies buildFirstDependency() {
    return this.dependencies.get(0).build();
  }
  
  public Dependencies buildLastDependency() {
    return this.dependencies.get(dependencies.size() - 1).build();
  }
  
  public Dependencies buildMatchingDependency(Predicate<DependenciesBuilder> predicate) {
      for (DependenciesBuilder item : dependencies) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingDependency(Predicate<DependenciesBuilder> predicate) {
      for (DependenciesBuilder item : dependencies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withDependencies(List<Dependencies> dependencies) {
    if (this.dependencies != null) {
      this._visitables.get("dependencies").clear();
    }
    if (dependencies != null) {
        this.dependencies = new ArrayList();
        for (Dependencies item : dependencies) {
          this.addToDependencies(item);
        }
    } else {
      this.dependencies = null;
    }
    return (A) this;
  }
  
  public A withDependencies(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.Dependencies... dependencies) {
    if (this.dependencies != null) {
        this.dependencies.clear();
        _visitables.remove("dependencies");
    }
    if (dependencies != null) {
      for (Dependencies item : dependencies) {
        this.addToDependencies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasDependencies() {
    return this.dependencies != null && !this.dependencies.isEmpty();
  }
  
  public DependenciesNested<A> addNewDependency() {
    return new DependenciesNested(-1, null);
  }
  
  public DependenciesNested<A> addNewDependencyLike(Dependencies item) {
    return new DependenciesNested(-1, item);
  }
  
  public DependenciesNested<A> setNewDependencyLike(int index,Dependencies item) {
    return new DependenciesNested(index, item);
  }
  
  public DependenciesNested<A> editDependency(int index) {
    if (dependencies.size() <= index) throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  
  public DependenciesNested<A> editFirstDependency() {
    if (dependencies.size() == 0) throw new RuntimeException("Can't edit first dependencies. The list is empty.");
    return setNewDependencyLike(0, buildDependency(0));
  }
  
  public DependenciesNested<A> editLastDependency() {
    int index = dependencies.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last dependencies. The list is empty.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  
  public DependenciesNested<A> editMatchingDependency(Predicate<DependenciesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<dependencies.size();i++) { 
    if (predicate.test(dependencies.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching dependencies. No match found.");
    return setNewDependencyLike(index, buildDependency(index));
  }
  
  public A addToMetadata(String key,String value) {
    if(this.metadata == null && key != null && value != null) { this.metadata = new LinkedHashMap(); }
    if(key != null && value != null) {this.metadata.put(key, value);} return (A)this;
  }
  
  public A addToMetadata(Map<String,String> map) {
    if(this.metadata == null && map != null) { this.metadata = new LinkedHashMap(); }
    if(map != null) { this.metadata.putAll(map);} return (A)this;
  }
  
  public A removeFromMetadata(String key) {
    if(this.metadata == null) { return (A) this; }
    if(key != null && this.metadata != null) {this.metadata.remove(key);} return (A)this;
  }
  
  public A removeFromMetadata(Map<String,String> map) {
    if(this.metadata == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.metadata != null){this.metadata.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getMetadata() {
    return this.metadata;
  }
  
  public <K,V>A withMetadata(Map<String,String> metadata) {
    if (metadata == null) {
      this.metadata = null;
    } else {
      this.metadata = new LinkedHashMap(metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public A addToRuntimeProperties(int index,RuntimeProperties item) {
    if (this.runtimeProperties == null) {this.runtimeProperties = new ArrayList<RuntimePropertiesBuilder>();}
    RuntimePropertiesBuilder builder = new RuntimePropertiesBuilder(item);
    if (index < 0 || index >= runtimeProperties.size()) { _visitables.get("runtimeProperties").add(builder); runtimeProperties.add(builder); } else { _visitables.get("runtimeProperties").add(index, builder); runtimeProperties.add(index, builder);}
    return (A)this;
  }
  
  public A setToRuntimeProperties(int index,RuntimeProperties item) {
    if (this.runtimeProperties == null) {this.runtimeProperties = new ArrayList<RuntimePropertiesBuilder>();}
    RuntimePropertiesBuilder builder = new RuntimePropertiesBuilder(item);
    if (index < 0 || index >= runtimeProperties.size()) { _visitables.get("runtimeProperties").add(builder); runtimeProperties.add(builder); } else { _visitables.get("runtimeProperties").set(index, builder); runtimeProperties.set(index, builder);}
    return (A)this;
  }
  
  public A addToRuntimeProperties(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.RuntimeProperties... items) {
    if (this.runtimeProperties == null) {this.runtimeProperties = new ArrayList<RuntimePropertiesBuilder>();}
    for (RuntimeProperties item : items) {RuntimePropertiesBuilder builder = new RuntimePropertiesBuilder(item);_visitables.get("runtimeProperties").add(builder);this.runtimeProperties.add(builder);} return (A)this;
  }
  
  public A addAllToCamelcatalogspecRuntimeProperties(Collection<RuntimeProperties> items) {
    if (this.runtimeProperties == null) {this.runtimeProperties = new ArrayList<RuntimePropertiesBuilder>();}
    for (RuntimeProperties item : items) {RuntimePropertiesBuilder builder = new RuntimePropertiesBuilder(item);_visitables.get("runtimeProperties").add(builder);this.runtimeProperties.add(builder);} return (A)this;
  }
  
  public A removeFromRuntimeProperties(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.RuntimeProperties... items) {
    if (this.runtimeProperties == null) return (A)this;
    for (RuntimeProperties item : items) {RuntimePropertiesBuilder builder = new RuntimePropertiesBuilder(item);_visitables.get("runtimeProperties").remove(builder); this.runtimeProperties.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCamelcatalogspecRuntimeProperties(Collection<RuntimeProperties> items) {
    if (this.runtimeProperties == null) return (A)this;
    for (RuntimeProperties item : items) {RuntimePropertiesBuilder builder = new RuntimePropertiesBuilder(item);_visitables.get("runtimeProperties").remove(builder); this.runtimeProperties.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCamelcatalogspecRuntimeProperties(Predicate<RuntimePropertiesBuilder> predicate) {
    if (runtimeProperties == null) return (A) this;
    final Iterator<RuntimePropertiesBuilder> each = runtimeProperties.iterator();
    final List visitables = _visitables.get("runtimeProperties");
    while (each.hasNext()) {
      RuntimePropertiesBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<RuntimeProperties> buildRuntimeProperties() {
    return this.runtimeProperties != null ? build(runtimeProperties) : null;
  }
  
  public RuntimeProperties buildRuntimeProperty(int index) {
    return this.runtimeProperties.get(index).build();
  }
  
  public RuntimeProperties buildFirstRuntimeProperty() {
    return this.runtimeProperties.get(0).build();
  }
  
  public RuntimeProperties buildLastRuntimeProperty() {
    return this.runtimeProperties.get(runtimeProperties.size() - 1).build();
  }
  
  public RuntimeProperties buildMatchingRuntimeProperty(Predicate<RuntimePropertiesBuilder> predicate) {
      for (RuntimePropertiesBuilder item : runtimeProperties) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingRuntimeProperty(Predicate<RuntimePropertiesBuilder> predicate) {
      for (RuntimePropertiesBuilder item : runtimeProperties) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withRuntimeProperties(List<RuntimeProperties> runtimeProperties) {
    if (this.runtimeProperties != null) {
      this._visitables.get("runtimeProperties").clear();
    }
    if (runtimeProperties != null) {
        this.runtimeProperties = new ArrayList();
        for (RuntimeProperties item : runtimeProperties) {
          this.addToRuntimeProperties(item);
        }
    } else {
      this.runtimeProperties = null;
    }
    return (A) this;
  }
  
  public A withRuntimeProperties(org.apache.camel.v1.camelcatalogspec.runtime.capabilities.RuntimeProperties... runtimeProperties) {
    if (this.runtimeProperties != null) {
        this.runtimeProperties.clear();
        _visitables.remove("runtimeProperties");
    }
    if (runtimeProperties != null) {
      for (RuntimeProperties item : runtimeProperties) {
        this.addToRuntimeProperties(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasRuntimeProperties() {
    return this.runtimeProperties != null && !this.runtimeProperties.isEmpty();
  }
  
  public RuntimePropertiesNested<A> addNewRuntimeProperty() {
    return new RuntimePropertiesNested(-1, null);
  }
  
  public RuntimePropertiesNested<A> addNewRuntimePropertyLike(RuntimeProperties item) {
    return new RuntimePropertiesNested(-1, item);
  }
  
  public RuntimePropertiesNested<A> setNewRuntimePropertyLike(int index,RuntimeProperties item) {
    return new RuntimePropertiesNested(index, item);
  }
  
  public RuntimePropertiesNested<A> editRuntimeProperty(int index) {
    if (runtimeProperties.size() <= index) throw new RuntimeException("Can't edit runtimeProperties. Index exceeds size.");
    return setNewRuntimePropertyLike(index, buildRuntimeProperty(index));
  }
  
  public RuntimePropertiesNested<A> editFirstRuntimeProperty() {
    if (runtimeProperties.size() == 0) throw new RuntimeException("Can't edit first runtimeProperties. The list is empty.");
    return setNewRuntimePropertyLike(0, buildRuntimeProperty(0));
  }
  
  public RuntimePropertiesNested<A> editLastRuntimeProperty() {
    int index = runtimeProperties.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last runtimeProperties. The list is empty.");
    return setNewRuntimePropertyLike(index, buildRuntimeProperty(index));
  }
  
  public RuntimePropertiesNested<A> editMatchingRuntimeProperty(Predicate<RuntimePropertiesBuilder> predicate) {
    int index = -1;
    for (int i=0;i<runtimeProperties.size();i++) { 
    if (predicate.test(runtimeProperties.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching runtimeProperties. No match found.");
    return setNewRuntimePropertyLike(index, buildRuntimeProperty(index));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CapabilitiesFluent that = (CapabilitiesFluent) o;
    if (!java.util.Objects.equals(buildTimeProperties, that.buildTimeProperties)) return false;
    if (!java.util.Objects.equals(dependencies, that.dependencies)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(runtimeProperties, that.runtimeProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(buildTimeProperties,  dependencies,  metadata,  runtimeProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildTimeProperties != null && !buildTimeProperties.isEmpty()) { sb.append("buildTimeProperties:"); sb.append(buildTimeProperties + ","); }
    if (dependencies != null && !dependencies.isEmpty()) { sb.append("dependencies:"); sb.append(dependencies + ","); }
    if (metadata != null && !metadata.isEmpty()) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (runtimeProperties != null && !runtimeProperties.isEmpty()) { sb.append("runtimeProperties:"); sb.append(runtimeProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BuildTimePropertiesNested<N> extends BuildTimePropertiesFluent<BuildTimePropertiesNested<N>> implements Nested<N>{
    BuildTimePropertiesNested(int index,BuildTimeProperties item) {
      this.index = index;
      this.builder = new BuildTimePropertiesBuilder(this, item);
    }
    BuildTimePropertiesBuilder builder;
    int index;
    
    public N and() {
      return (N) CapabilitiesFluent.this.setToBuildTimeProperties(index,builder.build());
    }
    
    public N endCamelcatalogspecBuildTimeProperty() {
      return and();
    }
    
  
  }
  public class DependenciesNested<N> extends DependenciesFluent<DependenciesNested<N>> implements Nested<N>{
    DependenciesNested(int index,Dependencies item) {
      this.index = index;
      this.builder = new DependenciesBuilder(this, item);
    }
    DependenciesBuilder builder;
    int index;
    
    public N and() {
      return (N) CapabilitiesFluent.this.setToDependencies(index,builder.build());
    }
    
    public N endCapabilitiesDependency() {
      return and();
    }
    
  
  }
  public class RuntimePropertiesNested<N> extends RuntimePropertiesFluent<RuntimePropertiesNested<N>> implements Nested<N>{
    RuntimePropertiesNested(int index,RuntimeProperties item) {
      this.index = index;
      this.builder = new RuntimePropertiesBuilder(this, item);
    }
    RuntimePropertiesBuilder builder;
    int index;
    
    public N and() {
      return (N) CapabilitiesFluent.this.setToRuntimeProperties(index,builder.build());
    }
    
    public N endCamelcatalogspecRuntimeProperty() {
      return and();
    }
    
  
  }

}