package org.apache.camel.v1.buildspec.tasks.package_.runtime.capabilities;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class BuildTimePropertiesBuilder extends BuildTimePropertiesFluent<BuildTimePropertiesBuilder> implements VisitableBuilder<BuildTimeProperties,BuildTimePropertiesBuilder>{
  public BuildTimePropertiesBuilder() {
    this(new BuildTimeProperties());
  }
  
  public BuildTimePropertiesBuilder(BuildTimePropertiesFluent<?> fluent) {
    this(fluent, new BuildTimeProperties());
  }
  
  public BuildTimePropertiesBuilder(BuildTimePropertiesFluent<?> fluent,BuildTimeProperties instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public BuildTimePropertiesBuilder(BuildTimeProperties instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  BuildTimePropertiesFluent<?> fluent;
  
  public BuildTimeProperties build() {
    BuildTimeProperties buildable = new BuildTimeProperties();
    buildable.setKey(fluent.getKey());
    buildable.setValue(fluent.getValue());
    return buildable;
  }
  

}