package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import org.apache.camel.v1.integrationprofilestatus.ConditionsFluent;
import java.lang.String;
import org.apache.camel.v1.integrationprofilestatus.Conditions;
import org.apache.camel.v1.integrationprofilestatus.Traits;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationprofilestatus.TraitsBuilder;
import org.apache.camel.v1.integrationprofilestatus.Build;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import org.apache.camel.v1.integrationprofilestatus.TraitsFluent;
import java.util.List;
import org.apache.camel.v1.integrationprofilestatus.Kamelet;
import org.apache.camel.v1.integrationprofilestatus.BuildFluent;
import org.apache.camel.v1.integrationprofilestatus.BuildBuilder;
import org.apache.camel.v1.integrationprofilestatus.ConditionsBuilder;
import org.apache.camel.v1.integrationprofilestatus.KameletBuilder;
import java.lang.Long;
import java.util.Collection;
import org.apache.camel.v1.integrationprofilestatus.KameletFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IntegrationProfileStatusFluent<A extends IntegrationProfileStatusFluent<A>> extends BaseFluent<A>{
  public IntegrationProfileStatusFluent() {
  }
  
  public IntegrationProfileStatusFluent(IntegrationProfileStatus instance) {
    this.copyInstance(instance);
  }
  private BuildBuilder build;
  private ArrayList<ConditionsBuilder> conditions;
  private KameletBuilder kamelet;
  private Long observedGeneration;
  private String phase;
  private TraitsBuilder traits;
  
  protected void copyInstance(IntegrationProfileStatus instance) {
    instance = (instance != null ? instance : new IntegrationProfileStatus());
    if (instance != null) {
          this.withBuild(instance.getBuild());
          this.withConditions(instance.getConditions());
          this.withKamelet(instance.getKamelet());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withPhase(instance.getPhase());
          this.withTraits(instance.getTraits());
        }
  }
  
  public Build buildBuild() {
    return this.build != null ? this.build.build() : null;
  }
  
  public A withBuild(Build build) {
    this._visitables.remove("build");
    if (build != null) {
        this.build = new BuildBuilder(build);
        this._visitables.get("build").add(this.build);
    } else {
        this.build = null;
        this._visitables.get("build").remove(this.build);
    }
    return (A) this;
  }
  
  public boolean hasBuild() {
    return this.build != null;
  }
  
  public BuildNested<A> withNewBuild() {
    return new BuildNested(null);
  }
  
  public BuildNested<A> withNewBuildLike(Build item) {
    return new BuildNested(item);
  }
  
  public BuildNested<A> editIntegrationprofilestatusBuild() {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(null));
  }
  
  public BuildNested<A> editOrNewBuild() {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(new BuildBuilder().build()));
  }
  
  public BuildNested<A> editOrNewBuildLike(Build item) {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(item));
  }
  
  public A addToConditions(int index,Conditions item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    ConditionsBuilder builder = new ConditionsBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,Conditions item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    ConditionsBuilder builder = new ConditionsBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(org.apache.camel.v1.integrationprofilestatus.Conditions... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToIntegrationprofilestatusConditions(Collection<Conditions> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionsBuilder>();}
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(org.apache.camel.v1.integrationprofilestatus.Conditions... items) {
    if (this.conditions == null) return (A)this;
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIntegrationprofilestatusConditions(Collection<Conditions> items) {
    if (this.conditions == null) return (A)this;
    for (Conditions item : items) {ConditionsBuilder builder = new ConditionsBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIntegrationprofilestatusConditions(Predicate<ConditionsBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionsBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Conditions> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public Conditions buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public Conditions buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public Conditions buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public Conditions buildMatchingCondition(Predicate<ConditionsBuilder> predicate) {
      for (ConditionsBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ConditionsBuilder> predicate) {
      for (ConditionsBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Conditions> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Conditions item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(org.apache.camel.v1.integrationprofilestatus.Conditions... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Conditions item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(Conditions item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,Conditions item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public Kamelet buildKamelet() {
    return this.kamelet != null ? this.kamelet.build() : null;
  }
  
  public A withKamelet(Kamelet kamelet) {
    this._visitables.remove("kamelet");
    if (kamelet != null) {
        this.kamelet = new KameletBuilder(kamelet);
        this._visitables.get("kamelet").add(this.kamelet);
    } else {
        this.kamelet = null;
        this._visitables.get("kamelet").remove(this.kamelet);
    }
    return (A) this;
  }
  
  public boolean hasKamelet() {
    return this.kamelet != null;
  }
  
  public KameletNested<A> withNewKamelet() {
    return new KameletNested(null);
  }
  
  public KameletNested<A> withNewKameletLike(Kamelet item) {
    return new KameletNested(item);
  }
  
  public KameletNested<A> editIntegrationprofilestatusKamelet() {
    return withNewKameletLike(java.util.Optional.ofNullable(buildKamelet()).orElse(null));
  }
  
  public KameletNested<A> editOrNewKamelet() {
    return withNewKameletLike(java.util.Optional.ofNullable(buildKamelet()).orElse(new KameletBuilder().build()));
  }
  
  public KameletNested<A> editOrNewKameletLike(Kamelet item) {
    return withNewKameletLike(java.util.Optional.ofNullable(buildKamelet()).orElse(item));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public Traits buildTraits() {
    return this.traits != null ? this.traits.build() : null;
  }
  
  public A withTraits(Traits traits) {
    this._visitables.remove("traits");
    if (traits != null) {
        this.traits = new TraitsBuilder(traits);
        this._visitables.get("traits").add(this.traits);
    } else {
        this.traits = null;
        this._visitables.get("traits").remove(this.traits);
    }
    return (A) this;
  }
  
  public boolean hasTraits() {
    return this.traits != null;
  }
  
  public TraitsNested<A> withNewTraits() {
    return new TraitsNested(null);
  }
  
  public TraitsNested<A> withNewTraitsLike(Traits item) {
    return new TraitsNested(item);
  }
  
  public TraitsNested<A> editIntegrationprofilestatusTraits() {
    return withNewTraitsLike(java.util.Optional.ofNullable(buildTraits()).orElse(null));
  }
  
  public TraitsNested<A> editOrNewTraits() {
    return withNewTraitsLike(java.util.Optional.ofNullable(buildTraits()).orElse(new TraitsBuilder().build()));
  }
  
  public TraitsNested<A> editOrNewTraitsLike(Traits item) {
    return withNewTraitsLike(java.util.Optional.ofNullable(buildTraits()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IntegrationProfileStatusFluent that = (IntegrationProfileStatusFluent) o;
    if (!java.util.Objects.equals(build, that.build)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(kamelet, that.kamelet)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(traits, that.traits)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(build,  conditions,  kamelet,  observedGeneration,  phase,  traits,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (build != null) { sb.append("build:"); sb.append(build + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (kamelet != null) { sb.append("kamelet:"); sb.append(kamelet + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (traits != null) { sb.append("traits:"); sb.append(traits); }
    sb.append("}");
    return sb.toString();
  }
  public class BuildNested<N> extends BuildFluent<BuildNested<N>> implements Nested<N>{
    BuildNested(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildBuilder builder;
    
    public N and() {
      return (N) IntegrationProfileStatusFluent.this.withBuild(builder.build());
    }
    
    public N endIntegrationprofilestatusBuild() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends ConditionsFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Conditions item) {
      this.index = index;
      this.builder = new ConditionsBuilder(this, item);
    }
    ConditionsBuilder builder;
    int index;
    
    public N and() {
      return (N) IntegrationProfileStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endIntegrationprofilestatusCondition() {
      return and();
    }
    
  
  }
  public class KameletNested<N> extends KameletFluent<KameletNested<N>> implements Nested<N>{
    KameletNested(Kamelet item) {
      this.builder = new KameletBuilder(this, item);
    }
    KameletBuilder builder;
    
    public N and() {
      return (N) IntegrationProfileStatusFluent.this.withKamelet(builder.build());
    }
    
    public N endIntegrationprofilestatusKamelet() {
      return and();
    }
    
  
  }
  public class TraitsNested<N> extends TraitsFluent<TraitsNested<N>> implements Nested<N>{
    TraitsNested(Traits item) {
      this.builder = new TraitsBuilder(this, item);
    }
    TraitsBuilder builder;
    
    public N and() {
      return (N) IntegrationProfileStatusFluent.this.withTraits(builder.build());
    }
    
    public N endIntegrationprofilestatusTraits() {
      return and();
    }
    
  
  }

}