package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IntegrationProfileStatusBuilder extends IntegrationProfileStatusFluent<IntegrationProfileStatusBuilder> implements VisitableBuilder<IntegrationProfileStatus,IntegrationProfileStatusBuilder>{
  public IntegrationProfileStatusBuilder() {
    this(new IntegrationProfileStatus());
  }
  
  public IntegrationProfileStatusBuilder(IntegrationProfileStatusFluent<?> fluent) {
    this(fluent, new IntegrationProfileStatus());
  }
  
  public IntegrationProfileStatusBuilder(IntegrationProfileStatusFluent<?> fluent,IntegrationProfileStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IntegrationProfileStatusBuilder(IntegrationProfileStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IntegrationProfileStatusFluent<?> fluent;
  
  public IntegrationProfileStatus build() {
    IntegrationProfileStatus buildable = new IntegrationProfileStatus();
    buildable.setBuild(fluent.buildBuild());
    buildable.setConditions(fluent.buildConditions());
    buildable.setKamelet(fluent.buildKamelet());
    buildable.setObservedGeneration(fluent.getObservedGeneration());
    buildable.setPhase(fluent.getPhase());
    buildable.setTraits(fluent.buildTraits());
    return buildable;
  }
  

}