package org.apache.camel.v1;

import org.apache.camel.v1.integrationprofilespec.Kamelet;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import org.apache.camel.v1.integrationprofilespec.BuildFluent;
import java.lang.String;
import org.apache.camel.v1.integrationprofilespec.Traits;
import org.apache.camel.v1.integrationprofilespec.BuildBuilder;
import org.apache.camel.v1.integrationprofilespec.TraitsBuilder;
import org.apache.camel.v1.integrationprofilespec.KameletBuilder;
import org.apache.camel.v1.integrationprofilespec.Build;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import org.apache.camel.v1.integrationprofilespec.KameletFluent;
import org.apache.camel.v1.integrationprofilespec.TraitsFluent;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IntegrationProfileSpecFluent<A extends IntegrationProfileSpecFluent<A>> extends BaseFluent<A>{
  public IntegrationProfileSpecFluent() {
  }
  
  public IntegrationProfileSpecFluent(IntegrationProfileSpec instance) {
    this.copyInstance(instance);
  }
  private BuildBuilder build;
  private KameletBuilder kamelet;
  private TraitsBuilder traits;
  
  protected void copyInstance(IntegrationProfileSpec instance) {
    instance = (instance != null ? instance : new IntegrationProfileSpec());
    if (instance != null) {
          this.withBuild(instance.getBuild());
          this.withKamelet(instance.getKamelet());
          this.withTraits(instance.getTraits());
        }
  }
  
  public Build buildBuild() {
    return this.build != null ? this.build.build() : null;
  }
  
  public A withBuild(Build build) {
    this._visitables.remove("build");
    if (build != null) {
        this.build = new BuildBuilder(build);
        this._visitables.get("build").add(this.build);
    } else {
        this.build = null;
        this._visitables.get("build").remove(this.build);
    }
    return (A) this;
  }
  
  public boolean hasBuild() {
    return this.build != null;
  }
  
  public BuildNested<A> withNewBuild() {
    return new BuildNested(null);
  }
  
  public BuildNested<A> withNewBuildLike(Build item) {
    return new BuildNested(item);
  }
  
  public BuildNested<A> editIntegrationprofilespecBuild() {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(null));
  }
  
  public BuildNested<A> editOrNewBuild() {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(new BuildBuilder().build()));
  }
  
  public BuildNested<A> editOrNewBuildLike(Build item) {
    return withNewBuildLike(java.util.Optional.ofNullable(buildBuild()).orElse(item));
  }
  
  public Kamelet buildKamelet() {
    return this.kamelet != null ? this.kamelet.build() : null;
  }
  
  public A withKamelet(Kamelet kamelet) {
    this._visitables.remove("kamelet");
    if (kamelet != null) {
        this.kamelet = new KameletBuilder(kamelet);
        this._visitables.get("kamelet").add(this.kamelet);
    } else {
        this.kamelet = null;
        this._visitables.get("kamelet").remove(this.kamelet);
    }
    return (A) this;
  }
  
  public boolean hasKamelet() {
    return this.kamelet != null;
  }
  
  public KameletNested<A> withNewKamelet() {
    return new KameletNested(null);
  }
  
  public KameletNested<A> withNewKameletLike(Kamelet item) {
    return new KameletNested(item);
  }
  
  public KameletNested<A> editIntegrationprofilespecKamelet() {
    return withNewKameletLike(java.util.Optional.ofNullable(buildKamelet()).orElse(null));
  }
  
  public KameletNested<A> editOrNewKamelet() {
    return withNewKameletLike(java.util.Optional.ofNullable(buildKamelet()).orElse(new KameletBuilder().build()));
  }
  
  public KameletNested<A> editOrNewKameletLike(Kamelet item) {
    return withNewKameletLike(java.util.Optional.ofNullable(buildKamelet()).orElse(item));
  }
  
  public Traits buildTraits() {
    return this.traits != null ? this.traits.build() : null;
  }
  
  public A withTraits(Traits traits) {
    this._visitables.remove("traits");
    if (traits != null) {
        this.traits = new TraitsBuilder(traits);
        this._visitables.get("traits").add(this.traits);
    } else {
        this.traits = null;
        this._visitables.get("traits").remove(this.traits);
    }
    return (A) this;
  }
  
  public boolean hasTraits() {
    return this.traits != null;
  }
  
  public TraitsNested<A> withNewTraits() {
    return new TraitsNested(null);
  }
  
  public TraitsNested<A> withNewTraitsLike(Traits item) {
    return new TraitsNested(item);
  }
  
  public TraitsNested<A> editIntegrationprofilespecTraits() {
    return withNewTraitsLike(java.util.Optional.ofNullable(buildTraits()).orElse(null));
  }
  
  public TraitsNested<A> editOrNewTraits() {
    return withNewTraitsLike(java.util.Optional.ofNullable(buildTraits()).orElse(new TraitsBuilder().build()));
  }
  
  public TraitsNested<A> editOrNewTraitsLike(Traits item) {
    return withNewTraitsLike(java.util.Optional.ofNullable(buildTraits()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IntegrationProfileSpecFluent that = (IntegrationProfileSpecFluent) o;
    if (!java.util.Objects.equals(build, that.build)) return false;
    if (!java.util.Objects.equals(kamelet, that.kamelet)) return false;
    if (!java.util.Objects.equals(traits, that.traits)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(build,  kamelet,  traits,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (build != null) { sb.append("build:"); sb.append(build + ","); }
    if (kamelet != null) { sb.append("kamelet:"); sb.append(kamelet + ","); }
    if (traits != null) { sb.append("traits:"); sb.append(traits); }
    sb.append("}");
    return sb.toString();
  }
  public class BuildNested<N> extends BuildFluent<BuildNested<N>> implements Nested<N>{
    BuildNested(Build item) {
      this.builder = new BuildBuilder(this, item);
    }
    BuildBuilder builder;
    
    public N and() {
      return (N) IntegrationProfileSpecFluent.this.withBuild(builder.build());
    }
    
    public N endIntegrationprofilespecBuild() {
      return and();
    }
    
  
  }
  public class KameletNested<N> extends KameletFluent<KameletNested<N>> implements Nested<N>{
    KameletNested(Kamelet item) {
      this.builder = new KameletBuilder(this, item);
    }
    KameletBuilder builder;
    
    public N and() {
      return (N) IntegrationProfileSpecFluent.this.withKamelet(builder.build());
    }
    
    public N endIntegrationprofilespecKamelet() {
      return and();
    }
    
  
  }
  public class TraitsNested<N> extends TraitsFluent<TraitsNested<N>> implements Nested<N>{
    TraitsNested(Traits item) {
      this.builder = new TraitsBuilder(this, item);
    }
    TraitsBuilder builder;
    
    public N and() {
      return (N) IntegrationProfileSpecFluent.this.withTraits(builder.build());
    }
    
    public N endIntegrationprofilespecTraits() {
      return and();
    }
    
  
  }

}