package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IntegrationProfileSpecBuilder extends IntegrationProfileSpecFluent<IntegrationProfileSpecBuilder> implements VisitableBuilder<IntegrationProfileSpec,IntegrationProfileSpecBuilder>{
  public IntegrationProfileSpecBuilder() {
    this(new IntegrationProfileSpec());
  }
  
  public IntegrationProfileSpecBuilder(IntegrationProfileSpecFluent<?> fluent) {
    this(fluent, new IntegrationProfileSpec());
  }
  
  public IntegrationProfileSpecBuilder(IntegrationProfileSpecFluent<?> fluent,IntegrationProfileSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IntegrationProfileSpecBuilder(IntegrationProfileSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IntegrationProfileSpecFluent<?> fluent;
  
  public IntegrationProfileSpec build() {
    IntegrationProfileSpec buildable = new IntegrationProfileSpec();
    buildable.setBuild(fluent.buildBuild());
    buildable.setKamelet(fluent.buildKamelet());
    buildable.setTraits(fluent.buildTraits());
    return buildable;
  }
  

}