/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.pipespec.integration.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.pipespec.integration.traits.deployer.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "enabled", "kind", "useSSA"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Deployer
implements KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="kind")
    @JsonPropertyDescription(value="Allows to explicitly select the desired deployment kind between `deployment`, `cron-job` or `knative-service` when creating the resources for running the integration.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Kind kind;
    @JsonProperty(value="useSSA")
    @JsonPropertyDescription(value="Use server-side apply to update the owned resources (default `true`). Note that it automatically falls back to client-side patching, if SSA is not available, e.g., on old Kubernetes clusters.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean useSSA = true;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind kind) {
        this.kind = kind;
    }

    public Boolean getUseSSA() {
        return this.useSSA;
    }

    public void setUseSSA(Boolean useSSA) {
        this.useSSA = useSSA;
    }

    public String toString() {
        return "Deployer(configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", kind=" + this.getKind() + ", useSSA=" + this.getUseSSA() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Deployer)) {
            return false;
        }
        Deployer other = (Deployer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$useSSA = this.getUseSSA();
        Boolean other$useSSA = other.getUseSSA();
        if (this$useSSA == null ? other$useSSA != null : !((Object)this$useSSA).equals(other$useSSA)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        Kind this$kind = this.getKind();
        Kind other$kind = other.getKind();
        return !(this$kind == null ? other$kind != null : !((Object)((Object)this$kind)).equals((Object)other$kind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Deployer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $useSSA = this.getUseSSA();
        result = result * 59 + ($useSSA == null ? 43 : ((Object)$useSSA).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        Kind $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : ((Object)((Object)$kind)).hashCode());
        return result;
    }

    public static enum Kind {
        DEPLOYMENT("deployment"),
        CRONJOB("cron-job"),
        KNATIVESERVICE("knative-service");

        String value;

        private Kind(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

