/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.List;
import org.apache.camel.v1.integrationspec.traits.environment.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"configuration", "containerMeta", "enabled", "httpProxy", "vars"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Environment
implements KubernetesResource {
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="containerMeta")
    @JsonPropertyDescription(value="Enables injection of `NAMESPACE` and `POD_NAME` environment variables (default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean containerMeta = true;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Deprecated: no longer in use.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="httpProxy")
    @JsonPropertyDescription(value="Propagates the `HTTP_PROXY`, `HTTPS_PROXY` and `NO_PROXY` environment variables (default `true`)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean httpProxy = true;
    @JsonProperty(value="vars")
    @JsonPropertyDescription(value="A list of environment variables to be added to the integration container. The syntax is KEY=VALUE, e.g., `MY_VAR=\"my value\"`. These take precedence over the previously defined environment variables.")
    @JsonSetter(nulls=Nulls.SKIP)
    private List<String> vars;

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getContainerMeta() {
        return this.containerMeta;
    }

    public void setContainerMeta(Boolean containerMeta) {
        this.containerMeta = containerMeta;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getHttpProxy() {
        return this.httpProxy;
    }

    public void setHttpProxy(Boolean httpProxy) {
        this.httpProxy = httpProxy;
    }

    public List<String> getVars() {
        return this.vars;
    }

    public void setVars(List<String> vars) {
        this.vars = vars;
    }

    public String toString() {
        return "Environment(configuration=" + this.getConfiguration() + ", containerMeta=" + this.getContainerMeta() + ", enabled=" + this.getEnabled() + ", httpProxy=" + this.getHttpProxy() + ", vars=" + this.getVars() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$containerMeta = this.getContainerMeta();
        Boolean other$containerMeta = other.getContainerMeta();
        if (this$containerMeta == null ? other$containerMeta != null : !((Object)this$containerMeta).equals(other$containerMeta)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$httpProxy = this.getHttpProxy();
        Boolean other$httpProxy = other.getHttpProxy();
        if (this$httpProxy == null ? other$httpProxy != null : !((Object)this$httpProxy).equals(other$httpProxy)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        List<String> this$vars = this.getVars();
        List<String> other$vars = other.getVars();
        return !(this$vars == null ? other$vars != null : !((Object)this$vars).equals(other$vars));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $containerMeta = this.getContainerMeta();
        result = result * 59 + ($containerMeta == null ? 43 : ((Object)$containerMeta).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $httpProxy = this.getHttpProxy();
        result = result * 59 + ($httpProxy == null ? 43 : ((Object)$httpProxy).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        List<String> $vars = this.getVars();
        result = result * 59 + ($vars == null ? 43 : ((Object)$vars).hashCode());
        return result;
    }
}

