/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import org.apache.camel.v1.integrationplatformspec.traits.istio.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"allow", "configuration", "enabled", "inject"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Istio
implements KubernetesResource {
    @JsonProperty(value="allow")
    @JsonPropertyDescription(value="Configures a (comma-separated) list of CIDR subnets that should not be intercepted by the Istio proxy (`10.0.0.0/8,172.16.0.0/12,192.168.0.0/16` by default).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String allow = "10.0.0.0/8,172.16.0.0/12,192.168.0.0/16";
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="inject")
    @JsonPropertyDescription(value="Forces the value for labels `sidecar.istio.io/inject`. By default the label is set to `true` on deployment and not set on Knative Service.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean inject;

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getInject() {
        return this.inject;
    }

    public void setInject(Boolean inject) {
        this.inject = inject;
    }

    public String toString() {
        return "Istio(allow=" + this.getAllow() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", inject=" + this.getInject() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Istio)) {
            return false;
        }
        Istio other = (Istio)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$inject = this.getInject();
        Boolean other$inject = other.getInject();
        if (this$inject == null ? other$inject != null : !((Object)this$inject).equals(other$inject)) {
            return false;
        }
        String this$allow = this.getAllow();
        String other$allow = other.getAllow();
        if (this$allow == null ? other$allow != null : !this$allow.equals(other$allow)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Istio;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $inject = this.getInject();
        result = result * 59 + ($inject == null ? 43 : ((Object)$inject).hashCode());
        String $allow = this.getAllow();
        result = result * 59 + ($allow == null ? 43 : $allow.hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

