/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.util.Map;
import org.apache.camel.v1.integrationplatformspec.traits.ingress.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "auto", "configuration", "enabled", "host", "path", "pathType"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class Ingress
implements KubernetesResource {
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="The annotations added to the ingress. This can be used to set controller specific annotations, e.g., when using the NGINX Ingress controller: See https://github.com/kubernetes/ingress-nginx/blob/main/docs/user-guide/nginx-configuration/annotations.md")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="To automatically add an ingress whenever the integration uses an HTTP endpoint consumer.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters. Deprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="host")
    @JsonPropertyDescription(value="To configure the host exposed by the ingress.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String host;
    @JsonProperty(value="path")
    @JsonPropertyDescription(value="To configure the path exposed by the ingress (default `/`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private String path = "/";
    @JsonProperty(value="pathType")
    @JsonPropertyDescription(value="To configure the path type exposed by the ingress. One of `Exact`, `Prefix`, `ImplementationSpecific` (default to `Prefix`).")
    @JsonSetter(nulls=Nulls.SKIP)
    private PathType pathType = (PathType)((Object)Serialization.unmarshal((String)"\"Prefix\"", PathType.class));

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public PathType getPathType() {
        return this.pathType;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public String toString() {
        return "Ingress(annotations=" + this.getAnnotations() + ", auto=" + this.getAuto() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", pathType=" + this.getPathType() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Ingress)) {
            return false;
        }
        Ingress other = (Ingress)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$auto = this.getAuto();
        Boolean other$auto = other.getAuto();
        if (this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        PathType this$pathType = this.getPathType();
        PathType other$pathType = other.getPathType();
        return !(this$pathType == null ? other$pathType != null : !((Object)((Object)this$pathType)).equals((Object)other$pathType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Ingress;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $auto = this.getAuto();
        result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        PathType $pathType = this.getPathType();
        result = result * 59 + ($pathType == null ? 43 : ((Object)((Object)$pathType)).hashCode());
        return result;
    }

    public static enum PathType {
        EXACT("Exact"),
        PREFIX("Prefix"),
        IMPLEMENTATIONSPECIFIC("ImplementationSpecific");

        String value;

        private PathType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

