/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.camelcatalogspec;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.camel.v1.camelcatalogspec.Loaders;
import org.apache.camel.v1.camelcatalogspec.loaders.Dependencies;
import org.apache.camel.v1.camelcatalogspec.loaders.DependenciesBuilder;
import org.apache.camel.v1.camelcatalogspec.loaders.DependenciesFluent;

public class LoadersFluent<A extends LoadersFluent<A>>
extends BaseFluent<A> {
    private String artifactId;
    private ArrayList<DependenciesBuilder> dependencies;
    private String groupId;
    private List<String> languages;
    private Map<String, String> metadata;
    private String version;

    public LoadersFluent() {
    }

    public LoadersFluent(Loaders instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Loaders instance) {
        Loaders loaders = instance = instance != null ? instance : new Loaders();
        if (instance != null) {
            this.withArtifactId(instance.getArtifactId());
            this.withDependencies(instance.getDependencies());
            this.withGroupId(instance.getGroupId());
            this.withLanguages(instance.getLanguages());
            this.withMetadata(instance.getMetadata());
            this.withVersion(instance.getVersion());
        }
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public A withArtifactId(String artifactId) {
        this.artifactId = artifactId;
        return (A)((Object)this);
    }

    public boolean hasArtifactId() {
        return this.artifactId != null;
    }

    public A addToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").add(index, builder);
            this.dependencies.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDependencies(int index, Dependencies item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        DependenciesBuilder builder = new DependenciesBuilder(item);
        if (index < 0 || index >= this.dependencies.size()) {
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        } else {
            this._visitables.get((Object)"dependencies").set(index, builder);
            this.dependencies.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToLoadersDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList();
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").add(builder);
            this.dependencies.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(Dependencies ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLoadersDependencies(Collection<Dependencies> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (Dependencies item : items) {
            DependenciesBuilder builder = new DependenciesBuilder(item);
            this._visitables.get((Object)"dependencies").remove((Object)builder);
            this.dependencies.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromLoadersDependencies(Predicate<DependenciesBuilder> predicate) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        Iterator<DependenciesBuilder> each = this.dependencies.iterator();
        List visitables = this._visitables.get((Object)"dependencies");
        while (each.hasNext()) {
            DependenciesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Dependencies> buildDependencies() {
        return this.dependencies != null ? LoadersFluent.build(this.dependencies) : null;
    }

    public Dependencies buildDependency(int index) {
        return this.dependencies.get(index).build();
    }

    public Dependencies buildFirstDependency() {
        return this.dependencies.get(0).build();
    }

    public Dependencies buildLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1).build();
    }

    public Dependencies buildMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        for (DependenciesBuilder item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<Dependencies> dependencies) {
        if (this.dependencies != null) {
            this._visitables.get((Object)"dependencies").clear();
        }
        if (dependencies != null) {
            this.dependencies = new ArrayList();
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(Dependencies ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (Dependencies item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public DependenciesNested<A> addNewDependency() {
        return new DependenciesNested(-1, null);
    }

    public DependenciesNested<A> addNewDependencyLike(Dependencies item) {
        return new DependenciesNested(-1, item);
    }

    public DependenciesNested<A> setNewDependencyLike(int index, Dependencies item) {
        return new DependenciesNested(index, item);
    }

    public DependenciesNested<A> editDependency(int index) {
        if (this.dependencies.size() <= index) {
            throw new RuntimeException("Can't edit dependencies. Index exceeds size.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editFirstDependency() {
        if (this.dependencies.size() == 0) {
            throw new RuntimeException("Can't edit first dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(0, this.buildDependency(0));
    }

    public DependenciesNested<A> editLastDependency() {
        int index = this.dependencies.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last dependencies. The list is empty.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public DependenciesNested<A> editMatchingDependency(Predicate<DependenciesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.dependencies.size(); ++i) {
            if (!predicate.test(this.dependencies.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching dependencies. No match found.");
        }
        return this.setNewDependencyLike(index, this.buildDependency(index));
    }

    public String getGroupId() {
        return this.groupId;
    }

    public A withGroupId(String groupId) {
        this.groupId = groupId;
        return (A)((Object)this);
    }

    public boolean hasGroupId() {
        return this.groupId != null;
    }

    public A addToLanguages(int index, String item) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.add(index, item);
        return (A)((Object)this);
    }

    public A setToLanguages(int index, String item) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        this.languages.set(index, item);
        return (A)((Object)this);
    }

    public A addToLanguages(String ... items) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        for (String item : items) {
            this.languages.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToLanguages(Collection<String> items) {
        if (this.languages == null) {
            this.languages = new ArrayList<String>();
        }
        for (String item : items) {
            this.languages.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromLanguages(String ... items) {
        if (this.languages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.languages.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromLanguages(Collection<String> items) {
        if (this.languages == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.languages.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public String getLanguage(int index) {
        return this.languages.get(index);
    }

    public String getFirstLanguage() {
        return this.languages.get(0);
    }

    public String getLastLanguage() {
        return this.languages.get(this.languages.size() - 1);
    }

    public String getMatchingLanguage(Predicate<String> predicate) {
        for (String item : this.languages) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingLanguage(Predicate<String> predicate) {
        for (String item : this.languages) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withLanguages(List<String> languages) {
        if (languages != null) {
            this.languages = new ArrayList<String>();
            for (String item : languages) {
                this.addToLanguages(item);
            }
        } else {
            this.languages = null;
        }
        return (A)((Object)this);
    }

    public A withLanguages(String ... languages) {
        if (this.languages != null) {
            this.languages.clear();
            this._visitables.remove((Object)"languages");
        }
        if (languages != null) {
            for (String item : languages) {
                this.addToLanguages(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasLanguages() {
        return this.languages != null && !this.languages.isEmpty();
    }

    public A addToMetadata(String key, String value) {
        if (this.metadata == null && key != null && value != null) {
            this.metadata = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.metadata.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMetadata(Map<String, String> map) {
        if (this.metadata == null && map != null) {
            this.metadata = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.metadata.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromMetadata(String key) {
        if (this.metadata == null) {
            return (A)((Object)this);
        }
        if (key != null && this.metadata != null) {
            this.metadata.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromMetadata(Map<String, String> map) {
        if (this.metadata == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.metadata == null) continue;
                this.metadata.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public <K, V> A withMetadata(Map<String, String> metadata) {
        this.metadata = metadata == null ? null : new LinkedHashMap<String, String>(metadata);
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)((Object)this);
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoadersFluent that = (LoadersFluent)((Object)o);
        if (!Objects.equals(this.artifactId, that.artifactId)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.groupId, that.groupId)) {
            return false;
        }
        if (!Objects.equals(this.languages, that.languages)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.dependencies, this.groupId, this.languages, this.metadata, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.artifactId != null) {
            sb.append("artifactId:");
            sb.append(this.artifactId + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.groupId != null) {
            sb.append("groupId:");
            sb.append(this.groupId + ",");
        }
        if (this.languages != null && !this.languages.isEmpty()) {
            sb.append("languages:");
            sb.append(this.languages + ",");
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DependenciesNested<N>
    extends DependenciesFluent<DependenciesNested<N>>
    implements Nested<N> {
        DependenciesBuilder builder;
        int index;

        DependenciesNested(int index, Dependencies item) {
            this.index = index;
            this.builder = new DependenciesBuilder(this, item);
        }

        public N and() {
            return (N)LoadersFluent.this.setToDependencies(this.index, this.builder.build());
        }

        public N endLoadersDependency() {
            return this.and();
        }
    }
}

