/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks.buildah;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.v1.buildspec.tasks.buildah.Configuration;

public class ConfigurationFluent<A extends ConfigurationFluent<A>>
extends BaseFluent<A> {
    private String limitCPU;
    private String limitMemory;
    private Map<String, String> nodeSelector;
    private String operatorNamespace;
    private Configuration.OrderStrategy orderStrategy;
    private String requestCPU;
    private String requestMemory;
    private Configuration.Strategy strategy;
    private String toolImage;

    public ConfigurationFluent() {
    }

    public ConfigurationFluent(Configuration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Configuration instance) {
        Configuration configuration = instance = instance != null ? instance : new Configuration();
        if (instance != null) {
            this.withLimitCPU(instance.getLimitCPU());
            this.withLimitMemory(instance.getLimitMemory());
            this.withNodeSelector(instance.getNodeSelector());
            this.withOperatorNamespace(instance.getOperatorNamespace());
            this.withOrderStrategy(instance.getOrderStrategy());
            this.withRequestCPU(instance.getRequestCPU());
            this.withRequestMemory(instance.getRequestMemory());
            this.withStrategy(instance.getStrategy());
            this.withToolImage(instance.getToolImage());
        }
    }

    public String getLimitCPU() {
        return this.limitCPU;
    }

    public A withLimitCPU(String limitCPU) {
        this.limitCPU = limitCPU;
        return (A)((Object)this);
    }

    public boolean hasLimitCPU() {
        return this.limitCPU != null;
    }

    public String getLimitMemory() {
        return this.limitMemory;
    }

    public A withLimitMemory(String limitMemory) {
        this.limitMemory = limitMemory;
        return (A)((Object)this);
    }

    public boolean hasLimitMemory() {
        return this.limitMemory != null;
    }

    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)((Object)this);
    }

    public boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public String getOperatorNamespace() {
        return this.operatorNamespace;
    }

    public A withOperatorNamespace(String operatorNamespace) {
        this.operatorNamespace = operatorNamespace;
        return (A)((Object)this);
    }

    public boolean hasOperatorNamespace() {
        return this.operatorNamespace != null;
    }

    public Configuration.OrderStrategy getOrderStrategy() {
        return this.orderStrategy;
    }

    public A withOrderStrategy(Configuration.OrderStrategy orderStrategy) {
        this.orderStrategy = orderStrategy;
        return (A)((Object)this);
    }

    public boolean hasOrderStrategy() {
        return this.orderStrategy != null;
    }

    public String getRequestCPU() {
        return this.requestCPU;
    }

    public A withRequestCPU(String requestCPU) {
        this.requestCPU = requestCPU;
        return (A)((Object)this);
    }

    public boolean hasRequestCPU() {
        return this.requestCPU != null;
    }

    public String getRequestMemory() {
        return this.requestMemory;
    }

    public A withRequestMemory(String requestMemory) {
        this.requestMemory = requestMemory;
        return (A)((Object)this);
    }

    public boolean hasRequestMemory() {
        return this.requestMemory != null;
    }

    public Configuration.Strategy getStrategy() {
        return this.strategy;
    }

    public A withStrategy(Configuration.Strategy strategy) {
        this.strategy = strategy;
        return (A)((Object)this);
    }

    public boolean hasStrategy() {
        return this.strategy != null;
    }

    public String getToolImage() {
        return this.toolImage;
    }

    public A withToolImage(String toolImage) {
        this.toolImage = toolImage;
        return (A)((Object)this);
    }

    public boolean hasToolImage() {
        return this.toolImage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurationFluent that = (ConfigurationFluent)((Object)o);
        if (!Objects.equals(this.limitCPU, that.limitCPU)) {
            return false;
        }
        if (!Objects.equals(this.limitMemory, that.limitMemory)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.operatorNamespace, that.operatorNamespace)) {
            return false;
        }
        if (!Objects.equals((Object)this.orderStrategy, (Object)that.orderStrategy)) {
            return false;
        }
        if (!Objects.equals(this.requestCPU, that.requestCPU)) {
            return false;
        }
        if (!Objects.equals(this.requestMemory, that.requestMemory)) {
            return false;
        }
        if (!Objects.equals((Object)this.strategy, (Object)that.strategy)) {
            return false;
        }
        return Objects.equals(this.toolImage, that.toolImage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.limitCPU, this.limitMemory, this.nodeSelector, this.operatorNamespace, this.orderStrategy, this.requestCPU, this.requestMemory, this.strategy, this.toolImage, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.limitCPU != null) {
            sb.append("limitCPU:");
            sb.append(this.limitCPU + ",");
        }
        if (this.limitMemory != null) {
            sb.append("limitMemory:");
            sb.append(this.limitMemory + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.operatorNamespace != null) {
            sb.append("operatorNamespace:");
            sb.append(this.operatorNamespace + ",");
        }
        if (this.orderStrategy != null) {
            sb.append("orderStrategy:");
            sb.append(this.orderStrategy + ",");
        }
        if (this.requestCPU != null) {
            sb.append("requestCPU:");
            sb.append(this.requestCPU + ",");
        }
        if (this.requestMemory != null) {
            sb.append("requestMemory:");
            sb.append(this.requestMemory + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.toolImage != null) {
            sb.append("toolImage:");
            sb.append(this.toolImage);
        }
        sb.append("}");
        return sb.toString();
    }
}

