/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.buildspec.tasks;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.buildspec.tasks.Custom;
import org.apache.camel.v1.buildspec.tasks.custom.Configuration;
import org.apache.camel.v1.buildspec.tasks.custom.ConfigurationBuilder;
import org.apache.camel.v1.buildspec.tasks.custom.ConfigurationFluent;

public class CustomFluent<A extends CustomFluent<A>>
extends BaseFluent<A> {
    private String command;
    private List<String> commands;
    private ConfigurationBuilder configuration;
    private String image;
    private String name;

    public CustomFluent() {
    }

    public CustomFluent(Custom instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Custom instance) {
        Custom custom = instance = instance != null ? instance : new Custom();
        if (instance != null) {
            this.withCommand(instance.getCommand());
            this.withCommands(instance.getCommands());
            this.withConfiguration(instance.getConfiguration());
            this.withImage(instance.getImage());
            this.withName(instance.getName());
        }
    }

    public String getCommand() {
        return this.command;
    }

    public A withCommand(String command) {
        this.command = command;
        return (A)((Object)this);
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public A addToCommands(int index, String item) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        this.commands.add(index, item);
        return (A)((Object)this);
    }

    public A setToCommands(int index, String item) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        this.commands.set(index, item);
        return (A)((Object)this);
    }

    public A addToCommands(String ... items) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        for (String item : items) {
            this.commands.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToCommands(Collection<String> items) {
        if (this.commands == null) {
            this.commands = new ArrayList<String>();
        }
        for (String item : items) {
            this.commands.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromCommands(String ... items) {
        if (this.commands == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.commands.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromCommands(Collection<String> items) {
        if (this.commands == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.commands.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public String getCommand(int index) {
        return this.commands.get(index);
    }

    public String getFirstCommand() {
        return this.commands.get(0);
    }

    public String getLastCommand() {
        return this.commands.get(this.commands.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.commands) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.commands) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommands(List<String> commands) {
        if (commands != null) {
            this.commands = new ArrayList<String>();
            for (String item : commands) {
                this.addToCommands(item);
            }
        } else {
            this.commands = null;
        }
        return (A)((Object)this);
    }

    public A withCommands(String ... commands) {
        if (this.commands != null) {
            this.commands.clear();
            this._visitables.remove((Object)"commands");
        }
        if (commands != null) {
            for (String item : commands) {
                this.addToCommands(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CustomFluent that = (CustomFluent)((Object)o);
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.commands, that.commands)) {
            return false;
        }
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.command, this.commands, this.configuration, this.image, this.name, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.command != null) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.commands != null && !this.commands.isEmpty()) {
            sb.append("commands:");
            sb.append(this.commands + ",");
        }
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)CustomFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

