/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.IntegrationKitSpec;
import org.apache.camel.v1.integrationkitspec.Configuration;
import org.apache.camel.v1.integrationkitspec.ConfigurationBuilder;
import org.apache.camel.v1.integrationkitspec.ConfigurationFluent;
import org.apache.camel.v1.integrationkitspec.Sources;
import org.apache.camel.v1.integrationkitspec.SourcesBuilder;
import org.apache.camel.v1.integrationkitspec.SourcesFluent;
import org.apache.camel.v1.integrationkitspec.Traits;
import org.apache.camel.v1.integrationkitspec.TraitsBuilder;
import org.apache.camel.v1.integrationkitspec.TraitsFluent;

public class IntegrationKitSpecFluent<A extends IntegrationKitSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ConfigurationBuilder> configuration;
    private List<String> dependencies;
    private String image;
    private String profile;
    private List<String> repositories;
    private ArrayList<SourcesBuilder> sources;
    private TraitsBuilder traits;

    public IntegrationKitSpecFluent() {
    }

    public IntegrationKitSpecFluent(IntegrationKitSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IntegrationKitSpec instance) {
        IntegrationKitSpec integrationKitSpec = instance = instance != null ? instance : new IntegrationKitSpec();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withDependencies(instance.getDependencies());
            this.withImage(instance.getImage());
            this.withProfile(instance.getProfile());
            this.withRepositories(instance.getRepositories());
            this.withSources(instance.getSources());
            this.withTraits(instance.getTraits());
        }
    }

    public A addToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").add(index, builder);
            this.configuration.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfiguration(int index, Configuration item) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        ConfigurationBuilder builder = new ConfigurationBuilder(item);
        if (index < 0 || index >= this.configuration.size()) {
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        } else {
            this._visitables.get((Object)"configuration").set(index, builder);
            this.configuration.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            this.configuration = new ArrayList();
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").add(builder);
            this.configuration.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfiguration(Configuration ... items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfiguration(Collection<Configuration> items) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        for (Configuration item : items) {
            ConfigurationBuilder builder = new ConfigurationBuilder(item);
            this._visitables.get((Object)"configuration").remove((Object)builder);
            this.configuration.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfiguration(Predicate<ConfigurationBuilder> predicate) {
        if (this.configuration == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigurationBuilder> each = this.configuration.iterator();
        List visitables = this._visitables.get((Object)"configuration");
        while (each.hasNext()) {
            ConfigurationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Configuration> buildConfiguration() {
        return this.configuration != null ? IntegrationKitSpecFluent.build(this.configuration) : null;
    }

    public Configuration buildConfiguration(int index) {
        return this.configuration.get(index).build();
    }

    public Configuration buildFirstConfiguration() {
        return this.configuration.get(0).build();
    }

    public Configuration buildLastConfiguration() {
        return this.configuration.get(this.configuration.size() - 1).build();
    }

    public Configuration buildMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        for (ConfigurationBuilder item : this.configuration) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConfiguration(List<Configuration> configuration) {
        if (this.configuration != null) {
            this._visitables.get((Object)"configuration").clear();
        }
        if (configuration != null) {
            this.configuration = new ArrayList();
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        } else {
            this.configuration = null;
        }
        return (A)((Object)this);
    }

    public A withConfiguration(Configuration ... configuration) {
        if (this.configuration != null) {
            this.configuration.clear();
            this._visitables.remove((Object)"configuration");
        }
        if (configuration != null) {
            for (Configuration item : configuration) {
                this.addToConfiguration(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null && !this.configuration.isEmpty();
    }

    public ConfigurationNested<A> addNewConfiguration() {
        return new ConfigurationNested(-1, null);
    }

    public ConfigurationNested<A> addNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(-1, item);
    }

    public ConfigurationNested<A> setNewConfigurationLike(int index, Configuration item) {
        return new ConfigurationNested(index, item);
    }

    public ConfigurationNested<A> editConfiguration(int index) {
        if (this.configuration.size() <= index) {
            throw new RuntimeException("Can't edit configuration. Index exceeds size.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editFirstConfiguration() {
        if (this.configuration.size() == 0) {
            throw new RuntimeException("Can't edit first configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(0, this.buildConfiguration(0));
    }

    public ConfigurationNested<A> editLastConfiguration() {
        int index = this.configuration.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configuration. The list is empty.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public ConfigurationNested<A> editMatchingConfiguration(Predicate<ConfigurationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configuration.size(); ++i) {
            if (!predicate.test(this.configuration.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configuration. No match found.");
        }
        return this.setNewConfigurationLike(index, this.buildConfiguration(index));
    }

    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)((Object)this);
    }

    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)((Object)this);
    }

    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(String ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getProfile() {
        return this.profile;
    }

    public A withProfile(String profile) {
        this.profile = profile;
        return (A)((Object)this);
    }

    public boolean hasProfile() {
        return this.profile != null;
    }

    public A addToRepositories(int index, String item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.add(index, item);
        return (A)((Object)this);
    }

    public A setToRepositories(int index, String item) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        this.repositories.set(index, item);
        return (A)((Object)this);
    }

    public A addToRepositories(String ... items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        for (String item : items) {
            this.repositories.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToRepositories(Collection<String> items) {
        if (this.repositories == null) {
            this.repositories = new ArrayList<String>();
        }
        for (String item : items) {
            this.repositories.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromRepositories(String ... items) {
        if (this.repositories == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.repositories.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRepositories(Collection<String> items) {
        if (this.repositories == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.repositories.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getRepositories() {
        return this.repositories;
    }

    public String getRepository(int index) {
        return this.repositories.get(index);
    }

    public String getFirstRepository() {
        return this.repositories.get(0);
    }

    public String getLastRepository() {
        return this.repositories.get(this.repositories.size() - 1);
    }

    public String getMatchingRepository(Predicate<String> predicate) {
        for (String item : this.repositories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingRepository(Predicate<String> predicate) {
        for (String item : this.repositories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRepositories(List<String> repositories) {
        if (repositories != null) {
            this.repositories = new ArrayList<String>();
            for (String item : repositories) {
                this.addToRepositories(item);
            }
        } else {
            this.repositories = null;
        }
        return (A)((Object)this);
    }

    public A withRepositories(String ... repositories) {
        if (this.repositories != null) {
            this.repositories.clear();
            this._visitables.remove((Object)"repositories");
        }
        if (repositories != null) {
            for (String item : repositories) {
                this.addToRepositories(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRepositories() {
        return this.repositories != null && !this.repositories.isEmpty();
    }

    public A addToSources(int index, Sources item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourcesBuilder builder = new SourcesBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").add(index, builder);
            this.sources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSources(int index, Sources item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourcesBuilder builder = new SourcesBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
            this.sources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSources(Sources ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToIntegrationkitspecSources(Collection<Sources> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSources(Sources ... items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromIntegrationkitspecSources(Collection<Sources> items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromIntegrationkitspecSources(Predicate<SourcesBuilder> predicate) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        Iterator<SourcesBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            SourcesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Sources> buildSources() {
        return this.sources != null ? IntegrationKitSpecFluent.build(this.sources) : null;
    }

    public Sources buildSource(int index) {
        return this.sources.get(index).build();
    }

    public Sources buildFirstSource() {
        return this.sources.get(0).build();
    }

    public Sources buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public Sources buildMatchingSource(Predicate<SourcesBuilder> predicate) {
        for (SourcesBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<SourcesBuilder> predicate) {
        for (SourcesBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSources(List<Sources> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (Sources item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)((Object)this);
    }

    public A withSources(Sources ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove((Object)"sources");
        }
        if (sources != null) {
            for (Sources item : sources) {
                this.addToSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public SourcesNested<A> addNewSourceLike(Sources item) {
        return new SourcesNested(-1, item);
    }

    public SourcesNested<A> setNewSourceLike(int index, Sources item) {
        return new SourcesNested(index, item);
    }

    public SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<SourcesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public Traits buildTraits() {
        return this.traits != null ? this.traits.build() : null;
    }

    public A withTraits(Traits traits) {
        this._visitables.remove((Object)"traits");
        if (traits != null) {
            this.traits = new TraitsBuilder(traits);
            this._visitables.get((Object)"traits").add(this.traits);
        } else {
            this.traits = null;
            this._visitables.get((Object)"traits").remove((Object)this.traits);
        }
        return (A)((Object)this);
    }

    public boolean hasTraits() {
        return this.traits != null;
    }

    public TraitsNested<A> withNewTraits() {
        return new TraitsNested(null);
    }

    public TraitsNested<A> withNewTraitsLike(Traits item) {
        return new TraitsNested(item);
    }

    public TraitsNested<A> editTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(null));
    }

    public TraitsNested<A> editOrNewTraits() {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(new TraitsBuilder().build()));
    }

    public TraitsNested<A> editOrNewTraitsLike(Traits item) {
        return this.withNewTraitsLike(Optional.ofNullable(this.buildTraits()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IntegrationKitSpecFluent that = (IntegrationKitSpecFluent)((Object)o);
        if (!Objects.equals(this.configuration, that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        if (!Objects.equals(this.repositories, that.repositories)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        return Objects.equals((Object)this.traits, (Object)that.traits);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.dependencies, this.image, this.profile, this.repositories, this.sources, this.traits, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null && !this.configuration.isEmpty()) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.repositories != null && !this.repositories.isEmpty()) {
            sb.append("repositories:");
            sb.append(this.repositories + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.traits != null) {
            sb.append("traits:");
            sb.append((Object)this.traits);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;
        int index;

        ConfigurationNested(int index, Configuration item) {
            this.index = index;
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitSpecFluent.this.setToConfiguration(this.index, this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }

    public class SourcesNested<N>
    extends SourcesFluent<SourcesNested<N>>
    implements Nested<N> {
        SourcesBuilder builder;
        int index;

        SourcesNested(int index, Sources item) {
            this.index = index;
            this.builder = new SourcesBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitSpecFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endIntegrationkitspecSource() {
            return this.and();
        }
    }

    public class TraitsNested<N>
    extends TraitsFluent<TraitsNested<N>>
    implements Nested<N> {
        TraitsBuilder builder;

        TraitsNested(Traits item) {
            this.builder = new TraitsBuilder(this, item);
        }

        public N and() {
            return (N)IntegrationKitSpecFluent.this.withTraits(this.builder.build());
        }

        public N endTraits() {
            return this.and();
        }
    }
}

