/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.linkedin.internal;

import org.apache.camel.component.linkedin.api.OAuthSecureStorage;
import org.apache.camel.component.linkedin.api.OAuthToken;

public class CachingOAuthSecureStorage
implements OAuthSecureStorage {
    private final OAuthSecureStorage secureStorage;
    private OAuthToken token;

    public CachingOAuthSecureStorage(OAuthSecureStorage secureStorage) {
        this.secureStorage = secureStorage;
    }

    public OAuthToken getOAuthToken() {
        if (this.secureStorage != null && (this.token == null || this.token.getExpiryTime() < System.currentTimeMillis())) {
            this.token = this.secureStorage.getOAuthToken();
        }
        return this.token;
    }

    public void saveOAuthToken(OAuthToken newToken) {
        this.token = newToken;
        if (this.secureStorage != null) {
            this.secureStorage.saveOAuthToken(newToken);
        }
    }
}

