/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.ZooKeeper;

public class DeleteOperation
extends ZooKeeperOperation<Boolean> {
    private int version = -1;

    public DeleteOperation(ZooKeeper connection, String node) {
        super(connection, node);
    }

    @Override
    public OperationResult<Boolean> getResult() {
        try {
            this.connection.delete(this.node, this.version);
            if (LOG.isDebugEnabled()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(String.format("Set data of node '%s'", this.node));
                } else {
                    LOG.debug(String.format("Set data of node '%s'", this.node));
                }
            }
            return new OperationResult<Boolean>(true, null, true);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new OperationResult<Boolean>(e);
        }
        catch (Exception e) {
            return new OperationResult<Boolean>(e);
        }
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public ZooKeeperOperation<?> createCopy() throws Exception {
        DeleteOperation copy = (DeleteOperation)super.createCopy();
        copy.version = -1;
        return copy;
    }
}

