/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeepermaster;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.zookeepermaster.MasterComponent;
import org.apache.camel.component.zookeepermaster.MasterConsumer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@ManagedResource(description="Managed ZooKeeper Master Endpoint")
@UriEndpoint(firstVersion="2.19.0", scheme="zookeeper-master", syntax="zookeeper-master:groupName:consumerEndpointUri", consumerOnly=true, title="ZooKeeper Master", lenientProperties=true, category={Category.CLUSTERING, Category.MANAGEMENT, Category.BIGDATA})
public class MasterEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private final MasterComponent component;
    private final Endpoint consumerEndpoint;
    @UriPath(description="The name of the cluster group to use")
    @Metadata(required=true)
    private final String groupName;
    @UriPath(description="The consumer endpoint to use in master/slave mode")
    @Metadata(required=true)
    private final String consumerEndpointUri;

    public MasterEndpoint(String uri, MasterComponent component, String groupName, String consumerEndpointUri) {
        super(uri, (Component)component);
        this.component = component;
        this.groupName = groupName;
        this.consumerEndpointUri = consumerEndpointUri;
        this.consumerEndpoint = this.getCamelContext().getEndpoint(consumerEndpointUri);
    }

    public Endpoint getEndpoint() {
        return this.consumerEndpoint;
    }

    public Endpoint getConsumerEndpoint() {
        return this.getEndpoint();
    }

    @ManagedAttribute(description="The consumer endpoint url to use in master/slave mode", mask=true)
    public String getConsumerEndpointUri() {
        return this.consumerEndpointUri;
    }

    @ManagedAttribute(description="The name of the cluster group to use")
    public String getGroupName() {
        return this.groupName;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Cannot produce from this endpoint");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new MasterConsumer(this, processor);
    }

    public boolean isLenientProperties() {
        return true;
    }

    public MasterComponent getComponent() {
        return this.component;
    }
}

