/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ZendeskEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    public boolean isEnabled(String scheme) {
        return "zendesk".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(149);
        props.add("active");
        props.add("article");
        props.add("articleAttachments");
        props.add("articleId");
        props.add("articleId0");
        props.add("attachment");
        props.add("attachments");
        props.add("audit");
        props.add("auditId");
        props.add("automation");
        props.add("automationId");
        props.add("automationId0");
        props.add("backoffErrorThreshold");
        props.add("backoffIdleThreshold");
        props.add("backoffMultiplier");
        props.add("bridgeErrorHandler");
        props.add("category");
        props.add("categoryId");
        props.add("categoryId0");
        props.add("categoryId1");
        props.add("category_id");
        props.add("comment");
        props.add("commentId");
        props.add("content");
        props.add("contentTag");
        props.add("contentTagId");
        props.add("contentType");
        props.add("delay");
        props.add("email");
        props.add("endTime");
        props.add("exceptionHandler");
        props.add("exchangePattern");
        props.add("externalId");
        props.add("externalId0");
        props.add("externalId0s");
        props.add("externalIds");
        props.add("field");
        props.add("file");
        props.add("fileName");
        props.add("forum");
        props.add("forum_id");
        props.add("greedy");
        props.add("group");
        props.add("groupMembership");
        props.add("group_id");
        props.add("group_membership_id");
        props.add("id");
        props.add("idArticle");
        props.add("identity");
        props.add("identityId");
        props.add("ids");
        props.add("inBody");
        props.add("includeArchived");
        props.add("initialDelay");
        props.add("inline");
        props.add("installationId");
        props.add("item");
        props.add("itemId");
        props.add("json");
        props.add("labels");
        props.add("lazyStartProducer");
        props.add("locale");
        props.add("macro");
        props.add("macroId");
        props.add("macroId0");
        props.add("methodName");
        props.add("monitorId");
        props.add("name");
        props.add("namePrefix");
        props.add("newPassword");
        props.add("notifySubscribers");
        props.add("oauthToken");
        props.add("oldPassword");
        props.add("order");
        props.add("organization");
        props.add("organizationId");
        props.add("organizationList");
        props.add("organizationMembership");
        props.add("organizationMembershipList");
        props.add("organizationMemberships");
        props.add("organization_id");
        props.add("organization_membership_id");
        props.add("organizations");
        props.add("page");
        props.add("pageSize");
        props.add("password");
        props.add("permissionGroup");
        props.add("pollStrategy");
        props.add("query");
        props.add("queryParams");
        props.add("repeatCount");
        props.add("request");
        props.add("requestId");
        props.add("role");
        props.add("roles");
        props.add("runLoggingLevel");
        props.add("satisfactionRating");
        props.add("schedule");
        props.add("scheduleId");
        props.add("scheduledExecutorService");
        props.add("scheduler");
        props.add("schedulerProperties");
        props.add("searchTerm");
        props.add("section");
        props.add("sectionId");
        props.add("sectionId0");
        props.add("sendEmptyMessageWhenIdle");
        props.add("serverUrl");
        props.add("sortBy");
        props.add("sortOrder");
        props.add("startScheduler");
        props.add("startTime");
        props.add("status");
        props.add("statuses");
        props.add("suspendedTicket");
        props.add("tags");
        props.add("target");
        props.add("targetId");
        props.add("ticket");
        props.add("ticketForm");
        props.add("ticketId");
        props.add("ticketId0");
        props.add("ticketImport");
        props.add("ticketList");
        props.add("tickets");
        props.add("timeUnit");
        props.add("token");
        props.add("topic");
        props.add("translation");
        props.add("translationId");
        props.add("trigger");
        props.add("triggerId");
        props.add("triggerId0");
        props.add("tweetId");
        props.add("unixEpochTime");
        props.add("upload");
        props.add("useFixedDelay");
        props.add("user");
        props.add("userId");
        props.add("userId0");
        props.add("userIdThatWillBeMerged");
        props.add("userIdThatWillRemain");
        props.add("userList");
        props.add("userSegment");
        props.add("user_id");
        props.add("username");
        props.add("users");
        props.add("usersList");
        props.add("variant");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("oauthToken");
        secretProps.add("password");
        secretProps.add("token");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        HashSet<String> prefixes = new HashSet<String>(1);
        prefixes.add("scheduler.");
        MULTI_VALUE_PREFIXES = Collections.unmodifiableSet(prefixes);
    }
}

