/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.asynchttpclient.ListenableFuture;
import org.zendesk.client.v2.Zendesk;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Metric;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SortOrder;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketCount;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.UserRelatedInfo;
import org.zendesk.client.v2.model.dynamic.DynamicContentItem;
import org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.ContentTag;
import org.zendesk.client.v2.model.hc.Locales;
import org.zendesk.client.v2.model.hc.PermissionGroup;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.hc.UserSegment;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.Target;

public enum ZendeskApiMethod implements ApiMethod
{
    ADD_TAG_TO_ORGANISATIONS(List.class, "addTagToOrganisations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    ADD_TAG_TO_TICKET(List.class, "addTagToTicket", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    ADD_TAG_TO_TOPICS(List.class, "addTagToTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    ASSOCIATE_ATTACHMENTS_TO_ARTICLE(Void.TYPE, "associateAttachmentsToArticle", ApiMethodArg.arg((String)"idArticle", String.class), ApiMethodArg.arg((String)"attachments", List.class)),
    CHANGE_USER_PASSWORD(Void.TYPE, "changeUserPassword", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"oldPassword", String.class), ApiMethodArg.arg((String)"newPassword", String.class)),
    CREATE_ARTICLE(Article.class, "createArticle", ApiMethodArg.arg((String)"article", Article.class)),
    CREATE_ARTICLE_1(Article.class, "createArticle", ApiMethodArg.arg((String)"article", Article.class), ApiMethodArg.arg((String)"notifySubscribers", Boolean.TYPE)),
    CREATE_ARTICLE_TRANSLATION(Translation.class, "createArticleTranslation", ApiMethodArg.arg((String)"articleId", Long.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    CREATE_AUTOMATION(Automation.class, "createAutomation", ApiMethodArg.arg((String)"automation", Automation.class)),
    CREATE_CATEGORY(Category.class, "createCategory", ApiMethodArg.arg((String)"category", Category.class)),
    CREATE_CATEGORY_TRANSLATION(Translation.class, "createCategoryTranslation", ApiMethodArg.arg((String)"categoryId", Long.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    CREATE_COMMENT(Ticket.class, "createComment", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"comment", Comment.class)),
    CREATE_CONTENT_TAG(ContentTag.class, "createContentTag", ApiMethodArg.arg((String)"contentTag", ContentTag.class)),
    CREATE_DYNAMIC_CONTENT_ITEM(DynamicContentItem.class, "createDynamicContentItem", ApiMethodArg.arg((String)"item", DynamicContentItem.class)),
    CREATE_DYNAMIC_CONTENT_ITEM_VARIANT(DynamicContentItemVariant.class, "createDynamicContentItemVariant", ApiMethodArg.arg((String)"itemId", Long.class), ApiMethodArg.arg((String)"variant", DynamicContentItemVariant.class)),
    CREATE_FORUM(Forum.class, "createForum", ApiMethodArg.arg((String)"forum", Forum.class)),
    CREATE_GROUP(Group.class, "createGroup", ApiMethodArg.arg((String)"group", Group.class)),
    CREATE_GROUP_MEMBERSHIP(GroupMembership.class, "createGroupMembership", ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    CREATE_GROUP_MEMBERSHIP_1(GroupMembership.class, "createGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    CREATE_MACRO(Macro.class, "createMacro", ApiMethodArg.arg((String)"macro", Macro.class)),
    CREATE_OR_UPDATE_ORGANIZATION(Organization.class, "createOrUpdateOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    CREATE_OR_UPDATE_USER(User.class, "createOrUpdateUser", ApiMethodArg.arg((String)"user", User.class)),
    CREATE_OR_UPDATE_USERS(JobStatus.class, "createOrUpdateUsers", ApiMethodArg.arg((String)"users", new User[0].getClass())),
    CREATE_OR_UPDATE_USERS_1(JobStatus.class, "createOrUpdateUsers", ApiMethodArg.arg((String)"usersList", List.class)),
    CREATE_OR_UPDATE_USERS_ASYNC(ListenableFuture.class, "createOrUpdateUsersAsync", ApiMethodArg.arg((String)"usersList", List.class)),
    CREATE_ORGANIZATION(Organization.class, "createOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    CREATE_ORGANIZATION_MEMBERSHIP(OrganizationMembership.class, "createOrganizationMembership", ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    CREATE_ORGANIZATION_MEMBERSHIP_1(OrganizationMembership.class, "createOrganizationMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    CREATE_ORGANIZATION_MEMBERSHIPS(JobStatus.class, "createOrganizationMemberships", ApiMethodArg.arg((String)"organizationMembershipList", List.class)),
    CREATE_ORGANIZATION_MEMBERSHIPS_1(JobStatus.class, "createOrganizationMemberships", ApiMethodArg.arg((String)"organizationMemberships", new OrganizationMembership[0].getClass())),
    CREATE_ORGANIZATION_MEMBERSHIPS_ASYNC(ListenableFuture.class, "createOrganizationMembershipsAsync", ApiMethodArg.arg((String)"organizationMembershipList", List.class)),
    CREATE_ORGANIZATIONS(JobStatus.class, "createOrganizations", ApiMethodArg.arg((String)"organizationList", List.class)),
    CREATE_ORGANIZATIONS_1(JobStatus.class, "createOrganizations", ApiMethodArg.arg((String)"organizations", new Organization[0].getClass())),
    CREATE_ORGANIZATIONS_ASYNC(ListenableFuture.class, "createOrganizationsAsync", ApiMethodArg.arg((String)"organizationList", List.class)),
    CREATE_PERMISSION_GROUP(PermissionGroup.class, "createPermissionGroup", ApiMethodArg.arg((String)"permissionGroup", PermissionGroup.class)),
    CREATE_REQUEST(Request.class, "createRequest", ApiMethodArg.arg((String)"request", Request.class)),
    CREATE_SATISFACTION_RATING(SatisfactionRating.class, "createSatisfactionRating", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"satisfactionRating", SatisfactionRating.class)),
    CREATE_SATISFACTION_RATING_1(SatisfactionRating.class, "createSatisfactionRating", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"satisfactionRating", SatisfactionRating.class)),
    CREATE_SECTION(Section.class, "createSection", ApiMethodArg.arg((String)"section", Section.class)),
    CREATE_SECTION_TRANSLATION(Translation.class, "createSectionTranslation", ApiMethodArg.arg((String)"sectionId", Long.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    CREATE_TARGET(Target.class, "createTarget", ApiMethodArg.arg((String)"target", Target.class)),
    CREATE_TICKET(Ticket.class, "createTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    CREATE_TICKET_ASYNC(ListenableFuture.class, "createTicketAsync", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    CREATE_TICKET_FIELD(Field.class, "createTicketField", ApiMethodArg.arg((String)"field", Field.class)),
    CREATE_TICKET_FORM(TicketForm.class, "createTicketForm", ApiMethodArg.arg((String)"ticketForm", TicketForm.class)),
    CREATE_TICKET_FROM_TWEET(Ticket.class, "createTicketFromTweet", ApiMethodArg.arg((String)"tweetId", Long.TYPE), ApiMethodArg.arg((String)"monitorId", Long.TYPE)),
    CREATE_TICKETS(JobStatus.class, "createTickets", ApiMethodArg.arg((String)"ticketList", List.class)),
    CREATE_TICKETS_1(JobStatus.class, "createTickets", ApiMethodArg.arg((String)"tickets", new Ticket[0].getClass())),
    CREATE_TICKETS_ASYNC(ListenableFuture.class, "createTicketsAsync", ApiMethodArg.arg((String)"ticketList", List.class)),
    CREATE_TOPIC(Topic.class, "createTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    CREATE_TRIGGER(Trigger.class, "createTrigger", ApiMethodArg.arg((String)"trigger", Trigger.class)),
    CREATE_UPLOAD(Attachment.Upload.class, "createUpload", ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"content", byte[].class)),
    CREATE_UPLOAD_1(Attachment.Upload.class, "createUpload", ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"contentType", String.class), ApiMethodArg.arg((String)"content", byte[].class)),
    CREATE_UPLOAD_2(Attachment.Upload.class, "createUpload", ApiMethodArg.arg((String)"token", String.class), ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"contentType", String.class), ApiMethodArg.arg((String)"content", byte[].class)),
    CREATE_UPLOAD_ARTICLE(ArticleAttachments.class, "createUploadArticle", ApiMethodArg.arg((String)"articleId0", Long.TYPE), ApiMethodArg.arg((String)"file", File.class)),
    CREATE_UPLOAD_ARTICLE_1(ArticleAttachments.class, "createUploadArticle", ApiMethodArg.arg((String)"articleId0", Long.TYPE), ApiMethodArg.arg((String)"file", File.class), ApiMethodArg.arg((String)"inline", Boolean.TYPE)),
    CREATE_USER(User.class, "createUser", ApiMethodArg.arg((String)"user", User.class)),
    CREATE_USER_IDENTITY(Identity.class, "createUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    CREATE_USER_IDENTITY_1(Identity.class, "createUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identity", Identity.class)),
    CREATE_USER_SEGMENT(UserSegment.class, "createUserSegment", ApiMethodArg.arg((String)"userSegment", UserSegment.class)),
    CREATE_USERS(JobStatus.class, "createUsers", ApiMethodArg.arg((String)"userList", List.class)),
    CREATE_USERS_1(JobStatus.class, "createUsers", ApiMethodArg.arg((String)"users", new User[0].getClass())),
    CREATE_USERS_ASYNC(ListenableFuture.class, "createUsersAsync", ApiMethodArg.arg((String)"userList", List.class)),
    DELETE_ARTICLE(Void.TYPE, "deleteArticle", ApiMethodArg.arg((String)"article", Article.class)),
    DELETE_ARTICLE_ATTACHMENT(Void.TYPE, "deleteArticleAttachment", ApiMethodArg.arg((String)"articleAttachments", ArticleAttachments.class)),
    DELETE_ARTICLE_ATTACHMENT_1(Void.TYPE, "deleteArticleAttachment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_ATTACHMENT(Void.TYPE, "deleteAttachment", ApiMethodArg.arg((String)"attachment", Attachment.class)),
    DELETE_ATTACHMENT_1(Void.TYPE, "deleteAttachment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_AUTOMATION(Void.TYPE, "deleteAutomation", ApiMethodArg.arg((String)"automationId0", Long.TYPE)),
    DELETE_CATEGORY(Void.TYPE, "deleteCategory", ApiMethodArg.arg((String)"category", Category.class)),
    DELETE_CONTENT_TAG(Void.TYPE, "deleteContentTag", ApiMethodArg.arg((String)"contentTag", ContentTag.class)),
    DELETE_DYNAMIC_CONTENT_ITEM(Void.TYPE, "deleteDynamicContentItem", ApiMethodArg.arg((String)"item", DynamicContentItem.class)),
    DELETE_DYNAMIC_CONTENT_ITEM_VARIANT(Void.TYPE, "deleteDynamicContentItemVariant", ApiMethodArg.arg((String)"itemId", Long.class), ApiMethodArg.arg((String)"variant", DynamicContentItemVariant.class)),
    DELETE_FORUM(Void.TYPE, "deleteForum", ApiMethodArg.arg((String)"forum", Forum.class)),
    DELETE_GROUP(Void.TYPE, "deleteGroup", ApiMethodArg.arg((String)"group", Group.class)),
    DELETE_GROUP_1(Void.TYPE, "deleteGroup", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_GROUP_MEMBERSHIP(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    DELETE_GROUP_MEMBERSHIP_1(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_GROUP_MEMBERSHIP_2(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    DELETE_GROUP_MEMBERSHIP_3(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"group_membership_id", Long.TYPE)),
    DELETE_ORGANIZATION(Void.TYPE, "deleteOrganization", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_ORGANIZATION_1(Void.TYPE, "deleteOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    DELETE_ORGANIZATION_MEMBERSHIP(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_ORGANIZATION_MEMBERSHIP_1(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    DELETE_ORGANIZATION_MEMBERSHIP_2(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organization_membership_id", Long.TYPE)),
    DELETE_ORGANIZATION_MEMBERSHIPS(Void.TYPE, "deleteOrganizationMemberships", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    DELETE_ORGANIZATIONS(JobStatus.class, "deleteOrganizations", ApiMethodArg.arg((String)"ids", long[].class)),
    DELETE_PERMISSION_GROUP(Void.TYPE, "deletePermissionGroup", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_PERMISSION_GROUP_1(Void.TYPE, "deletePermissionGroup", ApiMethodArg.arg((String)"permissionGroup", PermissionGroup.class)),
    DELETE_SECTION(Void.TYPE, "deleteSection", ApiMethodArg.arg((String)"section", Section.class)),
    DELETE_SUSPENDED_TICKET(Void.TYPE, "deleteSuspendedTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_SUSPENDED_TICKET_1(Void.TYPE, "deleteSuspendedTicket", ApiMethodArg.arg((String)"suspendedTicket", SuspendedTicket.class)),
    DELETE_TARGET(Void.TYPE, "deleteTarget", ApiMethodArg.arg((String)"targetId", Long.TYPE)),
    DELETE_TICKET(Void.TYPE, "deleteTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_TICKET_1(Void.TYPE, "deleteTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    DELETE_TICKET_FIELD(Void.TYPE, "deleteTicketField", ApiMethodArg.arg((String)"field", Field.class)),
    DELETE_TICKET_FIELD_1(Void.TYPE, "deleteTicketField", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_TICKET_FORM(Void.TYPE, "deleteTicketForm", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_TICKET_FORM_1(Void.TYPE, "deleteTicketForm", ApiMethodArg.arg((String)"ticketForm", TicketForm.class)),
    DELETE_TICKETS(JobStatus.class, "deleteTickets", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    DELETE_TOPIC(Void.TYPE, "deleteTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    DELETE_TRANSLATION(Void.TYPE, "deleteTranslation", ApiMethodArg.arg((String)"translation", Translation.class)),
    DELETE_TRANSLATION_1(Void.TYPE, "deleteTranslation", ApiMethodArg.arg((String)"translationId", Long.class)),
    DELETE_TRIGGER(Void.TYPE, "deleteTrigger", ApiMethodArg.arg((String)"triggerId", Long.TYPE)),
    DELETE_UPLOAD(Void.TYPE, "deleteUpload", ApiMethodArg.arg((String)"token", String.class)),
    DELETE_UPLOAD_1(Void.TYPE, "deleteUpload", ApiMethodArg.arg((String)"upload", Attachment.Upload.class)),
    DELETE_USER(Void.TYPE, "deleteUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_USER_1(Void.TYPE, "deleteUser", ApiMethodArg.arg((String)"user", User.class)),
    DELETE_USER_IDENTITY(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    DELETE_USER_IDENTITY_1(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    DELETE_USER_IDENTITY_2(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    DELETE_USER_SEGMENT(Void.TYPE, "deleteUserSegment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETE_USER_SEGMENT_1(Void.TYPE, "deleteUserSegment", ApiMethodArg.arg((String)"userSegment", UserSegment.class)),
    DELETE_USERS(JobStatus.class, "deleteUsers", ApiMethodArg.arg((String)"ids", long[].class)),
    GET_ACTIVE_TRIGGERS(Iterable.class, "getActiveTriggers", new ApiMethodArg[0]),
    GET_ARTICLE(Article.class, "getArticle", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ARTICLE_FROM_SEARCH(Iterable.class, "getArticleFromSearch", ApiMethodArg.arg((String)"searchTerm", String.class)),
    GET_ARTICLE_FROM_SEARCH_1(Iterable.class, "getArticleFromSearch", ApiMethodArg.arg((String)"searchTerm", String.class), ApiMethodArg.arg((String)"sectionId", Long.class)),
    GET_ARTICLE_SUBSCRIPTIONS(Iterable.class, "getArticleSubscriptions", ApiMethodArg.arg((String)"articleId", Long.class)),
    GET_ARTICLE_SUBSCRIPTIONS_1(Iterable.class, "getArticleSubscriptions", ApiMethodArg.arg((String)"articleId", Long.class), ApiMethodArg.arg((String)"locale", String.class)),
    GET_ARTICLE_TRANSLATIONS(Iterable.class, "getArticleTranslations", ApiMethodArg.arg((String)"articleId", Long.class)),
    GET_ARTICLES(Iterable.class, "getArticles", new ApiMethodArg[0]),
    GET_ARTICLES_1(Iterable.class, "getArticles", ApiMethodArg.arg((String)"category", Category.class)),
    GET_ARTICLES_2(Iterable.class, "getArticles", ApiMethodArg.arg((String)"locale", String.class)),
    GET_ARTICLES_3(Iterable.class, "getArticles", ApiMethodArg.arg((String)"section", Section.class)),
    GET_ARTICLES_FROM_ALL_LABELS(Iterable.class, "getArticlesFromAllLabels", ApiMethodArg.arg((String)"labels", List.class)),
    GET_ARTICLES_FROM_ANY_LABELS(Iterable.class, "getArticlesFromAnyLabels", ApiMethodArg.arg((String)"labels", List.class)),
    GET_ARTICLES_FROM_PAGE(List.class, "getArticlesFromPage", ApiMethodArg.arg((String)"page", Integer.TYPE)),
    GET_ARTICLES_INCREMENTALLY(Iterable.class, "getArticlesIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GET_ASSIGNABLE_GROUP_MEMBERSHIPS(Iterable.class, "getAssignableGroupMemberships", new ApiMethodArg[0]),
    GET_ASSIGNABLE_GROUP_MEMBERSHIPS_1(Iterable.class, "getAssignableGroupMemberships", ApiMethodArg.arg((String)"group_id", Long.TYPE)),
    GET_ASSIGNABLE_GROUPS(Iterable.class, "getAssignableGroups", new ApiMethodArg[0]),
    GET_ASSIGNED_TICKETS_COUNT_FOR_USER(TicketCount.class, "getAssignedTicketsCountForUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ATTACHMENT(Attachment.class, "getAttachment", ApiMethodArg.arg((String)"attachment", Attachment.class)),
    GET_ATTACHMENT_1(Attachment.class, "getAttachment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ATTACHMENTS_FROM_ARTICLE(List.class, "getAttachmentsFromArticle", ApiMethodArg.arg((String)"articleId", Long.class)),
    GET_AUTHENTICATED_USER(User.class, "getAuthenticatedUser", new ApiMethodArg[0]),
    GET_AUTO_COMPLETE_ORGANIZATIONS(Iterable.class, "getAutoCompleteOrganizations", ApiMethodArg.arg((String)"name", String.class)),
    GET_AUTOMATION(Automation.class, "getAutomation", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_AUTOMATIONS(Iterable.class, "getAutomations", new ApiMethodArg[0]),
    GET_BRANDS(Iterable.class, "getBrands", new ApiMethodArg[0]),
    GET_CC_REQUESTS(Iterable.class, "getCCRequests", new ApiMethodArg[0]),
    GET_CATEGORIES(Iterable.class, "getCategories", new ApiMethodArg[0]),
    GET_CATEGORY(Category.class, "getCategory", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_CATEGORY_TRANSLATIONS(Iterable.class, "getCategoryTranslations", ApiMethodArg.arg((String)"categoryId", Long.class)),
    GET_CCD_TICKETS_COUNT_FOR_USER(TicketCount.class, "getCcdTicketsCountForUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_COMPLIANCE_DELETION_STATUSES(Iterable.class, "getComplianceDeletionStatuses", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GET_CONTENT_TAG(ContentTag.class, "getContentTag", ApiMethodArg.arg((String)"contentTagId", String.class)),
    GET_CONTENT_TAGS(Iterable.class, "getContentTags", new ApiMethodArg[0]),
    GET_CONTENT_TAGS_1(Iterable.class, "getContentTags", ApiMethodArg.arg((String)"pageSize", Integer.TYPE)),
    GET_CONTENT_TAGS_2(Iterable.class, "getContentTags", ApiMethodArg.arg((String)"pageSize", Integer.TYPE), ApiMethodArg.arg((String)"namePrefix", String.class)),
    GET_CURRENT_USER(User.class, "getCurrentUser", new ApiMethodArg[0]),
    GET_CUSTOM_AGENT_ROLES(Iterable.class, "getCustomAgentRoles", new ApiMethodArg[0]),
    GET_CUSTOM_TICKET_STATUSES(Iterable.class, "getCustomTicketStatuses", new ApiMethodArg[0]),
    GET_DELETED_TICKETS(Iterable.class, "getDeletedTickets", new ApiMethodArg[0]),
    GET_DELETED_TICKETS_1(Iterable.class, "getDeletedTickets", ApiMethodArg.arg((String)"sortBy", String.class), ApiMethodArg.arg((String)"sortOrder", SortOrder.class)),
    GET_DYNAMIC_CONTENT_ITEM(DynamicContentItem.class, "getDynamicContentItem", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_DYNAMIC_CONTENT_ITEM_VARIANT(DynamicContentItemVariant.class, "getDynamicContentItemVariant", ApiMethodArg.arg((String)"itemId", Long.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_DYNAMIC_CONTENT_ITEM_VARIANTS(Iterable.class, "getDynamicContentItemVariants", ApiMethodArg.arg((String)"item", DynamicContentItem.class)),
    GET_DYNAMIC_CONTENT_ITEMS(Iterable.class, "getDynamicContentItems", new ApiMethodArg[0]),
    GET_FORUM(Forum.class, "getForum", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_FORUMS(Iterable.class, "getForums", new ApiMethodArg[0]),
    GET_FORUMS_1(List.class, "getForums", ApiMethodArg.arg((String)"category_id", Long.TYPE)),
    GET_GROUP(Group.class, "getGroup", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_GROUP_MEMBERSHIP(GroupMembership.class, "getGroupMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_GROUP_MEMBERSHIP_1(GroupMembership.class, "getGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"group_membership_id", Long.TYPE)),
    GET_GROUP_MEMBERSHIP_BY_USER(Iterable.class, "getGroupMembershipByUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GET_GROUP_MEMBERSHIPS(Iterable.class, "getGroupMemberships", new ApiMethodArg[0]),
    GET_GROUP_MEMBERSHIPS_1(Iterable.class, "getGroupMemberships", ApiMethodArg.arg((String)"group_id", Long.TYPE)),
    GET_GROUP_ORGANIZATION(OrganizationMembership.class, "getGroupOrganization", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organization_membership_id", Long.TYPE)),
    GET_GROUP_USERS(Iterable.class, "getGroupUsers", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_GROUPS(Iterable.class, "getGroups", new ApiMethodArg[0]),
    GET_HELP_CENTER_LOCALES(List.class, "getHelpCenterLocales", new ApiMethodArg[0]),
    GET_HOLIDAYS_FOR_SCHEDULE(Iterable.class, "getHolidaysForSchedule", ApiMethodArg.arg((String)"schedule", Schedule.class)),
    GET_HOLIDAYS_FOR_SCHEDULE_1(Iterable.class, "getHolidaysForSchedule", ApiMethodArg.arg((String)"scheduleId", Long.class)),
    GET_INCREMENTAL_TICKETS_RESULT(Map.class, "getIncrementalTicketsResult", ApiMethodArg.arg((String)"unixEpochTime", Long.TYPE)),
    GET_JIRA_LINKS(Iterable.class, "getJiraLinks", new ApiMethodArg[0]),
    GET_JOB_STATUS(JobStatus.class, "getJobStatus", ApiMethodArg.arg((String)"status", JobStatus.class)),
    GET_JOB_STATUS_ASYNC(ListenableFuture.class, "getJobStatusAsync", ApiMethodArg.arg((String)"status", JobStatus.class)),
    GET_JOB_STATUSES(List.class, "getJobStatuses", ApiMethodArg.arg((String)"statuses", List.class)),
    GET_JOB_STATUSES_ASYNC(ListenableFuture.class, "getJobStatusesAsync", ApiMethodArg.arg((String)"statuses", List.class)),
    GET_LOCALES(Iterable.class, "getLocales", new ApiMethodArg[0]),
    GET_MACRO(Macro.class, "getMacro", ApiMethodArg.arg((String)"macroId", Long.TYPE)),
    GET_MACROS(Iterable.class, "getMacros", new ApiMethodArg[0]),
    GET_OPEN_REQUESTS(Iterable.class, "getOpenRequests", new ApiMethodArg[0]),
    GET_ORGANIZATION(Organization.class, "getOrganization", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ORGANIZATION_FIELDS(Iterable.class, "getOrganizationFields", new ApiMethodArg[0]),
    GET_ORGANIZATION_MEMBERSHIP(OrganizationMembership.class, "getOrganizationMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIP_BY_USER(Iterable.class, "getOrganizationMembershipByUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIP_FOR_USER(OrganizationMembership.class, "getOrganizationMembershipForUser", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIPS(Iterable.class, "getOrganizationMemberships", new ApiMethodArg[0]),
    GET_ORGANIZATION_MEMBERSHIPS_FOR_ORG(Iterable.class, "getOrganizationMembershipsForOrg", ApiMethodArg.arg((String)"organization_id", Long.TYPE)),
    GET_ORGANIZATION_MEMBERSHIPS_FOR_USER(Iterable.class, "getOrganizationMembershipsForUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GET_ORGANIZATION_REQUESTS(Iterable.class, "getOrganizationRequests", ApiMethodArg.arg((String)"organizationId", Long.TYPE)),
    GET_ORGANIZATION_TICKETS(Iterable.class, "getOrganizationTickets", ApiMethodArg.arg((String)"organizationId", Long.TYPE)),
    GET_ORGANIZATION_USERS(Iterable.class, "getOrganizationUsers", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_ORGANIZATIONS(Iterable.class, "getOrganizations", new ApiMethodArg[0]),
    GET_ORGANIZATIONS_1(List.class, "getOrganizations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    GET_ORGANIZATIONS_INCREMENTALLY(Iterable.class, "getOrganizationsIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GET_PERMISSION_GROUP(PermissionGroup.class, "getPermissionGroup", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_PERMISSION_GROUPS(Iterable.class, "getPermissionGroups", new ApiMethodArg[0]),
    GET_RECENT_TICKETS(Iterable.class, "getRecentTickets", new ApiMethodArg[0]),
    GET_REQUEST(Request.class, "getRequest", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_REQUEST_COMMENT(Comment.class, "getRequestComment", ApiMethodArg.arg((String)"request", Request.class), ApiMethodArg.arg((String)"comment", Comment.class)),
    GET_REQUEST_COMMENT_1(Comment.class, "getRequestComment", ApiMethodArg.arg((String)"request", Request.class), ApiMethodArg.arg((String)"commentId", Long.TYPE)),
    GET_REQUEST_COMMENT_2(Comment.class, "getRequestComment", ApiMethodArg.arg((String)"requestId", Long.TYPE), ApiMethodArg.arg((String)"commentId", Long.TYPE)),
    GET_REQUEST_COMMENTS(Iterable.class, "getRequestComments", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_REQUEST_COMMENTS_1(Iterable.class, "getRequestComments", ApiMethodArg.arg((String)"request", Request.class)),
    GET_REQUESTS(Iterable.class, "getRequests", new ApiMethodArg[0]),
    GET_SATISFACTION_RATING(SatisfactionRating.class, "getSatisfactionRating", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_SATISFACTION_RATINGS(Iterable.class, "getSatisfactionRatings", new ApiMethodArg[0]),
    GET_SCHEDULE(Schedule.class, "getSchedule", ApiMethodArg.arg((String)"schedule", Schedule.class)),
    GET_SCHEDULE_1(Schedule.class, "getSchedule", ApiMethodArg.arg((String)"scheduleId", Long.class)),
    GET_SCHEDULES(Iterable.class, "getSchedules", new ApiMethodArg[0]),
    GET_SEARCH_TICKET_RESULTS(Optional.class, "getSearchTicketResults", ApiMethodArg.arg((String)"query", String.class), ApiMethodArg.arg((String)"queryParams", Map.class), ApiMethodArg.arg((String)"sortBy", String.class), ApiMethodArg.arg((String)"sortOrder", SortOrder.class)),
    GET_SECTION(Section.class, "getSection", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_SECTION_SUBSCRIPTIONS(Iterable.class, "getSectionSubscriptions", ApiMethodArg.arg((String)"sectionId", Long.class)),
    GET_SECTION_SUBSCRIPTIONS_1(Iterable.class, "getSectionSubscriptions", ApiMethodArg.arg((String)"sectionId", Long.class), ApiMethodArg.arg((String)"locale", String.class)),
    GET_SECTION_TRANSLATIONS(Iterable.class, "getSectionTranslations", ApiMethodArg.arg((String)"sectionId", Long.class)),
    GET_SECTIONS(Iterable.class, "getSections", new ApiMethodArg[0]),
    GET_SECTIONS_1(Iterable.class, "getSections", ApiMethodArg.arg((String)"category", Category.class)),
    GET_SECTIONS_2(Iterable.class, "getSections", ApiMethodArg.arg((String)"userSegment", UserSegment.class)),
    GET_SOLVED_REQUESTS(Iterable.class, "getSolvedRequests", new ApiMethodArg[0]),
    GET_SUSPENDED_TICKETS(Iterable.class, "getSuspendedTickets", new ApiMethodArg[0]),
    GET_TARGET(Target.class, "getTarget", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TARGETS(Iterable.class, "getTargets", new ApiMethodArg[0]),
    GET_TICKET(Ticket.class, "getTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_AUDIT(Audit.class, "getTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"audit", Audit.class)),
    GET_TICKET_AUDIT_1(Audit.class, "getTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_AUDIT_2(Audit.class, "getTicketAudit", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"auditId", Long.TYPE)),
    GET_TICKET_AUDITS(Iterable.class, "getTicketAudits", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    GET_TICKET_AUDITS_1(Iterable.class, "getTicketAudits", ApiMethodArg.arg((String)"ticketId0", Long.class)),
    GET_TICKET_COLLABORATORS(List.class, "getTicketCollaborators", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_COMMENTS(Iterable.class, "getTicketComments", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_COMMENTS_1(Iterable.class, "getTicketComments", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"order", SortOrder.class)),
    GET_TICKET_FIELD(Field.class, "getTicketField", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_FIELDS(Iterable.class, "getTicketFields", new ApiMethodArg[0]),
    GET_TICKET_FORM(TicketForm.class, "getTicketForm", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_FORMS(List.class, "getTicketForms", new ApiMethodArg[0]),
    GET_TICKET_INCIDENTS(Iterable.class, "getTicketIncidents", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_METRIC(Metric.class, "getTicketMetric", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_METRIC_BY_TICKET(Metric.class, "getTicketMetricByTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKET_METRICS(Iterable.class, "getTicketMetrics", new ApiMethodArg[0]),
    GET_TICKETS(Iterable.class, "getTickets", new ApiMethodArg[0]),
    GET_TICKETS_1(List.class, "getTickets", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    GET_TICKETS_BY_EXTERNAL_ID(Iterable.class, "getTicketsByExternalId", ApiMethodArg.arg((String)"externalId", String.class)),
    GET_TICKETS_BY_EXTERNAL_ID_1(Iterable.class, "getTicketsByExternalId", ApiMethodArg.arg((String)"externalId", String.class), ApiMethodArg.arg((String)"includeArchived", Boolean.TYPE)),
    GET_TICKETS_COUNT(TicketCount.class, "getTicketsCount", new ApiMethodArg[0]),
    GET_TICKETS_COUNT_FOR_ORGANIZATION(TicketCount.class, "getTicketsCountForOrganization", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TICKETS_FROM_SEARCH(Iterable.class, "getTicketsFromSearch", ApiMethodArg.arg((String)"searchTerm", String.class)),
    GET_TICKETS_INCREMENTALLY(Iterable.class, "getTicketsIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GET_TICKETS_INCREMENTALLY_1(Iterable.class, "getTicketsIncrementally", ApiMethodArg.arg((String)"startTime", Date.class), ApiMethodArg.arg((String)"endTime", Date.class)),
    GET_TIME_ZONES(List.class, "getTimeZones", new ApiMethodArg[0]),
    GET_TOPIC(Topic.class, "getTopic", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TOPICS(Iterable.class, "getTopics", new ApiMethodArg[0]),
    GET_TOPICS_1(List.class, "getTopics", ApiMethodArg.arg((String)"forum_id", Long.TYPE)),
    GET_TOPICS_2(Iterable.class, "getTopics", ApiMethodArg.arg((String)"userSegment", UserSegment.class)),
    GET_TOPICS_3(List.class, "getTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    GET_TOPICS_BY_USER(List.class, "getTopicsByUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GET_TRIGGER(Trigger.class, "getTrigger", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_TRIGGERS(Iterable.class, "getTriggers", new ApiMethodArg[0]),
    GET_TRIGGERS_1(Iterable.class, "getTriggers", ApiMethodArg.arg((String)"categoryId0", String.class), ApiMethodArg.arg((String)"active", Boolean.TYPE), ApiMethodArg.arg((String)"sortBy", String.class), ApiMethodArg.arg((String)"sortOrder", SortOrder.class)),
    GET_TWITTER_MONITORS(Iterable.class, "getTwitterMonitors", new ApiMethodArg[0]),
    GET_USER(User.class, "getUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_USER_CCD_TICKETS(Iterable.class, "getUserCCDTickets", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GET_USER_FIELDS(Iterable.class, "getUserFields", new ApiMethodArg[0]),
    GET_USER_IDENTITIES(List.class, "getUserIdentities", ApiMethodArg.arg((String)"user", User.class)),
    GET_USER_IDENTITIES_1(List.class, "getUserIdentities", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GET_USER_IDENTITY(Identity.class, "getUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    GET_USER_IDENTITY_1(Identity.class, "getUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    GET_USER_IDENTITY_2(Identity.class, "getUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    GET_USER_RELATED_INFO(UserRelatedInfo.class, "getUserRelatedInfo", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GET_USER_REQUESTED_TICKETS(Iterable.class, "getUserRequestedTickets", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GET_USER_REQUESTS(Iterable.class, "getUserRequests", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_USER_REQUESTS_1(Iterable.class, "getUserRequests", ApiMethodArg.arg((String)"user", User.class)),
    GET_USER_SEGMENT(UserSegment.class, "getUserSegment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_USER_SEGMENTS(Iterable.class, "getUserSegments", new ApiMethodArg[0]),
    GET_USER_SEGMENTS_1(Iterable.class, "getUserSegments", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_USER_SEGMENTS_APPLICABLE(Iterable.class, "getUserSegmentsApplicable", new ApiMethodArg[0]),
    GET_USER_SUBSCRIPTIONS(Iterable.class, "getUserSubscriptions", ApiMethodArg.arg((String)"user", User.class)),
    GET_USER_SUBSCRIPTIONS_1(Iterable.class, "getUserSubscriptions", ApiMethodArg.arg((String)"userId0", Long.class)),
    GET_USERS(Iterable.class, "getUsers", new ApiMethodArg[0]),
    GET_USERS_1(List.class, "getUsers", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    GET_USERS_BY_EXTERNAL_IDS(List.class, "getUsersByExternalIds", ApiMethodArg.arg((String)"externalId", String.class), ApiMethodArg.arg((String)"externalIds", new String[0].getClass())),
    GET_USERS_BY_EXTERNAL_IDS_1(List.class, "getUsersByExternalIds", ApiMethodArg.arg((String)"externalId0", Long.TYPE), ApiMethodArg.arg((String)"externalId0s", long[].class)),
    GET_USERS_BY_ROLE(Iterable.class, "getUsersByRole", ApiMethodArg.arg((String)"role", String.class), ApiMethodArg.arg((String)"roles", new String[0].getClass())),
    GET_USERS_INCREMENTALLY(Iterable.class, "getUsersIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GET_VIEW(Iterable.class, "getView", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GET_VIEWS(Iterable.class, "getViews", new ApiMethodArg[0]),
    IMPORT_TICKET(Ticket.class, "importTicket", ApiMethodArg.arg((String)"ticketImport", TicketImport.class)),
    IMPORT_TOPIC(Topic.class, "importTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    LIST_HELP_CENTER_LOCALES(Locales.class, "listHelpCenterLocales", new ApiMethodArg[0]),
    LOOKUP_ORGANIZATIONS_BY_EXTERNAL_ID(Iterable.class, "lookupOrganizationsByExternalId", ApiMethodArg.arg((String)"externalId", String.class)),
    LOOKUP_USER_BY_EMAIL(Iterable.class, "lookupUserByEmail", ApiMethodArg.arg((String)"email", String.class)),
    LOOKUP_USER_BY_EXTERNAL_ID(Iterable.class, "lookupUserByExternalId", ApiMethodArg.arg((String)"externalId", String.class)),
    MACROS_SHOW_CHANGES_TO_TICKET(Ticket.class, "macrosShowChangesToTicket", ApiMethodArg.arg((String)"macroId", Long.TYPE)),
    MACROS_SHOW_TICKET_AFTER_CHANGES(Ticket.class, "macrosShowTicketAfterChanges", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"macroId", Long.TYPE)),
    MAKE_PRIVATE_TICKET_AUDIT(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"audit", Audit.class)),
    MAKE_PRIVATE_TICKET_AUDIT_1(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    MAKE_PRIVATE_TICKET_AUDIT_2(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"auditId", Long.TYPE)),
    MARK_TICKET_AS_SPAM(Void.TYPE, "markTicketAsSpam", ApiMethodArg.arg((String)"id", Long.TYPE)),
    MARK_TICKET_AS_SPAM_1(Void.TYPE, "markTicketAsSpam", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    MERGE_USERS(User.class, "mergeUsers", ApiMethodArg.arg((String)"userIdThatWillRemain", Long.TYPE), ApiMethodArg.arg((String)"userIdThatWillBeMerged", Long.TYPE)),
    NOTIFY_APP(Void.TYPE, "notifyApp", ApiMethodArg.arg((String)"json", String.class)),
    PERMANENTLY_DELETE_TICKET(JobStatus.class, "permanentlyDeleteTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    PERMANENTLY_DELETE_TICKET_1(JobStatus.class, "permanentlyDeleteTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    PERMANENTLY_DELETE_TICKETS(JobStatus.class, "permanentlyDeleteTickets", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", long[].class)),
    PERMANENTLY_DELETE_USER(User.class, "permanentlyDeleteUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    PERMANENTLY_DELETE_USER_1(User.class, "permanentlyDeleteUser", ApiMethodArg.arg((String)"user", User.class)),
    QUEUE_CREATE_TICKET_ASYNC(ListenableFuture.class, "queueCreateTicketAsync", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    REMOVE_TAG_FROM_ORGANISATIONS(List.class, "removeTagFromOrganisations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    REMOVE_TAG_FROM_TICKET(List.class, "removeTagFromTicket", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    REMOVE_TAG_FROM_TOPICS(List.class, "removeTagFromTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    REQUEST_VERIFY_USER_IDENTITY(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    REQUEST_VERIFY_USER_IDENTITY_1(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    REQUEST_VERIFY_USER_IDENTITY_2(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    RESET_USER_PASSWORD(Void.TYPE, "resetUserPassword", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"password", String.class)),
    RESET_USER_PASSWORD_1(Void.TYPE, "resetUserPassword", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"password", String.class)),
    SEARCH_TRIGGERS(Iterable.class, "searchTriggers", ApiMethodArg.arg((String)"query", String.class)),
    SEARCH_TRIGGERS_1(Iterable.class, "searchTriggers", ApiMethodArg.arg((String)"query", String.class), ApiMethodArg.arg((String)"active", Boolean.TYPE), ApiMethodArg.arg((String)"sortBy", String.class), ApiMethodArg.arg((String)"sortOrder", SortOrder.class)),
    SET_GROUP_MEMBERSHIP_AS_DEFAULT(List.class, "setGroupMembershipAsDefault", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    SET_ORGANIZATION_MEMBERSHIP_AS_DEFAULT(List.class, "setOrganizationMembershipAsDefault", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    SET_TAG_ON_ORGANISATIONS(List.class, "setTagOnOrganisations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    SET_TAG_ON_TICKET(List.class, "setTagOnTicket", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    SET_TAG_ON_TOPICS(List.class, "setTagOnTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    SET_USER_PRIMARY_IDENTITY(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    SET_USER_PRIMARY_IDENTITY_1(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    SET_USER_PRIMARY_IDENTITY_2(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    SHOW_ARTICLE_TRANSLATION(Translation.class, "showArticleTranslation", ApiMethodArg.arg((String)"articleId0", Long.TYPE), ApiMethodArg.arg((String)"locale", String.class)),
    SHOW_CATEGORY_TRANSLATION(Translation.class, "showCategoryTranslation", ApiMethodArg.arg((String)"categoryId1", Long.TYPE), ApiMethodArg.arg((String)"locale", String.class)),
    SHOW_SECTION_TRANSLATION(Translation.class, "showSectionTranslation", ApiMethodArg.arg((String)"sectionId0", Long.TYPE), ApiMethodArg.arg((String)"locale", String.class)),
    SUSPEND_USER(User.class, "suspendUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    TRUST_TICKET_AUDIT(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"audit", Audit.class)),
    TRUST_TICKET_AUDIT_1(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    TRUST_TICKET_AUDIT_2(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"auditId", Long.TYPE)),
    UNSUSPEND_USER(User.class, "unsuspendUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    UPDATE_ARTICLE(Article.class, "updateArticle", ApiMethodArg.arg((String)"article", Article.class)),
    UPDATE_ARTICLE_TRANSLATION(Translation.class, "updateArticleTranslation", ApiMethodArg.arg((String)"articleId", Long.class), ApiMethodArg.arg((String)"locale", String.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    UPDATE_AUTOMATION(Automation.class, "updateAutomation", ApiMethodArg.arg((String)"automationId", Long.class), ApiMethodArg.arg((String)"automation", Automation.class)),
    UPDATE_CATEGORY(Category.class, "updateCategory", ApiMethodArg.arg((String)"category", Category.class)),
    UPDATE_CATEGORY_TRANSLATION(Translation.class, "updateCategoryTranslation", ApiMethodArg.arg((String)"categoryId", Long.class), ApiMethodArg.arg((String)"locale", String.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    UPDATE_CONTENT_TAG(ContentTag.class, "updateContentTag", ApiMethodArg.arg((String)"contentTag", ContentTag.class)),
    UPDATE_DYNAMIC_CONTENT_ITEM(DynamicContentItem.class, "updateDynamicContentItem", ApiMethodArg.arg((String)"item", DynamicContentItem.class)),
    UPDATE_DYNAMIC_CONTENT_ITEM_VARIANT(DynamicContentItemVariant.class, "updateDynamicContentItemVariant", ApiMethodArg.arg((String)"itemId", Long.class), ApiMethodArg.arg((String)"variant", DynamicContentItemVariant.class)),
    UPDATE_FORUM(Forum.class, "updateForum", ApiMethodArg.arg((String)"forum", Forum.class)),
    UPDATE_GROUP(Group.class, "updateGroup", ApiMethodArg.arg((String)"group", Group.class)),
    UPDATE_INSTALLATION(Void.TYPE, "updateInstallation", ApiMethodArg.arg((String)"installationId", Integer.TYPE), ApiMethodArg.arg((String)"json", String.class)),
    UPDATE_MACRO(Macro.class, "updateMacro", ApiMethodArg.arg((String)"macroId0", Long.class), ApiMethodArg.arg((String)"macro", Macro.class)),
    UPDATE_ORGANIZATION(Organization.class, "updateOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    UPDATE_ORGANIZATIONS(JobStatus.class, "updateOrganizations", ApiMethodArg.arg((String)"organizationList", List.class)),
    UPDATE_ORGANIZATIONS_1(JobStatus.class, "updateOrganizations", ApiMethodArg.arg((String)"organizations", new Organization[0].getClass())),
    UPDATE_ORGANIZATIONS_ASYNC(ListenableFuture.class, "updateOrganizationsAsync", ApiMethodArg.arg((String)"organizationList", List.class)),
    UPDATE_PERMISSION_GROUP(PermissionGroup.class, "updatePermissionGroup", ApiMethodArg.arg((String)"permissionGroup", PermissionGroup.class)),
    UPDATE_REQUEST(Request.class, "updateRequest", ApiMethodArg.arg((String)"request", Request.class)),
    UPDATE_SECTION(Section.class, "updateSection", ApiMethodArg.arg((String)"section", Section.class)),
    UPDATE_SECTION_TRANSLATION(Translation.class, "updateSectionTranslation", ApiMethodArg.arg((String)"sectionId", Long.class), ApiMethodArg.arg((String)"locale", String.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    UPDATE_TICKET(Ticket.class, "updateTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    UPDATE_TICKET_FIELD(Field.class, "updateTicketField", ApiMethodArg.arg((String)"field", Field.class)),
    UPDATE_TICKET_FORM(TicketForm.class, "updateTicketForm", ApiMethodArg.arg((String)"ticketForm", TicketForm.class)),
    UPDATE_TICKETS(JobStatus.class, "updateTickets", ApiMethodArg.arg((String)"ticketList", List.class)),
    UPDATE_TICKETS_1(JobStatus.class, "updateTickets", ApiMethodArg.arg((String)"tickets", new Ticket[0].getClass())),
    UPDATE_TICKETS_ASYNC(ListenableFuture.class, "updateTicketsAsync", ApiMethodArg.arg((String)"ticketList", List.class)),
    UPDATE_TOPIC(Topic.class, "updateTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    UPDATE_TRIGGER(Trigger.class, "updateTrigger", ApiMethodArg.arg((String)"triggerId0", Long.class), ApiMethodArg.arg((String)"trigger", Trigger.class)),
    UPDATE_USER(User.class, "updateUser", ApiMethodArg.arg((String)"user", User.class)),
    UPDATE_USER_IDENTITY(Identity.class, "updateUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    UPDATE_USER_IDENTITY_1(Identity.class, "updateUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identity", Identity.class)),
    UPDATE_USER_SEGMENT(UserSegment.class, "updateUserSegment", ApiMethodArg.arg((String)"userSegment", UserSegment.class)),
    UPDATE_USERS(JobStatus.class, "updateUsers", ApiMethodArg.arg((String)"users", new User[0].getClass())),
    UPDATE_USERS_1(JobStatus.class, "updateUsers", ApiMethodArg.arg((String)"usersList", List.class)),
    UPDATE_USERS_ASYNC(ListenableFuture.class, "updateUsersAsync", ApiMethodArg.arg((String)"usersList", List.class)),
    VERIFY_USER_IDENTITY(Identity.class, "verifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    VERIFY_USER_IDENTITY_1(Identity.class, "verifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    VERIFY_USER_IDENTITY_2(Identity.class, "verifyUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE));

    private final ApiMethod apiMethod;

    private ZendeskApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(Zendesk.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

