/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.maven.dsl.yaml;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.apache.camel.maven.dsl.yaml.support.IndexerSupport;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.AntPathMatcher;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public abstract class GenerateYamlSupportMojo
extends AbstractMojo {
    public static final DotName LIST_CLASS = DotName.createSimple((String)"java.util.List");
    public static final DotName SET_CLASS = DotName.createSimple((String)"java.util.Set");
    public static final DotName STRING_CLASS = DotName.createSimple((String)"java.lang.String");
    public static final DotName CLASS_CLASS = DotName.createSimple((String)"java.lang.Class");
    public static final DotName DEPRECATED_ANNOTATION_CLASS = DotName.createSimple((String)"java.lang.Deprecated");
    public static final DotName XML_ROOT_ELEMENT_ANNOTATION_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlRootElement");
    public static final DotName XML_TYPE_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlType");
    public static final DotName XML_ENUM_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlEnum");
    public static final DotName XML_VALUE_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlValue");
    public static final DotName XML_ATTRIBUTE_ANNOTATION_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlAttribute");
    public static final DotName XML_VALUE_ANNOTATION_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlValue");
    public static final DotName XML_ELEMENT_ANNOTATION_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlElement");
    public static final DotName XML_ELEMENT_REF_ANNOTATION_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlElementRef");
    public static final DotName XML_ELEMENTS_ANNOTATION_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlElements");
    public static final DotName XML_TRANSIENT_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlTransient");
    public static final DotName XML_ANY_ELEMENT_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlAnyElement");
    public static final DotName XML_JAVA_TYPE_ADAPTER_CLASS = DotName.createSimple((String)"jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter");
    public static final DotName METADATA_ANNOTATION_CLASS = DotName.createSimple((String)"org.apache.camel.spi.Metadata");
    public static final DotName EXPRESSION_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.language.ExpressionDefinition");
    public static final DotName EXPRESSION_SUBELEMENT_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.ExpressionSubElementDefinition");
    public static final DotName HAS_EXPRESSION_TYPE_CLASS = DotName.createSimple((String)"org.apache.camel.model.HasExpressionType");
    public static final DotName OUTPUT_NODE_CLASS = DotName.createSimple((String)"org.apache.camel.model.OutputNode");
    public static final DotName PROCESSOR_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.ProcessorDefinition");
    public static final DotName SEND_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.SendDefinition");
    public static final DotName TO_DYNAMIC_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.ToDynamicDefinition");
    public static final DotName POLL_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.PollDefinition");
    public static final DotName ERROR_HANDLER_BUILDER_CLASS = DotName.createSimple((String)"org.apache.camel.builder.ErrorHandlerBuilder");
    public static final DotName VERB_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.rest.VerbDefinition");
    public static final DotName ID_AWARE_CLASS = DotName.createSimple((String)"org.apache.camel.spi.IdAware");
    public static final DotName ERROR_HANDLER_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.errorhandler.BaseErrorHandlerDefinition");
    public static final DotName REF_ERROR_HANDLER_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.errorhandler.RefErrorHandlerDefinition");
    public static final DotName YAML_TYPE_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.annotations.YamlType");
    public static final DotName YAML_IN_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.annotations.YamlIn");
    public static final DotName YAML_OUT_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.annotations.YamlOut");
    public static final DotName DSL_PROPERTY_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.annotations.DslProperty");
    public static final ClassName CN_DESERIALIZER_RESOLVER = ClassName.get((String)"org.apache.camel.dsl.yaml.common", (String)"YamlDeserializerResolver", (String[])new String[0]);
    public static final ClassName CN_DESERIALIZER_SUPPORT = ClassName.get((String)"org.apache.camel.dsl.yaml.common", (String)"YamlDeserializerSupport", (String[])new String[0]);
    public static final ClassName CN_DESERIALIZER_BASE = ClassName.get((String)"org.apache.camel.dsl.yaml.common", (String)"YamlDeserializerBase", (String[])new String[0]);
    public static final ClassName CN_ENDPOINT_AWARE_DESERIALIZER_BASE = ClassName.get((String)"org.apache.camel.dsl.yaml.common", (String)"YamlDeserializerEndpointAwareBase", (String[])new String[0]);
    public static final ClassName CN_DESERIALIZATION_CONTEXT = ClassName.get((String)"org.apache.camel.dsl.yaml.common", (String)"YamlDeserializationContext", (String[])new String[0]);
    public static final ClassName CN_YAML_SUPPORT = ClassName.get((String)"org.apache.camel.dsl.yaml.common", (String)"YamlSupport", (String[])new String[0]);
    public static final ClassName CN_YAML_TYPE = ClassName.get((String)"org.apache.camel.spi.annotations", (String)"YamlType", (String[])new String[0]);
    public static final ClassName CN_YAML_PROPERTY = ClassName.get((String)"org.apache.camel.spi.annotations", (String)"YamlProperty", (String[])new String[0]);
    public static final ClassName CN_YAML_PROPERTY_GROUP = ClassName.get((String)"org.apache.camel.spi.annotations", (String)"YamlPropertyGroup", (String[])new String[0]);
    public static final ClassName CN_YAML_IN = ClassName.get((String)"org.apache.camel.spi.annotations", (String)"YamlIn", (String[])new String[0]);
    public static final ClassName CN_EXPRESSION_DEFINITION = ClassName.get((String)"org.apache.camel.model.language", (String)"ExpressionDefinition", (String[])new String[0]);
    public static final ClassName CN_NODE = ClassName.get((String)"org.snakeyaml.engine.v2.nodes", (String)"Node", (String[])new String[0]);
    public static final ClassName CN_MAPPING_NODE = ClassName.get((String)"org.snakeyaml.engine.v2.nodes", (String)"MappingNode", (String[])new String[0]);
    public static final ClassName CN_NODE_TUPLE = ClassName.get((String)"org.snakeyaml.engine.v2.nodes", (String)"NodeTuple", (String[])new String[0]);
    public static final ClassName CN_SEQUENCE_NODE = ClassName.get((String)"org.snakeyaml.engine.v2.nodes", (String)"SequenceNode", (String[])new String[0]);
    public static final ClassName CN_PROCESSOR_DEFINITION = ClassName.get((String)"org.apache.camel.model", (String)"ProcessorDefinition", (String[])new String[0]);
    public static final Set<String> PRIMITIVE_CLASSES = new HashSet<String>(Arrays.asList(String.class.getName(), Character.class.getName(), Boolean.class.getName(), Byte.class.getName(), Short.class.getName(), Integer.class.getName(), Long.class.getName(), Float.class.getName(), Double.class.getName(), Character.TYPE.getName(), Boolean.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName()));
    private static final String XML_ANNOTATION_DEFAULT_VALUE = "##default";
    protected IndexView view;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter
    protected List<String> bannedDefinitions;
    @Parameter
    protected List<String> additionalDefinitions;

    protected static boolean hasAnnotation(ClassInfo target, DotName annotationName) {
        if (target == null) {
            return false;
        }
        return target.declaredAnnotation(annotationName) != null;
    }

    protected static boolean hasAnnotation(FieldInfo target, DotName annotationName) {
        if (target == null) {
            return false;
        }
        return target.annotation(annotationName) != null;
    }

    protected static boolean hasAnnotationValue(ClassInfo target, DotName annotationName, String name) {
        if (target == null) {
            return false;
        }
        return GenerateYamlSupportMojo.annotationValue(target.declaredAnnotation(annotationName), name).isPresent();
    }

    protected static Optional<AnnotationValue> annotationValue(AnnotationInstance instance, String name) {
        return instance != null ? Optional.ofNullable(instance.value(name)) : Optional.empty();
    }

    protected static Optional<AnnotationValue> annotationValue(ClassInfo target, DotName annotationName, String name) {
        if (target == null) {
            return Optional.empty();
        }
        return GenerateYamlSupportMojo.annotationValue(target.declaredAnnotation(annotationName), name);
    }

    protected static Optional<AnnotationValue> annotationValue(FieldInfo target, DotName annotationName, String name) {
        if (target == null) {
            return Optional.empty();
        }
        return GenerateYamlSupportMojo.annotationValue(target.annotation(annotationName), name);
    }

    private static Optional<AnnotationInstance> annotation(FieldInfo target, DotName annotationName) {
        if (target == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(target.annotation(annotationName));
    }

    protected static Stream<String> combine(String ... items) {
        TreeSet<String> answer = new TreeSet<String>();
        for (String item : items) {
            if (item == null) continue;
            String[] elements = item.split(",");
            answer.addAll(Arrays.asList(elements));
        }
        return answer.stream();
    }

    protected static AnnotationSpec yamlProperty(String name, String type, String oneOf) {
        return GenerateYamlSupportMojo.yamlProperty(name, type, false, false, oneOf);
    }

    protected static AnnotationSpec yamlProperty(String name, String type) {
        return GenerateYamlSupportMojo.yamlProperty(name, type, false, false, "");
    }

    protected static AnnotationSpec yamlProperty(String name, String type, boolean required, boolean deprecated, String oneOf) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)CN_YAML_PROPERTY);
        builder.addMember("name", "$S", new Object[]{name});
        builder.addMember("type", "$S", new Object[]{type});
        if (required) {
            builder.addMember("required", "$L", new Object[]{required});
        }
        if (deprecated) {
            builder.addMember("deprecated", "$L", new Object[]{deprecated});
        }
        if (!Strings.isNullOrEmpty((String)oneOf)) {
            builder.addMember("oneOf", "$S", new Object[]{oneOf});
        }
        return builder.build();
    }

    protected static AnnotationSpec yamlPropertyWithFormat(String name, String type, String format) {
        return GenerateYamlSupportMojo.yamlPropertyWithFormat(name, type, format, false, false);
    }

    protected static AnnotationSpec yamlPropertyWithFormat(String name, String type, String format, boolean required, boolean deprecated) {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)CN_YAML_PROPERTY);
        builder.addMember("name", "$S", new Object[]{name});
        builder.addMember("type", "$S", new Object[]{type});
        builder.addMember("format", "$S", new Object[]{format});
        if (required) {
            builder.addMember("required", "$L", new Object[]{required});
        }
        if (deprecated) {
            builder.addMember("deprecated", "$L", new Object[]{deprecated});
        }
        return builder.build();
    }

    protected static AnnotationSpec yamlPropertyWithSubtype(String name, String type, String subType, String oneOf) {
        return GenerateYamlSupportMojo.yamlPropertyWithSubtype(name, type, subType, false, oneOf);
    }

    protected static AnnotationSpec yamlPropertyWithSubtype(String name, String type, String subType, boolean required, String oneOf) {
        return GenerateYamlSupportMojo.yamlProperty(name, type + ":" + subType, required, false, oneOf);
    }

    protected static int getYamlTypeOrder(ClassInfo ci) {
        return GenerateYamlSupportMojo.annotationValue(ci, YAML_TYPE_ANNOTATION, "order").map(AnnotationValue::asInt).orElse(Integer.MAX_VALUE);
    }

    public void execute() throws MojoFailureException {
        this.view = IndexerSupport.get(this.project);
        this.generate();
    }

    protected abstract void generate() throws MojoFailureException;

    protected Stream<ClassInfo> implementors(DotName type) {
        return this.view.getAllKnownImplementors(type).stream();
    }

    protected Stream<ClassInfo> annotated(DotName type) {
        return this.view.getAnnotations(type).stream().map(AnnotationInstance::target).filter(t -> t.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass).filter(ci -> !this.isBanned((ClassInfo)ci));
    }

    protected Map<String, ClassInfo> elementsOf(DotName type) {
        TreeMap<String, ClassInfo> answer = new TreeMap<String, ClassInfo>();
        for (ClassInfo ci : this.view.getAllKnownSubclasses(type)) {
            AnnotationValue name;
            AnnotationInstance instance = ci.declaredAnnotation(XML_ROOT_ELEMENT_ANNOTATION_CLASS);
            if (instance == null || (name = instance.value("name")) == null) continue;
            answer.put(name.asString(), ci);
        }
        return Collections.unmodifiableMap(answer);
    }

    protected Class<?> loadClass(ClassInfo ci) {
        return this.loadClass(ci.name().toString());
    }

    protected Class<?> loadClass(String className) {
        try {
            return IndexerSupport.getClassLoader(this.project).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Stream<ClassInfo> all() {
        Stream<ClassInfo> discovered = Stream.of(XML_ROOT_ELEMENT_ANNOTATION_CLASS, XML_TYPE_CLASS).map(arg_0 -> ((IndexView)this.view).getAnnotations(arg_0)).flatMap(Collection::stream).map(AnnotationInstance::target).filter(at -> at.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass);
        Stream additional = this.additionalDefinitions != null ? this.additionalDefinitions.stream().map(DotName::createSimple).map(arg_0 -> ((IndexView)this.view).getClassByName(arg_0)) : Stream.empty();
        return Stream.concat(discovered, additional).filter(ci -> (ci.flags() & 0x400) == 0).filter(ci -> !this.isBanned((ClassInfo)ci)).filter(ci -> !ci.isEnum()).sorted(Comparator.comparing(o -> o.name().toString())).distinct();
    }

    protected Map<String, ClassInfo> models() {
        TreeMap<String, ClassInfo> answer = new TreeMap<String, ClassInfo>();
        this.annotated(XML_ROOT_ELEMENT_ANNOTATION_CLASS).forEach(i -> {
            TreeSet<String> labels;
            AnnotationInstance meta = i.declaredAnnotation(METADATA_ANNOTATION_CLASS);
            AnnotationInstance root = i.declaredAnnotation(XML_ROOT_ELEMENT_ANNOTATION_CLASS);
            if (meta == null || root == null) {
                return;
            }
            AnnotationValue name = root.value("name");
            AnnotationValue label = meta.value("label");
            if (name == null || label == null) {
                return;
            }
            if (this.bannedDefinitions != null) {
                for (String bannedDefinition : this.bannedDefinitions) {
                    if (!AntPathMatcher.INSTANCE.match(bannedDefinition.replace('.', '/'), i.name().toString('/'))) continue;
                    this.getLog().debug((CharSequence)("Skipping definition: " + i.name().toString()));
                    return;
                }
            }
            if ((labels = new TreeSet<String>(Arrays.asList(label.asString().split(",")))).contains("eip")) {
                answer.put(name.asString(), (ClassInfo)i);
            }
        });
        return answer;
    }

    protected Set<ClassInfo> definitions() {
        LinkedHashSet<ClassInfo> answer = new LinkedHashSet<ClassInfo>();
        LinkedHashSet<ClassInfo> discovered = new LinkedHashSet<ClassInfo>(this.models().values());
        for (ClassInfo type : discovered) {
            answer.addAll(this.definitions(type));
            if ((type.flags() & 0x400) != 0) continue;
            answer.add(type);
        }
        return answer;
    }

    protected Set<ClassInfo> definitions(ClassInfo ci) {
        ClassInfo sci;
        LinkedHashSet<ClassInfo> types = new LinkedHashSet<ClassInfo>();
        for (FieldInfo fi : ci.fields()) {
            ClassInfo fti;
            if (GenerateYamlSupportMojo.hasAnnotation(fi, XML_ELEMENTS_ANNOTATION_CLASS)) {
                AnnotationInstance[] elements;
                for (AnnotationInstance element : elements = fi.annotation(XML_ELEMENTS_ANNOTATION_CLASS).value().asNestedArray()) {
                    AnnotationValue type = element.value("type");
                    if (type == null) continue;
                    ClassInfo fti2 = this.view.getClassByName(fi.type().name());
                    types.addAll(this.definitions(fti2));
                    if ((fti2.flags() & 0x400) != 0) continue;
                    types.add(fti2);
                }
            }
            if (!GenerateYamlSupportMojo.hasAnnotation(fi, XML_ELEMENT_ANNOTATION_CLASS) && !GenerateYamlSupportMojo.hasAnnotation(fi, XML_ELEMENTS_ANNOTATION_CLASS) || fi.type().name().toString().startsWith("java.") || fi.type().name().toString().startsWith("sun.") || fi.type().kind() == Type.Kind.PARAMETERIZED_TYPE || (fti = this.view.getClassByName(fi.type().name())) == null) continue;
            types.addAll(this.definitions(fti));
            if ((fti.flags() & 0x400) != 0) continue;
            types.add(fti);
        }
        DotName superName = ci.superName();
        if (superName != null && (sci = this.view.getClassByName(superName)) != null) {
            types.addAll(this.definitions(sci));
            if ((sci.flags() & 0x400) == 0) {
                types.add(sci);
            }
        }
        return types;
    }

    protected Set<FieldInfo> fields(ClassInfo ci) {
        TreeSet<FieldInfo> fields = new TreeSet<FieldInfo>(Comparator.comparing(FieldInfo::name));
        ClassInfo current = ci;
        while (current != null) {
            fields.addAll(current.fields());
            DotName superName = current.superName();
            if (superName == null) break;
            current = this.view.getClassByName(superName);
        }
        return fields;
    }

    protected Set<MethodInfo> methods(ClassInfo ci) {
        TreeSet<MethodInfo> methods = new TreeSet<MethodInfo>(Comparator.comparing(MethodInfo::name));
        ClassInfo current = ci;
        while (current != null) {
            methods.addAll(current.methods());
            DotName superName = current.superName();
            if (superName == null) break;
            current = this.view.getClassByName(superName);
        }
        return methods;
    }

    @SafeVarargs
    protected final <T> Optional<T> firstPresent(Optional<T> ... optionals) {
        for (Optional<T> optional : optionals) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    protected String fieldName(FieldInfo field) {
        return this.fieldName(this.view.getClassByName(field.type().name()), field);
    }

    private Optional<String> getNameFromAnnotationOrRef(AnnotationInstance annotation, ClassInfo refClass, String emptyValue) {
        return GenerateYamlSupportMojo.annotationValue(annotation, "name").map(AnnotationValue::asString).filter(value -> !emptyValue.equals(value)).or(() -> GenerateYamlSupportMojo.annotationValue(refClass, XML_ROOT_ELEMENT_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(v -> !XML_ANNOTATION_DEFAULT_VALUE.equals(v)));
    }

    protected boolean isRequired(FieldInfo fi) {
        return this.firstPresent(GenerateYamlSupportMojo.annotationValue(fi, METADATA_ANNOTATION_CLASS, "required").map(AnnotationValue::asBoolean), GenerateYamlSupportMojo.annotationValue(fi, XML_VALUE_ANNOTATION_CLASS, "required").map(AnnotationValue::asBoolean), GenerateYamlSupportMojo.annotationValue(fi, XML_ATTRIBUTE_ANNOTATION_CLASS, "required").map(AnnotationValue::asBoolean)).orElse(false);
    }

    protected String getEnums(FieldInfo fi) {
        return GenerateYamlSupportMojo.annotationValue(fi, METADATA_ANNOTATION_CLASS, "enums").map(AnnotationValue::asString).orElse("");
    }

    protected String getJavaType(FieldInfo fi) {
        return GenerateYamlSupportMojo.annotationValue(fi, METADATA_ANNOTATION_CLASS, "javaType").map(AnnotationValue::asString).orElse("");
    }

    protected boolean isEnum(FieldInfo fi) {
        return !this.getEnums(fi).isBlank();
    }

    protected boolean isDeprecated(FieldInfo fi) {
        return fi.hasAnnotation(DEPRECATED_ANNOTATION_CLASS);
    }

    protected boolean extendsType(Type type, DotName superType) {
        return this.extendsType(this.view.getClassByName(type.name()), superType);
    }

    protected boolean extendsType(ClassInfo ci, DotName superType) {
        if (ci == null) {
            return false;
        }
        if (ci.name().equals((Object)superType)) {
            return true;
        }
        DotName superName = ci.superName();
        if (superName != null) {
            return this.extendsType(this.view.getClassByName(superName), superType);
        }
        return false;
    }

    protected boolean implementType(Type type, DotName interfaceType) {
        return this.implementType(this.view.getClassByName(type.name()), interfaceType);
    }

    protected boolean implementType(ClassInfo ci, DotName interfaceType) {
        if (ci == null) {
            return false;
        }
        if (ci.name().equals((Object)interfaceType)) {
            return true;
        }
        for (DotName name : ci.interfaceNames()) {
            if (!name.equals((Object)interfaceType)) continue;
            return true;
        }
        DotName superName = ci.superName();
        if (superName != null) {
            return this.implementType(this.view.getClassByName(superName), interfaceType);
        }
        return false;
    }

    protected boolean isBanned(ClassInfo ci) {
        if (this.bannedDefinitions != null) {
            for (String bannedDefinition : this.bannedDefinitions) {
                if (!AntPathMatcher.INSTANCE.match(bannedDefinition.replace('.', '/'), ci.name().toString('/'))) continue;
                this.getLog().debug((CharSequence)("Skipping definition: " + ci.name().toString()));
                return true;
            }
        }
        return false;
    }

    protected Stream<ClassInfo> implementsOrExtends(Type ci) {
        return Stream.concat(this.view.getAllKnownSubclasses(ci.name()).stream(), this.view.getAllKnownSubclasses(ci.name()).stream()).distinct().sorted(Comparator.comparing(ClassInfo::name));
    }

    protected String fieldName(ClassInfo ci, FieldInfo fi) {
        return this.firstPresent(GenerateYamlSupportMojo.annotation(fi, DSL_PROPERTY_ANNOTATION).flatMap(annotation -> this.getNameFromAnnotationOrRef((AnnotationInstance)annotation, ci, "")), GenerateYamlSupportMojo.annotationValue(fi, XML_ATTRIBUTE_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !XML_ANNOTATION_DEFAULT_VALUE.equals(value)), GenerateYamlSupportMojo.annotationValue(fi, XML_ELEMENT_ANNOTATION_CLASS, "name").map(AnnotationValue::asString).filter(value -> !XML_ANNOTATION_DEFAULT_VALUE.equals(value)), GenerateYamlSupportMojo.annotation(fi, XML_ELEMENT_REF_ANNOTATION_CLASS).flatMap(annotation -> this.getNameFromAnnotationOrRef((AnnotationInstance)annotation, ci, XML_ANNOTATION_DEFAULT_VALUE))).orElseGet(() -> ((FieldInfo)fi).name());
    }
}

