/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dsl.yaml.deserializers;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializationContext;
import org.apache.camel.dsl.yaml.common.YamlDeserializerSupport;
import org.apache.camel.dsl.yaml.common.exception.UnsupportedFieldException;
import org.apache.camel.dsl.yaml.common.exception.YamlDeserializationException;
import org.apache.camel.model.errorhandler.DeadLetterChannelDefinition;
import org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.NoErrorHandlerDefinition;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.spi.CamelContextCustomizer;
import org.apache.camel.spi.annotations.YamlIn;
import org.apache.camel.spi.annotations.YamlProperty;
import org.apache.camel.spi.annotations.YamlType;
import org.snakeyaml.engine.v2.api.ConstructNode;
import org.snakeyaml.engine.v2.nodes.MappingNode;
import org.snakeyaml.engine.v2.nodes.Node;
import org.snakeyaml.engine.v2.nodes.NodeTuple;

@YamlIn
@YamlType(inline=false, nodes={"error-handler", "errorHandler"}, order=0, properties={@YamlProperty(name="dead-letter-channel", type="object:org.apache.camel.model.errorhandler.DeadLetterChannelDefinition"), @YamlProperty(name="default-error-handler", type="object:org.apache.camel.model.errorhandler.DefaultErrorHandlerDefinition"), @YamlProperty(name="jta-transaction-error-handler", type="object:org.apache.camel.model.errorhandler.JtaTransactionErrorHandlerDefinition"), @YamlProperty(name="no-error-handler", type="object:org.apache.camel.model.errorhandler.NoErrorHandlerDefinition"), @YamlProperty(name="ref-error-handler", type="object:org.apache.camel.model.errorhandler.RefErrorHandlerDefinition"), @YamlProperty(name="spring-transaction-error-handler", type="object:org.apache.camel.model.errorhandler.SpringTransactionErrorHandlerDefinition")})
public class ErrorHandlerBuilderDeserializer
implements ConstructNode {
    private static CamelContextCustomizer customizer(final ErrorHandlerFactory builder) {
        return new CamelContextCustomizer(){

            public void configure(CamelContext camelContext) {
                ((ExtendedCamelContext)camelContext.adapt(ExtendedCamelContext.class)).setErrorHandlerFactory(builder);
            }
        };
    }

    public Object construct(Node node) {
        MappingNode bn = YamlDeserializerSupport.asMappingNode((Node)node);
        YamlDeserializationContext dc = YamlDeserializerSupport.getDeserializationContext((Node)node);
        Iterator iterator = bn.getValue().iterator();
        if (iterator.hasNext()) {
            NodeTuple tuple = (NodeTuple)iterator.next();
            String key = YamlDeserializerSupport.asText((Node)tuple.getKeyNode());
            Node val = tuple.getValueNode();
            YamlDeserializerSupport.setDeserializationContext((Node)val, (YamlDeserializationContext)dc);
            switch (key) {
                case "deadLetterChannel": 
                case "dead-letter-channel": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, DeadLetterChannelDefinition.class));
                }
                case "defaultErrorHandler": 
                case "default-error-handler": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, DefaultErrorHandlerDefinition.class));
                }
                case "jtaTransactionErrorHandler": 
                case "jta-transaction-error-handler": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, JtaTransactionErrorHandlerDefinition.class));
                }
                case "noErrorHandler": 
                case "no-error-handler": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, NoErrorHandlerDefinition.class));
                }
                case "refErrorHandler": 
                case "ref-error-handler": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, RefErrorHandlerDefinition.class));
                }
                case "springTransactionErrorHandler": 
                case "spring-transaction-error-handler": {
                    return ErrorHandlerBuilderDeserializer.customizer((ErrorHandlerFactory)YamlDeserializerSupport.asType((Node)val, JtaTransactionErrorHandlerDefinition.class));
                }
            }
            throw new UnsupportedFieldException(val, key);
        }
        throw new YamlDeserializationException(node, "Unable to determine the error handler type for the node");
    }
}

